/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.grid;

import com.google.common.math.IntMath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.littletiles.common.math.LittleUtils;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.vec.LittleVec;

public class LittleGrid {
    public static final int OVERALL_DEFAULT = 16;
    private static List<String> names;
    private static int[] grid_sizes;
    private static LittleGrid[] grids;
    private static int overallDefaultIndex;
    private static int defaultIndex;
    private static int base;
    private static int scale;
    private static int exponent;
    private static TextMapBuilder<LittleGrid> map;
    public final int count;
    public final long count2d;
    public final long count3d;
    public final double pixelLength;
    public final double halfPixelLength;
    public final double pixelVolume;
    protected final int index;
    public final boolean isDefault;
    public final LittleVec rotationCenter;
    public final int[] minSizes;

    public static void loadGrid(int base, int scale, int exponent, int defaultGrid) {
        int i;
        overallDefaultIndex = -1;
        defaultIndex = -1;
        LittleGrid.base = base;
        LittleGrid.scale = scale;
        LittleGrid.exponent = exponent;
        grids = new LittleGrid[scale];
        grid_sizes = new int[scale];
        int size = base;
        for (i = 0; i < grids.length; ++i) {
            LittleGrid.grid_sizes[i] = size;
            LittleGrid.grids[i] = new LittleGrid(size, i);
            if (LittleGrid.grids[i].isDefault) {
                overallDefaultIndex = i;
            }
            if (size == defaultGrid) {
                defaultIndex = i;
            }
            size *= exponent;
        }
        names = new ArrayList<String>();
        for (i = 0; i < grids.length; ++i) {
            names.add("" + LittleGrid.grids[i].count);
        }
        names = Collections.unmodifiableList(names);
        map = new TextMapBuilder().addComponent((Object[])grids, x -> Component.m_237113_((String)("" + x.count)));
    }

    public static int getScale() {
        return scale;
    }

    public static int getExponent() {
        return exponent;
    }

    public static List<String> names() {
        return names;
    }

    public static LittleGrid[] getGrids() {
        return grids;
    }

    public static TextMapBuilder<LittleGrid> mapBuilder() {
        return map;
    }

    public static LittleGrid overallDefault() {
        if (overallDefaultIndex != -1) {
            return grids[overallDefaultIndex];
        }
        return null;
    }

    public static LittleGrid get(int grid) {
        for (int i = 0; i < grids.length; ++i) {
            if (LittleGrid.grids[i].count != grid) continue;
            return grids[i];
        }
        throw new RuntimeException("Invalid gridsize = '" + grid + "'!");
    }

    public static LittleGrid defaultGrid() {
        if (defaultIndex != -1) {
            return grids[defaultIndex];
        }
        return null;
    }

    public static LittleGrid min() {
        return grids[0];
    }

    public static LittleGrid getMax() {
        return grids[grids.length - 1];
    }

    public static LittleGrid max(LittleGrid context, LittleGrid context2) {
        if (context.count >= context2.count) {
            return context;
        }
        return context2;
    }

    public static LittleGrid get(CompoundTag nbt) {
        if (nbt != null && nbt.m_128441_("grid")) {
            return LittleGrid.get(nbt.m_128451_("grid"));
        }
        return LittleGrid.overallDefault();
    }

    protected LittleGrid(int gridSize, int index) {
        this.index = index;
        this.count = gridSize;
        this.pixelLength = 1.0 / (double)gridSize;
        this.halfPixelLength = this.pixelLength * 0.5;
        this.count2d = (long)gridSize * (long)gridSize;
        this.count3d = (long)gridSize * this.count2d;
        this.pixelVolume = Math.max(Double.MIN_VALUE, 1.0 / (double)this.count3d);
        this.isDefault = 16 == gridSize;
        this.minSizes = new int[this.count];
        this.minSizes[0] = base;
        for (int i = 1; i < this.minSizes.length; ++i) {
            this.minSizes[i] = this.count / IntMath.gcd((int)i, (int)this.count);
            if (this.minSizes[i] >= base && this.minSizes[i] % base == 0) continue;
            this.minSizes[i] = this.count;
        }
        this.rotationCenter = new LittleVec(this.count, this.count, this.count);
    }

    public void set(CompoundTag nbt) {
        if (!this.isDefault) {
            nbt.m_128405_("grid", this.count);
        } else {
            nbt.m_128473_("grid");
        }
    }

    public int getIndex() {
        return this.index;
    }

    public int getMinGrid(int value) {
        return this.minSizes[Math.abs(value % this.count)];
    }

    public double toVanillaGrid(double grid) {
        return grid * this.pixelLength;
    }

    public float toVanillaGrid(float grid) {
        return (float)((double)grid * this.pixelLength);
    }

    public double toVanillaGrid(long grid) {
        return (double)grid * this.pixelLength;
    }

    public double toVanillaGrid(int grid) {
        return (double)grid * this.pixelLength;
    }

    public int toBlockOffset(long grid) {
        if (grid > 0L) {
            return (int)((double)grid * this.pixelLength);
        }
        return (int)Math.floor((double)grid * this.pixelLength);
    }

    public int toBlockOffset(int grid) {
        if (grid > 0) {
            return (int)((double)grid * this.pixelLength);
        }
        return (int)Math.floor((double)grid * this.pixelLength);
    }

    public boolean isAtEdge(double pos) {
        double result = pos % this.pixelLength;
        return LittleUtils.equals(result, 0.0) || LittleUtils.equals(result, this.pixelLength);
    }

    public int toGrid(int pos) {
        return pos * this.count;
    }

    public long toGridAccurate(double pos) {
        if ((pos = LittleUtils.round(pos * (double)this.count)) < 0.0) {
            return (long)Math.floor(pos);
        }
        return (long)pos;
    }

    public int toGrid(double pos) {
        if ((pos = LittleUtils.round(pos * (double)this.count)) < 0.0) {
            return (int)Math.floor(pos);
        }
        return (int)pos;
    }

    public String toString() {
        return "" + this.count;
    }

    public LittleBox box() {
        return new LittleBox(0, 0, 0, this.count, this.count, this.count);
    }

    public LittleGrid next() {
        if (this.index >= grids.length) {
            return null;
        }
        return grids[this.index + 1];
    }
}

