/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.signal.dialog;

import net.minecraft.network.chat.Component;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.collection.GuiComboBoxMapped;
import team.creative.creativecore.common.gui.controls.parent.GuiLeftRightBox;
import team.creative.creativecore.common.gui.controls.simple.GuiButton;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.gui.controls.simple.GuiTextfield;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.littletiles.common.gui.signal.IConditionConfiguration;
import team.creative.littletiles.common.gui.signal.dialog.GuiDialogSignal;
import team.creative.littletiles.common.structure.signal.logic.SignalMode;

public class GuiDialogSignalMode
extends GuiLayer {
    public IConditionConfiguration event;
    public SignalMode.GuiSignalModeConfiguration config;
    public GuiDialogSignal dialog;

    public GuiDialogSignalMode() {
        super("gui.dialog.signal.mode", 100, 100);
        this.registerEventChanged(this::changed);
        this.flow = GuiFlow.STACK_Y;
    }

    public void init(GuiDialogSignal dialog, IConditionConfiguration event) {
        this.event = event;
        this.dialog = dialog;
        this.config = event.getModeConfiguration().copy();
        super.init();
    }

    public void create() {
        if (this.event == null) {
            return;
        }
        GuiComboBoxMapped box = new GuiComboBoxMapped("mode", new TextMapBuilder().addComponent((Object[])SignalMode.values(), x -> Component.m_237115_((String)x.translateKey)));
        box.select((Object)this.event.getModeConfiguration().getMode());
        this.add(box.setExpandableX());
        GuiParent delayLine = new GuiParent((GuiFlow)GuiFlow.STACK_X);
        this.add(delayLine.setExpandableX());
        delayLine.add((GuiControl)new GuiLabel("delay_label").setTitle((Component)Component.m_237115_((String)"gui.delay").m_130946_(":")));
        delayLine.add(new GuiTextfield("delay", "" + this.config.delay).setNumbersOnly().setExpandableX());
        GuiParent panel = new GuiParent("panel", (GuiFlow)GuiFlow.STACK_Y);
        this.add(panel.setExpandable());
        GuiLeftRightBox bottom = new GuiLeftRightBox();
        this.add((GuiControl)bottom);
        bottom.addLeft((GuiControl)new GuiButton("cancel", x -> this.closeThisLayer()).setTranslate("gui.cancel"));
        bottom.addRight((GuiControl)new GuiButton("save", x -> {
            SignalMode mode = (SignalMode)((Object)((Object)box.getSelected()));
            GuiTextfield text = (GuiTextfield)this.get("delay");
            int delay = text.parseInteger();
            this.config = mode.parseControls((GuiParent)this, delay);
            if (this.config != null) {
                this.event.setModeConfiguration(this.config);
            }
            this.dialog.modeChanged();
            this.closeThisLayer();
        }).setTranslate("gui.save"));
        this.changed(new GuiControlChangedEvent((GuiControl)box));
    }

    public void changed(GuiControlChangedEvent event) {
        if (event.control.is("mode")) {
            GuiComboBoxMapped box = (GuiComboBoxMapped)event.control;
            SignalMode mode = (SignalMode)((Object)box.getSelected());
            GuiParent panel = (GuiParent)this.get("panel");
            panel.clear();
            mode.createControls(panel, this.config);
            this.reflow();
        }
    }
}

