/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.signal.node;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import team.creative.littletiles.common.gui.signal.GeneratePatternException;
import team.creative.littletiles.common.gui.signal.GuiSignalConnection;
import team.creative.littletiles.common.gui.signal.node.GuiSignalNode;
import team.creative.littletiles.common.structure.signal.input.SignalInputCondition;

public class GuiSignalNodeNotOperator
extends GuiSignalNode {
    public final boolean bitwise;
    private GuiSignalConnection from;
    private List<GuiSignalConnection> to = new ArrayList<GuiSignalConnection>();

    public GuiSignalNodeNotOperator(boolean bitwise) {
        super(bitwise ? "b-not" : "not");
        this.bitwise = bitwise;
    }

    @Override
    public boolean canConnectTo(GuiSignalNode node) {
        for (GuiSignalConnection connectTo : this.to) {
            if (connectTo.to() != node) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canConnectFrom(GuiSignalNode node) {
        return this.from == null;
    }

    @Override
    public GuiSignalConnection getConnectionTo(GuiSignalNode node) {
        for (GuiSignalConnection connectTo : this.to) {
            if (connectTo.to() != node) continue;
            return connectTo;
        }
        return null;
    }

    @Override
    public void disconnect(GuiSignalConnection connection) {
        if (connection.to() == this) {
            this.from = null;
        } else {
            this.to.remove(connection);
        }
    }

    @Override
    public Iterator<GuiSignalConnection> iterator() {
        return new Iterator<GuiSignalConnection>(){
            public int index = 0;
            public Iterator<GuiSignalConnection> iterator;
            {
                this.iterator = GuiSignalNodeNotOperator.this.to.iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.index == 0) {
                    return GuiSignalNodeNotOperator.this.from != null || this.iterator.hasNext();
                }
                if (this.index == 1) {
                    return this.iterator.hasNext();
                }
                return false;
            }

            @Override
            public GuiSignalConnection next() {
                if (this.index == 0) {
                    ++this.index;
                    if (GuiSignalNodeNotOperator.this.from != null) {
                        return GuiSignalNodeNotOperator.this.from;
                    }
                    ++this.index;
                    return this.iterator.next();
                }
                if (this.index == 1) {
                    return this.iterator.next();
                }
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Iterable<GuiSignalConnection> toConnections() {
        return this.to;
    }

    @Override
    public void connect(GuiSignalConnection connection) {
        if (connection.to() == this) {
            this.from = connection;
        } else {
            this.to.add(connection);
        }
    }

    @Override
    public void remove() {
        if (this.from != null) {
            this.from.disconnect(this.controller());
        }
        for (GuiSignalConnection connection : new ArrayList<GuiSignalConnection>(this.to)) {
            connection.disconnect(this.controller());
        }
    }

    @Override
    public int indexOf(GuiSignalConnection connection) {
        if (connection.to() == this) {
            return 0;
        }
        return this.to.indexOf(connection);
    }

    @Override
    public SignalInputCondition generateCondition(List<GuiSignalNode> processed) throws GeneratePatternException {
        this.reset();
        if (this.from == null) {
            throw new GeneratePatternException(this, "empty");
        }
        if (processed.contains(this)) {
            throw new GeneratePatternException(this, "circular");
        }
        processed.add(this);
        return this.bitwise ? new SignalInputCondition.SignalInputConditionNotBitwise(this.from.from().generateCondition(processed)) : new SignalInputCondition.SignalInputConditionNot(this.from.from().generateCondition(processed));
    }
}

