/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.structure;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.collection.GuiComboBoxMapped;
import team.creative.creativecore.common.gui.controls.collection.GuiStackSelector;
import team.creative.creativecore.common.gui.controls.inventory.GuiInventoryGrid;
import team.creative.creativecore.common.gui.controls.inventory.GuiPlayerInventoryGrid;
import team.creative.creativecore.common.gui.controls.parent.GuiLeftRightBox;
import team.creative.creativecore.common.gui.controls.simple.GuiButton;
import team.creative.creativecore.common.gui.controls.simple.GuiCounter;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.gui.controls.simple.GuiStateButtonMapped;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.sync.GuiSyncLocal;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.gui.LittleGuiUtils;
import team.creative.littletiles.common.item.ItemLittleBlueprint;
import team.creative.littletiles.common.structure.type.premade.LittleStructureBuilder;

public class GuiBuilder
extends GuiLayer {
    public LittleStructureBuilder builder;
    public final GuiSyncLocal<CompoundTag> CRAFT = this.getSyncHolder().register("craft", nbt -> {
        if (this.getPlayer().m_7500_() && this.builder.inventory.m_8020_(0).m_41619_() || this.builder.inventory.m_8020_(0).m_41720_() instanceof ItemLittleBlueprint) {
            int width = nbt.m_128451_("width");
            int height = nbt.m_128451_("height");
            int thickness = nbt.m_128451_("thickness");
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.m_128461_("block")));
            LittleGrid grid = LittleGrid.get(nbt.m_128451_("grid"));
            this.builder.lastBlockState = block.m_49966_();
            this.builder.lastSizeX = width;
            this.builder.lastSizeY = height;
            this.builder.lastThickness = thickness;
            this.builder.lastGrid = grid.count;
            this.builder.lastStructureType = nbt.m_128461_("type");
            this.builder.updateStructure();
            LittleStructureBuilder.LittleStructureBuilderType type = (LittleStructureBuilder.LittleStructureBuilderType)LittleStructureBuilder.REGISTRY.get(this.builder.lastStructureType);
            if (type != null) {
                ItemStack stack = this.builder.inventory.m_8020_(0);
                if (stack.m_41619_()) {
                    stack = new ItemStack((ItemLike)LittleTilesRegistry.BLUEPRINT.get());
                    this.builder.inventory.m_6836_(0, stack);
                }
                stack.m_41751_(LittleGroup.save(type.construct(grid, width, height, thickness, block.m_49966_())));
            }
        }
    });

    public GuiBuilder(LittleStructureBuilder builder) {
        super("structure_builder");
        this.builder = builder;
    }

    public void create() {
        this.flow = GuiFlow.STACK_Y;
        GuiParent config = new GuiParent((GuiFlow)GuiFlow.STACK_X);
        this.add(config.setExpandableX());
        config.add((GuiControl)new GuiLabel("widthLabel").setTranslate("gui.structure_builder.width"));
        config.add((GuiControl)new GuiLabel("heightLabel").setTranslate("gui.structure_builder.height"));
        config.add((GuiControl)new GuiLabel("thicknessLabel").setTranslate("gui.structure_builder.thickness"));
        config.add((GuiControl)new GuiCounter("width", this.builder.lastSizeX, 1, Integer.MAX_VALUE));
        config.add((GuiControl)new GuiCounter("height", this.builder.lastSizeY, 1, Integer.MAX_VALUE));
        config.add((GuiControl)new GuiCounter("thickness", this.builder.lastThickness, 1, Integer.MAX_VALUE));
        GuiComboBoxMapped box = new GuiComboBoxMapped("type", new TextMapBuilder().addEntrySet(LittleStructureBuilder.REGISTRY.entrySet(), x -> Component.m_237115_((String)("structure." + (String)x.getKey() + ".name"))));
        box.select((Object)((LittleStructureBuilder.LittleStructureBuilderType)LittleStructureBuilder.REGISTRY.get(this.builder.lastStructureType)));
        this.add(box.setExpandableX());
        this.add((GuiControl)new GuiStateButtonMapped("grid", LittleGrid.mapBuilder()));
        GuiStackSelector selector = new GuiStackSelector("preview", this.getPlayer(), LittleGuiUtils.getCollector(this.getPlayer()), true);
        selector.setSelectedForce(new ItemStack((ItemLike)this.builder.lastBlockState.m_60734_()));
        this.add(selector.setExpandableX());
        this.add((GuiControl)new GuiLeftRightBox().addLeft(new GuiLabel("failed").setTranslate("gui.structure_builder.failed").setVisible(false)).addRight((GuiControl)new GuiButton("craft", x -> {
            if (this.getPlayer().m_7500_() && this.builder.inventory.m_8020_(0).m_41619_() || this.builder.inventory.m_8020_(0).m_41720_() instanceof ItemLittleBlueprint) {
                this.get((String)"failed").visible = false;
                CompoundTag nbt = new CompoundTag();
                GuiCounter width = (GuiCounter)this.get("width");
                nbt.m_128405_("width", width.getValue());
                GuiCounter height = (GuiCounter)this.get("height");
                nbt.m_128405_("height", height.getValue());
                GuiCounter thickness = (GuiCounter)this.get("thickness");
                nbt.m_128405_("thickness", thickness.getValue());
                GuiComboBoxMapped type = (GuiComboBoxMapped)this.get("type");
                nbt.m_128359_("type", ((LittleStructureBuilder.LittleStructureBuilderType)type.getSelected()).type.id);
                GuiStateButtonMapped gridButton = (GuiStateButtonMapped)this.get("grid");
                LittleGrid grid = (LittleGrid)gridButton.getSelected();
                nbt.m_128405_("grid", grid.count);
                ItemStack stack = selector.getSelected();
                Block block = Block.m_49814_((Item)stack.m_41720_());
                nbt.m_128359_("block", block.m_204297_().m_205785_().m_135782_().toString());
                this.CRAFT.send((Tag)nbt);
            } else {
                this.get((String)"failed").visible = true;
            }
        }).setTranslate("gui.structure_builder.craft")));
        this.add((GuiControl)new GuiInventoryGrid("builder", (Container)this.builder.inventory));
        this.add((GuiControl)new GuiPlayerInventoryGrid(this.getPlayer()));
    }
}

