/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.tool;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.inventory.GuiInventoryGrid;
import team.creative.creativecore.common.gui.controls.inventory.GuiPlayerInventoryGrid;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.sync.GuiSyncLocal;
import team.creative.creativecore.common.util.inventory.ContainerSlotView;
import team.creative.creativecore.common.util.mc.LevelUtils;
import team.creative.creativecore.common.util.type.Color;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.api.common.ingredient.ILittleIngredientInventory;
import team.creative.littletiles.common.gui.controls.GuiColorProgressBar;
import team.creative.littletiles.common.gui.tool.GuiConfigure;
import team.creative.littletiles.common.ingredient.BlockIngredient;
import team.creative.littletiles.common.ingredient.BlockIngredientEntry;
import team.creative.littletiles.common.ingredient.ColorIngredient;
import team.creative.littletiles.common.ingredient.LittleIngredient;
import team.creative.littletiles.common.ingredient.LittleIngredients;
import team.creative.littletiles.common.ingredient.LittleInventory;
import team.creative.littletiles.common.ingredient.NotEnoughIngredientsException;
import team.creative.littletiles.common.item.ItemBlockIngredient;
import team.creative.littletiles.common.item.ItemColorIngredient;
import team.creative.littletiles.common.item.ItemLittleBag;

public class GuiBag
extends GuiConfigure {
    public SimpleContainer bagInventory;
    public LittleIngredients bag;
    public SimpleContainer input = new SimpleContainer(1);
    public final GuiSyncLocal<EndTag> RELOAD = this.getSyncHolder().register("reload", v -> {
        this.tool.changed();
        this.reinit();
    });
    public final GuiSyncLocal<StringTag> DROP_COLOR = this.getSyncHolder().register("drop_color", nbt -> {
        int amount;
        ItemColorIngredient.ColorIngredientType type = ItemColorIngredient.ColorIngredientType.getType(nbt.m_7916_());
        ColorIngredient color = this.bag.get(ColorIngredient.class);
        if (color != null && !color.isEmpty() && (amount = Math.min(type.getIngredient(color), ColorIngredient.BOTTLE_SIZE)) > 0) {
            type.setIngredient(color, type.getIngredient(color) - amount);
            Player player = this.getPlayer();
            LittleInventory inventory = new LittleInventory(player);
            ItemStack colorStack = ItemColorIngredient.generateItemStack(type, amount);
            if (!inventory.addStack(colorStack)) {
                LevelUtils.dropItem((Player)player, (ItemStack)colorStack);
            }
            ((ItemLittleBag)this.tool.get().m_41720_()).setInventory(this.tool.get(), this.bag, null);
            this.RELOAD.send((Tag)EndTag.f_128534_);
            this.tick();
        }
    });

    public GuiBag(ContainerSlotView view) {
        super("bag", view);
        this.registerEventClick(x -> {
            if (x.control instanceof GuiColorProgressBar) {
                this.DROP_COLOR.send((Tag)StringTag.m_129297_((String)x.control.name));
            }
        });
    }

    public void create() {
        this.RELOAD.send((Tag)EndTag.f_128534_);
        this.flow = GuiFlow.STACK_Y;
        this.tool.get().m_41784_();
        this.bag = ((ItemLittleBag)this.tool.get().m_41720_()).getInventory(this.tool.get());
        ColorIngredient unit = this.bag.get(ColorIngredient.class);
        GuiParent upper = new GuiParent((GuiFlow)GuiFlow.STACK_X);
        this.add(upper.setExpandableX());
        GuiParent left = new GuiParent();
        upper.add((GuiControl)left);
        GuiParent right = new GuiParent((GuiFlow)GuiFlow.STACK_Y);
        upper.add(right.setAlign(Align.STRETCH).setExpandableX());
        right.add((GuiControl)new GuiInventoryGrid("input", (Container)this.input).addListener(x -> {
            Player player = this.getPlayer();
            ItemStack input = this.input.m_8020_(0);
            if (input.m_41720_() instanceof ILittleIngredientInventory) {
                LittleIngredients ingredients = ((ILittleIngredientInventory)input.m_41720_()).getInventory(input);
                boolean containsBlocks = ingredients.contains(BlockIngredient.class);
                boolean containsColor = ingredients.contains(ColorIngredient.class);
                LittleIngredients remaining = this.bag.add(ingredients);
                ((ItemLittleBag)this.tool.get().m_41720_()).setInventory(this.tool.get(), this.bag, null);
                if (remaining == null) {
                    remaining = new LittleIngredients();
                }
                if (remaining.copy().sub(ingredients.copy()) != null) {
                    if (containsBlocks) {
                        this.updateSlots();
                        player.m_5496_(SoundEvents.f_12015_, 1.0f, 1.0f);
                    }
                    if (containsColor) {
                        player.m_5496_(SoundEvents.f_11772_, 1.0f, 1.0f);
                        this.RELOAD.send((Tag)EndTag.f_128534_);
                    }
                }
                ((ILittleIngredientInventory)input.m_41720_()).setInventory(input, remaining, null);
            } else {
                LittleIngredients ingredients = LittleIngredient.extractWithoutCount(input, true);
                if (ingredients != null) {
                    ingredients.scale(input.m_41613_());
                    boolean containsBlocks = ingredients.contains(BlockIngredient.class);
                    boolean containsColor = ingredients.contains(ColorIngredient.class);
                    LittleIngredients overflow = this.bag.add(ingredients);
                    if (overflow == null || !overflow.contains(BlockIngredient.class) && !overflow.contains(ColorIngredient.class)) {
                        input.m_41764_(0);
                        ((ItemLittleBag)this.tool.get().m_41720_()).setInventory(this.tool.get(), this.bag, null);
                        LittleInventory inventory = new LittleInventory(player);
                        try {
                            if (overflow != null) {
                                inventory.give(overflow);
                            }
                        }
                        catch (NotEnoughIngredientsException.NotEnoughSpaceException notEnoughSpaceException) {
                            // empty catch block
                        }
                        if (containsBlocks) {
                            this.updateSlots();
                            player.m_5496_(SoundEvents.f_12015_, 1.0f, 1.0f);
                        }
                        if (containsColor) {
                            player.m_5496_(SoundEvents.f_11772_, 1.0f, 1.0f);
                            this.RELOAD.send((Tag)EndTag.f_128534_);
                        }
                    } else {
                        this.bag = ((ItemLittleBag)this.tool.get().m_41720_()).getInventory(this.tool.get());
                    }
                }
            }
        }));
        right.add((GuiControl)new GuiColorProgressBar("black", unit.black, ItemLittleBag.colorUnitMaximum, Color.BLACK));
        right.add((GuiControl)new GuiColorProgressBar("cyan", unit.cyan, ItemLittleBag.colorUnitMaximum, Color.CYAN));
        right.add((GuiControl)new GuiColorProgressBar("magenta", unit.magenta, ItemLittleBag.colorUnitMaximum, Color.MAGENTA));
        right.add((GuiControl)new GuiColorProgressBar("yellow", unit.yellow, ItemLittleBag.colorUnitMaximum, Color.YELLOW));
        this.bag = ((ItemLittleBag)this.tool.get().m_41720_()).getInventory(this.tool.get());
        List<BlockIngredientEntry> inventory = this.bag.get(BlockIngredient.class).getContent();
        this.bagInventory = new SimpleContainer(ItemLittleBag.inventorySize){

            public int m_6893_() {
                return ItemLittleBag.maxStackSizeOfTiles;
            }
        };
        left.add((GuiControl)new GuiInventoryGrid(this.name, (Container)this.bagInventory, ItemLittleBag.inventoryWidth, ItemLittleBag.inventoryHeight, (c, i) -> new Slot((Container)c, (int)i, 0, 0){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }
        }).addListener(x -> this.updateSlots()));
        for (int i2 = 0; i2 < inventory.size(); ++i2) {
            ItemStack stack = new ItemStack((ItemLike)LittleTilesRegistry.BLOCK_INGREDIENT.get());
            stack.m_41784_();
            ItemBlockIngredient.saveIngredient(stack, inventory.get(i2));
            this.bagInventory.m_6836_(i2, stack);
        }
        this.add((GuiControl)new GuiPlayerInventoryGrid(this.getPlayer()).disableSlot(this.tool.index));
    }

    public void updateSlots() {
        List<BlockIngredientEntry> inventory = this.bag.get(BlockIngredient.class).getContent();
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack stack = new ItemStack((ItemLike)LittleTilesRegistry.BLOCK_INGREDIENT.get());
            stack.m_41784_();
            ItemBlockIngredient.saveIngredient(stack, inventory.get(i));
            this.bagInventory.m_6836_(i, stack);
        }
    }

    @Override
    public CompoundTag saveConfiguration(CompoundTag nbt) {
        ItemStack stack = this.input.m_8020_(0);
        if (!stack.m_41619_()) {
            this.getPlayer().m_36176_(stack, true);
        }
        return null;
    }
}

