/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.tool;

import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.simple.GuiButton;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.inventory.ContainerSlotView;
import team.creative.littletiles.LittleTilesGuiRegistry;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.gui.tool.GuiConfigure;
import team.creative.littletiles.common.item.ItemLittleGlove;

public abstract class GuiGlove
extends GuiConfigure {
    public final ItemLittleGlove.GloveMode mode;
    public final ItemLittleGlove.GloveMode before;
    public final ItemLittleGlove.GloveMode after;
    public LittleGrid grid;

    public GuiGlove(ItemLittleGlove.GloveMode mode, ContainerSlotView view, int width, int height, LittleGrid grid) {
        super("glove", width, height, view);
        this.mode = mode;
        this.grid = grid;
        ArrayList modes = new ArrayList(ItemLittleGlove.MODES.values());
        int index = modes.indexOf(mode);
        this.before = index == 0 ? (ItemLittleGlove.GloveMode)modes.get(modes.size() - 1) : (ItemLittleGlove.GloveMode)modes.get(index - 1);
        this.after = index == modes.size() - 1 ? (ItemLittleGlove.GloveMode)modes.get(0) : (ItemLittleGlove.GloveMode)modes.get(index + 1);
    }

    @Override
    public CompoundTag saveConfiguration(CompoundTag nbt) {
        ItemLittleGlove.setMode(this.tool.get(), this.mode);
        return null;
    }

    public void openNewGui(ItemLittleGlove.GloveMode mode) {
        ItemLittleGlove.setMode(this.tool.get(), mode);
        LittleTilesGuiRegistry.OPEN_CONFIG.open(this.getPlayer());
    }

    public void create() {
        GuiParent upperBar = new GuiParent((GuiFlow)GuiFlow.STACK_X);
        this.add(upperBar.setExpandableX());
        upperBar.add((GuiControl)new GuiButton("<<", x -> this.openNewGui(this.before)).setTranslate("gui.previous"));
        upperBar.add(new GuiLabel("name").setTranslate(this.mode.title).setExpandableX());
        upperBar.add((GuiControl)new GuiButton(">>", x -> this.openNewGui(this.after)).setTranslate("gui.previous"));
    }
}

