/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.tool;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.collection.GuiComboBoxMapped;
import team.creative.creativecore.common.gui.controls.collection.GuiStackSelector;
import team.creative.creativecore.common.gui.controls.parent.GuiScrollY;
import team.creative.creativecore.common.gui.controls.simple.GuiCheckBox;
import team.creative.creativecore.common.gui.controls.simple.GuiColorPicker;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.filter.BiFilter;
import team.creative.creativecore.common.util.inventory.ContainerSlotView;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.creativecore.common.util.type.Color;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;
import team.creative.littletiles.common.filter.TileFilters;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.gui.LittleGuiUtils;
import team.creative.littletiles.common.gui.controls.GuiGridConfig;
import team.creative.littletiles.common.gui.tool.GuiConfigureTool;
import team.creative.littletiles.common.item.ItemLittleHammer;
import team.creative.littletiles.common.item.ItemLittlePaintBrush;
import team.creative.littletiles.common.item.ItemMultiTiles;
import team.creative.littletiles.common.placement.shape.LittleShape;
import team.creative.littletiles.common.placement.shape.ShapeRegistry;

public class GuiPaintBrush
extends GuiConfigureTool {
    public GuiPaintBrush(ContainerSlotView view) {
        super("paint_brush", 140, 200, view);
        this.registerEventChanged(x -> {
            if (x.control.is("shape")) {
                this.onChange();
            }
        });
        this.flow = GuiFlow.STACK_Y;
        this.align = Align.STRETCH;
    }

    @Override
    public CompoundTag saveConfiguration(CompoundTag nbt) {
        GuiComboBoxMapped box = (GuiComboBoxMapped)this.get("shape");
        GuiScrollY scroll = (GuiScrollY)this.get("settings");
        LittleShape shape = (LittleShape)box.getSelected();
        nbt.m_128359_("shape", shape.getKey());
        shape.saveCustomSettings((GuiParent)scroll, nbt, this.getGrid());
        GuiColorPicker picker = (GuiColorPicker)this.get("picker", GuiColorPicker.class);
        nbt.m_128405_("color", picker.color.toInt());
        GuiStackSelector filter = (GuiStackSelector)this.get("filter", GuiStackSelector.class);
        ItemLittleHammer.setFilter(!((GuiCheckBox)this.get((String)"any")).value, TileFilters.block(Block.m_49814_((Item)filter.getSelected().m_41720_())));
        return nbt;
    }

    public void create() {
        Color color = new Color(ItemLittlePaintBrush.getColor(this.tool.get()));
        this.add((GuiControl)new GuiColorPicker("picker", color, LittleTiles.CONFIG.isTransparencyEnabled(this.getPlayer()), LittleTiles.CONFIG.getMinimumTransparency(this.getPlayer())));
        GuiComboBoxMapped box = new GuiComboBoxMapped("shape", new TextMapBuilder().addComponent((Iterable)ShapeRegistry.REGISTRY.values(), x -> Component.m_237115_((String)x.getTranslatableName())));
        box.select((Object)ItemLittleHammer.getShape(this.tool.get()));
        GuiScrollY scroll = new GuiScrollY("settings").setExpandable();
        this.add((GuiControl)box);
        this.add((GuiControl)scroll);
        this.add((GuiControl)new GuiGridConfig("grid", ItemMultiTiles.currentGrid, x -> {
            ItemMultiTiles.currentGrid = x;
            if (ItemLittlePaintBrush.selection != null) {
                ItemLittlePaintBrush.selection.convertTo((LittleGrid)x);
            }
        }));
        BiFilter<IParentCollection, LittleTile> selector = ItemLittleHammer.getFilter();
        boolean activeFilter = ItemLittleHammer.isFiltered();
        this.add((GuiControl)new GuiCheckBox("any", selector == null || !activeFilter).setTranslate("gui.any"));
        GuiStackSelector guiSelector = new GuiStackSelector("filter", this.getPlayer(), LittleGuiUtils.getCollector(this.getPlayer()));
        if (selector instanceof TileFilters.TileBlockStateFilter) {
            TileFilters.TileBlockStateFilter stateFilter = (TileFilters.TileBlockStateFilter)selector;
            guiSelector.setSelectedForce(new ItemStack((ItemLike)stateFilter.state.m_60734_()));
        } else if (selector instanceof TileFilters.TileBlockFilter) {
            TileFilters.TileBlockFilter blockFilter = (TileFilters.TileBlockFilter)selector;
            guiSelector.setSelectedForce(new ItemStack((ItemLike)blockFilter.block));
        }
        this.add((GuiControl)guiSelector);
        this.onChange();
    }

    public void onChange() {
        GuiComboBoxMapped box = (GuiComboBoxMapped)this.get("shape");
        GuiScrollY scroll = (GuiScrollY)this.get("settings", GuiScrollY.class);
        LittleShape shape = (LittleShape)box.getSelected((Object)ShapeRegistry.TILE_SHAPE);
        scroll.clear();
        for (GuiControl control : shape.getCustomSettings(this.tool.get().m_41783_(), this.getGrid())) {
            scroll.add(control);
        }
        this.reflow();
    }
}

