/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.tool;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.controls.collection.GuiStackSelector;
import team.creative.creativecore.common.gui.controls.parent.GuiLeftRightBox;
import team.creative.creativecore.common.gui.controls.simple.GuiButton;
import team.creative.creativecore.common.gui.controls.simple.GuiCheckBox;
import team.creative.creativecore.common.gui.controls.simple.GuiColorPicker;
import team.creative.creativecore.common.gui.dialog.DialogGuiLayer;
import team.creative.creativecore.common.gui.dialog.GuiDialogHandler;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.integration.IGuiIntegratedParent;
import team.creative.creativecore.common.util.filter.BiFilter;
import team.creative.creativecore.common.util.inventory.ContainerSlotView;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.type.Color;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.common.action.LittleAction;
import team.creative.littletiles.common.action.LittleActionColorBoxes;
import team.creative.littletiles.common.action.LittleActionDestroyBoxes;
import team.creative.littletiles.common.action.LittleActionException;
import team.creative.littletiles.common.action.LittleActionPlace;
import team.creative.littletiles.common.action.LittleActions;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.group.LittleGroupAbsolute;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;
import team.creative.littletiles.common.filter.TileFilters;
import team.creative.littletiles.common.gui.LittleGuiUtils;
import team.creative.littletiles.common.gui.tool.GuiConfigure;
import team.creative.littletiles.common.level.LittleLevelScanner;
import team.creative.littletiles.common.math.box.collection.LittleBoxes;
import team.creative.littletiles.common.placement.PlacementPreview;

public class GuiScrewdriver
extends GuiConfigure {
    public static ItemStack lastSelectedSearchStack;
    public static ItemStack lastSelectedReplaceStack;

    public GuiScrewdriver(ContainerSlotView view) {
        super("screwdriver", 200, 205, view);
        this.flow = GuiFlow.STACK_Y;
    }

    public void create() {
        this.tool.get().m_41784_();
        this.add((GuiControl)new GuiCheckBox("any", false).setTranslate("gui.any"));
        GuiStackSelector selector = new GuiStackSelector("filter", this.getPlayer(), LittleGuiUtils.getCollector(this.getPlayer()), true);
        if (lastSelectedSearchStack != null) {
            selector.setSelectedForce(lastSelectedSearchStack);
        }
        this.add(selector.setExpandableX());
        this.add((GuiControl)new GuiCheckBox("remove", false).setTranslate("gui.remove"));
        this.add((GuiControl)new GuiCheckBox("replace", false).setTranslate("gui.replace_with"));
        selector = new GuiStackSelector("replacement", this.getPlayer(), LittleGuiUtils.getCollector(this.getPlayer()), true);
        if (lastSelectedReplaceStack != null) {
            selector.setSelectedForce(lastSelectedReplaceStack);
        }
        this.add(selector.setExpandableX());
        Color color = new Color(255, 255, 255, 255);
        this.add((GuiControl)new GuiCheckBox("colorize", false).setTranslate("gui.colorize"));
        this.add(new GuiColorPicker("picker", color, LittleTiles.CONFIG.isTransparencyEnabled(this.getPlayer()), LittleTiles.CONFIG.getMinimumTransparency(this.getPlayer())).setExpandableX());
        GuiLeftRightBox actions = new GuiLeftRightBox().addLeft((GuiControl)new GuiButton("undo", x -> {
            try {
                LittleTilesClient.ACTION_HANDLER.undo();
            }
            catch (LittleActionException e) {
                this.getPlayer().m_213846_((Component)Component.m_237113_((String)e.getLocalizedMessage()));
            }
        }).setTranslate("gui.undo")).addLeft((GuiControl)new GuiButton("redo", x -> {
            try {
                LittleTilesClient.ACTION_HANDLER.redo();
            }
            catch (LittleActionException e) {
                this.getPlayer().m_213846_((Component)Component.m_237113_((String)e.getLocalizedMessage()));
            }
        }).setTranslate("gui.redo")).addRight((GuiControl)new GuiButton("run", x -> {
            LittleAction action = this.getDesiredAction();
            if (action != null && action.wasSuccessful(LittleTilesClient.ACTION_HANDLER.execute(action))) {
                GuiScrewdriver.playSound((SoundEvent)SoundEvents.f_12088_);
            }
        }).setTranslate("gui.run"));
        this.add((GuiControl)actions);
    }

    public LittleAction getDesiredAction() {
        GuiStackSelector replacement;
        ItemStack stackReplace;
        GuiStackSelector selector;
        Block filterBlock;
        int[] array = this.tool.get().m_41784_().m_128465_("pos1");
        if (array.length != 3) {
            return null;
        }
        BlockPos pos = new BlockPos(array[0], array[1], array[2]);
        array = this.tool.get().m_41784_().m_128465_("pos2");
        if (array.length != 3) {
            return null;
        }
        BlockPos pos2 = new BlockPos(array[0], array[1], array[2]);
        BiFilter<IParentCollection, LittleTile> filter = ((GuiCheckBox)this.get((String)"any")).value ? TileFilters.and(new BiFilter[0]) : ((filterBlock = Block.m_49814_((Item)(selector = (GuiStackSelector)this.get("filter")).getSelected().m_41720_())) != null && !(filterBlock instanceof AirBlock) ? TileFilters.block(filterBlock) : TileFilters.and(new BiFilter[0]));
        Level level = this.getPlayer().f_19853_;
        filter = TileFilters.and(TileFilters.noStructure(), filter);
        LittleBoxes boxes = LittleLevelScanner.scan(level, pos, pos2, filter);
        if (boxes.isEmpty()) {
            return null;
        }
        boolean remove = ((GuiCheckBox)this.get((String)"remove")).value;
        boolean replace = ((GuiCheckBox)this.get((String)"replace")).value;
        boolean colorize = ((GuiCheckBox)this.get((String)"colorize")).value;
        if (remove) {
            return new LittleActionDestroyBoxes(level, boxes);
        }
        ArrayList<LittleAction> actions = new ArrayList<LittleAction>();
        if (replace && (stackReplace = (replacement = (GuiStackSelector)this.get("replacement")).getSelected()) != null) {
            Block replacementBlock = Block.m_49814_((Item)stackReplace.m_41720_());
            if (!LittleAction.isBlockValid(replacementBlock.m_49966_())) {
                GuiDialogHandler.openDialog((IGuiIntegratedParent)this.getIntegratedParent(), (String)"screwdriver_dialog", (MutableComponent)Component.m_237115_((String)"dialog.screwdriver.invalid_replacement"), (x, y) -> {}, (DialogGuiLayer.DialogButton[])new DialogGuiLayer.DialogButton[]{DialogGuiLayer.DialogButton.OK});
                return null;
            }
            actions.add(new LittleActionDestroyBoxes(level, boxes));
            LittleGroupAbsolute previews = new LittleGroupAbsolute(pos);
            previews.add(boxes.grid, new LittleElement(replacementBlock.m_49966_(), -1), boxes);
            actions.add(new LittleActionDestroyBoxes(level, boxes));
            actions.add(new LittleActionPlace(LittleActionPlace.PlaceAction.ABSOLUTE, PlacementPreview.absolute(level, ItemStack.f_41583_, previews, Facing.EAST)));
        }
        if (colorize) {
            GuiColorPicker picker = (GuiColorPicker)this.get("picker");
            actions.add(new LittleActionColorBoxes(level, boxes, picker.color.toInt(), false));
        }
        if (!actions.isEmpty()) {
            return new LittleActions(actions.toArray(new LittleAction[0]));
        }
        if (!(remove || replace || colorize)) {
            GuiDialogHandler.openDialog((IGuiIntegratedParent)this.getIntegratedParent(), (String)"screwdriver_dialog", (MutableComponent)Component.m_237115_((String)"dialog.screwdriver.no_task"), (x, y) -> {}, (DialogGuiLayer.DialogButton[])new DialogGuiLayer.DialogButton[]{DialogGuiLayer.DialogButton.OK});
        }
        return null;
    }

    @Override
    public CompoundTag saveConfiguration(CompoundTag nbt) {
        if (this.isClient()) {
            lastSelectedSearchStack = ((GuiStackSelector)this.get("filter")).getSelected();
            lastSelectedReplaceStack = ((GuiStackSelector)this.get("replacement")).getSelected();
        }
        return null;
    }
}

