/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.ingredient;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import team.creative.creativecore.common.util.mc.LanguageUtils;
import team.creative.creativecore.common.util.mc.TooltipUtils;
import team.creative.creativecore.common.util.text.TextBuilder;
import team.creative.creativecore.common.util.type.map.LinkedHashMapDouble;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.ingredient.BlockIngredientEntry;
import team.creative.littletiles.common.ingredient.LittleIngredient;

public class BlockIngredient
extends LittleIngredient<BlockIngredient>
implements Iterable<BlockIngredientEntry> {
    private int maxEntries = -1;
    private double maxVolume = -1.0;
    private List<BlockIngredientEntry> content = new ArrayList<BlockIngredientEntry>();

    public BlockIngredient setLimits(int maxEntries, double maxVolume) {
        this.maxEntries = maxEntries;
        this.maxVolume = maxVolume;
        return this;
    }

    @Override
    public BlockIngredient add(BlockIngredient ingredient) {
        BlockIngredient remaings = null;
        for (BlockIngredientEntry entry : ingredient.content) {
            BlockIngredientEntry remaing = this.add(entry);
            if (remaing == null) continue;
            if (remaings == null) {
                remaings = new BlockIngredient();
            }
            remaings.add(remaing);
        }
        return remaings;
    }

    @Override
    public BlockIngredient sub(BlockIngredient ingredient) {
        BlockIngredient remaings = null;
        for (BlockIngredientEntry entry : ingredient.content) {
            BlockIngredientEntry remaing = this.sub(entry);
            if (remaing == null) continue;
            if (remaings == null) {
                remaings = new BlockIngredient();
            }
            remaings.add(remaing);
        }
        return remaings;
    }

    @Override
    public BlockIngredientEntry add(BlockIngredientEntry ingredient) {
        if (ingredient == null || ingredient.isEmpty()) {
            return null;
        }
        for (int i = 0; i < this.content.size(); ++i) {
            BlockIngredientEntry entry = this.content.get(i);
            if (!entry.equals(ingredient)) continue;
            entry.value += ingredient.value;
            if (this.maxVolume != -1.0 && entry.value > this.maxVolume) {
                BlockIngredientEntry remaining = entry.copy();
                remaining.value = entry.value - this.maxVolume;
                entry.value = this.maxVolume;
                ingredient = remaining;
                continue;
            }
            return null;
        }
        if (this.maxEntries == -1 || this.content.size() < this.maxEntries) {
            this.content.add(ingredient.copy());
            return null;
        }
        return ingredient;
    }

    @Override
    public BlockIngredientEntry sub(BlockIngredientEntry ingredient) {
        if (ingredient == null || ingredient.isEmpty()) {
            return null;
        }
        for (int i = this.content.size() - 1; i >= 0; --i) {
            BlockIngredientEntry entry = this.content.get(i);
            if (!entry.equals(ingredient)) continue;
            entry.value -= ingredient.value;
            if (entry.value <= 0.0) {
                this.content.remove(i);
                if (entry.value < 0.0) {
                    ingredient = entry;
                    ingredient.value = -ingredient.value;
                    continue;
                }
            }
            return null;
        }
        return ingredient;
    }

    @Override
    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    @Override
    public BlockIngredient copy() {
        BlockIngredient copy = new BlockIngredient();
        copy.maxEntries = this.maxEntries;
        copy.maxVolume = this.maxVolume;
        this.content.forEach(x -> copy.add(x.copy()));
        return copy;
    }

    @Override
    public TextBuilder toText() {
        TextBuilder text = new TextBuilder();
        for (BlockIngredientEntry entry : this.content) {
            ItemStack stack = entry.getBlockStack();
            text.stack(stack);
            text.add(stack.m_41611_());
        }
        return text;
    }

    @Override
    public void scale(int count) {
        for (BlockIngredientEntry entry : this.content) {
            entry.scale(count);
        }
    }

    @Override
    public void scaleAdvanced(double scale) {
        for (BlockIngredientEntry entry : this.content) {
            entry.scaleAdvanced(scale);
        }
    }

    protected LinkedHashMapDouble<BlockIngredientEntry> getCombinedEntries() {
        LinkedHashMapDouble map = new LinkedHashMapDouble();
        for (BlockIngredientEntry entry : this.content) {
            map.put((Object)entry, Double.valueOf(entry.value));
        }
        return map;
    }

    public boolean isVolumeLimited() {
        return this.maxVolume > 0.0;
    }

    @Override
    public int getMinimumCount(BlockIngredient other, int availableCount) {
        int count = -1;
        LinkedHashMapDouble<BlockIngredientEntry> thisEntries = this.getCombinedEntries();
        LinkedHashMapDouble<BlockIngredientEntry> otherEntries = other.getCombinedEntries();
        for (Map.Entry entry : thisEntries.entrySet()) {
            Double value = (Double)otherEntries.get(entry.getKey());
            if (value == null) continue;
            count = (int)Math.ceil(Math.max((double)count, (Double)entry.getValue() / value));
        }
        return Math.min(count, availableCount);
    }

    @Override
    public Iterator<BlockIngredientEntry> iterator() {
        return this.content.iterator();
    }

    public List<BlockIngredientEntry> getContent() {
        return this.content;
    }

    @Override
    public void print(TextBuilder text) {
        if (this.content.size() <= 4) {
            for (BlockIngredientEntry entry : this.content) {
                ItemStack stack = entry.getBlockStack();
                text.stack(stack).text(" " + BlockIngredient.printVolume(entry.value, false) + " " + stack.m_41611_()).newLine();
            }
        } else {
            for (BlockIngredientEntry entry : this.content) {
                text.stack(entry.getBlockStack()).text(" " + BlockIngredient.printVolume(entry.value, false) + " ");
            }
        }
    }

    public String toString() {
        return this.content.toString();
    }

    public static Component printVolume(double volume, boolean extended) {
        Object text = "";
        int fullBlocks = (int)volume;
        int pixels = (int)Math.ceil((volume - (double)fullBlocks) * (double)LittleGrid.defaultGrid().count3d);
        if (fullBlocks > 0) {
            text = (String)text + TooltipUtils.print((int)fullBlocks) + (String)(extended ? " " + (fullBlocks == 1 ? LanguageUtils.translate((String)"volume.unit.big.single") : LanguageUtils.translate((String)"volume.unit.big.multiple")) : LanguageUtils.translate((String)"volume.unit.big.short"));
        }
        if (pixels > 0) {
            if (fullBlocks > 0) {
                text = (String)text + " ";
            }
            text = (String)text + TooltipUtils.print((int)pixels) + (String)(extended ? " " + (pixels == 1 ? LanguageUtils.translate((String)"volume.unit.small.single") : LanguageUtils.translate((String)"volume.unit.small.multiple")) : LanguageUtils.translate((String)"volume.unit.small.short"));
        }
        return Component.m_237113_((String)text);
    }
}

