/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.item;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.api.common.ingredient.ILittleIngredientInventory;
import team.creative.littletiles.common.ingredient.ColorIngredient;
import team.creative.littletiles.common.ingredient.LittleIngredient;
import team.creative.littletiles.common.ingredient.LittleIngredients;
import team.creative.littletiles.common.ingredient.LittleInventory;

public class ItemColorIngredient
extends Item
implements ILittleIngredientInventory {
    public ColorIngredientType type;

    public ItemColorIngredient(ColorIngredientType type) {
        super(new Item.Properties().m_41487_(1));
        this.type = type;
    }

    public static ItemStack generateItemStack(ColorIngredientType type, int value) {
        ItemStack stack = switch (type) {
            case ColorIngredientType.black -> new ItemStack((ItemLike)LittleTilesRegistry.BLACK_COLOR.get());
            case ColorIngredientType.cyan -> new ItemStack((ItemLike)LittleTilesRegistry.CYAN_COLOR.get());
            case ColorIngredientType.magenta -> new ItemStack((ItemLike)LittleTilesRegistry.MAGENTA_COLOR.get());
            case ColorIngredientType.yellow -> new ItemStack((ItemLike)LittleTilesRegistry.YELLOW_COLOR.get());
            default -> ItemStack.f_41583_;
        };
        if (!stack.m_41619_()) {
            ColorIngredient color = new ColorIngredient();
            type.setIngredient(color, value);
            ((ItemColorIngredient)stack.m_41720_()).setInventory(stack, new LittleIngredients(color), null);
        }
        return stack;
    }

    public boolean m_142207_(ItemStack stack, Slot slot, ClickAction action, Player player) {
        return false;
    }

    public boolean m_142305_(ItemStack me, ItemStack other, Slot p_150894_, ClickAction action, Player player, SlotAccess slot) {
        return false;
    }

    public ColorIngredient loadIngredient(ItemStack stack) {
        if (stack.m_41782_()) {
            ColorIngredient ingredient = new ColorIngredient();
            this.type.setIngredient(ingredient, stack.m_41783_().m_128451_("value"));
            switch (this.type) {
                case black: {
                    ingredient.setLimit(ColorIngredient.BOTTLE_SIZE, 0, 0, 0);
                    break;
                }
                case cyan: {
                    ingredient.setLimit(0, ColorIngredient.BOTTLE_SIZE, 0, 0);
                    break;
                }
                case magenta: {
                    ingredient.setLimit(0, 0, ColorIngredient.BOTTLE_SIZE, 0);
                    break;
                }
                case yellow: {
                    ingredient.setLimit(0, 0, 0, ColorIngredient.BOTTLE_SIZE);
                    break;
                }
            }
            return ingredient;
        }
        return null;
    }

    public int getColor(ItemStack stack) {
        return stack.m_41784_().m_128451_("value");
    }

    public void saveIngredient(ItemStack stack, ColorIngredient color) {
        stack.m_41784_().m_128405_("value", this.type.getIngredient(color));
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flagIn) {
        ColorIngredient entry = this.loadIngredient(stack);
        if (entry != null) {
            tooltip.add(this.type.print(entry));
        }
    }

    @Override
    public LittleIngredients getInventory(ItemStack stack) {
        ColorIngredient color = this.loadIngredient(stack);
        if (color != null) {
            return new LittleIngredients(new LittleIngredient[]{color}){

                @Override
                protected boolean canAddNewIngredients() {
                    return false;
                }

                @Override
                protected boolean removeEmptyIngredients() {
                    return false;
                }
            };
        }
        return null;
    }

    @Override
    public void setInventory(ItemStack stack, LittleIngredients ingredients, LittleInventory inventory) {
        ColorIngredient color = ingredients.get(ColorIngredient.class);
        if (color != null && this.type.getIngredient(color) > 0) {
            this.saveIngredient(stack, color);
            return;
        }
        stack.m_41751_(null);
        stack.m_41764_(0);
    }

    @Override
    public boolean shouldBeMerged() {
        return true;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ColorIngredientType {
        black{

            @Override
            public int getIngredient(ColorIngredient ingredient) {
                return ingredient.black;
            }

            @Override
            public void setIngredient(ColorIngredient ingredient, int value) {
                ingredient.black = value;
            }

            @Override
            public Component print(ColorIngredient ingredient) {
                return Component.m_237113_((String)ingredient.getBlackDescription());
            }
        }
        ,
        cyan{

            @Override
            public int getIngredient(ColorIngredient ingredient) {
                return ingredient.cyan;
            }

            @Override
            public void setIngredient(ColorIngredient ingredient, int value) {
                ingredient.cyan = value;
            }

            @Override
            public Component print(ColorIngredient ingredient) {
                return Component.m_237113_((String)ingredient.getCyanDescription());
            }
        }
        ,
        magenta{

            @Override
            public int getIngredient(ColorIngredient ingredient) {
                return ingredient.magenta;
            }

            @Override
            public void setIngredient(ColorIngredient ingredient, int value) {
                ingredient.magenta = value;
            }

            @Override
            public Component print(ColorIngredient ingredient) {
                return Component.m_237113_((String)ingredient.getMagentaDescription());
            }
        }
        ,
        yellow{

            @Override
            public int getIngredient(ColorIngredient ingredient) {
                return ingredient.yellow;
            }

            @Override
            public void setIngredient(ColorIngredient ingredient, int value) {
                ingredient.yellow = value;
            }

            @Override
            public Component print(ColorIngredient ingredient) {
                return Component.m_237113_((String)ingredient.getYellowDescription());
            }
        };


        public abstract int getIngredient(ColorIngredient var1);

        public abstract void setIngredient(ColorIngredient var1, int var2);

        public abstract Component print(ColorIngredient var1);

        public static ColorIngredientType getType(String type) {
            switch (type.toLowerCase()) {
                case "black": {
                    return black;
                }
                case "cyan": {
                    return cyan;
                }
                case "magenta": {
                    return magenta;
                }
                case "yellow": {
                    return yellow;
                }
            }
            return null;
        }
    }
}

