/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.item;

import com.google.common.base.Charsets;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.commons.io.IOUtils;
import team.creative.creativecore.common.util.inventory.ContainerSlotView;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.api.common.tool.ILittlePlacer;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.convertion.OldLittleTilesDataParser;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.gui.tool.GuiConfigure;
import team.creative.littletiles.common.gui.tool.GuiModeSelector;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.placement.PlacementPosition;
import team.creative.littletiles.common.placement.PlacementPreview;
import team.creative.littletiles.common.placement.mode.PlacementMode;
import team.creative.littletiles.common.structure.type.premade.LittleStructurePremade;

public class ItemMultiTiles
extends Item
implements ILittlePlacer {
    public static PlacementMode currentMode = PlacementMode.getDefault();
    public static LittleGrid currentGrid;

    public static ItemStack of(LittleElement element) {
        return ItemMultiTiles.of(element, LittleGrid.min(), LittleGrid.min().box());
    }

    public static ItemStack of(LittleElement element, LittleGrid grid, LittleBox box) {
        ItemStack stack = new ItemStack((ItemLike)LittleTilesRegistry.ITEM_TILES.get());
        LittleGroup group = new LittleGroup();
        group.add(grid, element, box);
        stack.m_41751_(LittleGroup.save(group));
        return stack;
    }

    public ItemMultiTiles() {
        super(new Item.Properties());
    }

    public static String getStructure(ItemStack stack) {
        if (stack.m_41784_().m_128441_("s")) {
            return stack.m_41783_().m_128469_("s").m_128461_("id");
        }
        return "";
    }

    public Component m_7626_(ItemStack stack) {
        if (stack.m_41784_().m_128441_("s") && stack.m_41698_("s").m_128441_("name")) {
            return Component.m_237113_((String)stack.m_41698_("s").m_128461_("name"));
        }
        return super.m_7626_(stack);
    }

    @Override
    public boolean hasTiles(ItemStack stack) {
        return true;
    }

    @Override
    public LittleGroup getTiles(ItemStack stack) {
        return LittleGroup.load(stack.m_41784_());
    }

    @Override
    public LittleGroup getLow(ItemStack stack) {
        return LittleGroup.loadLow(stack.m_41784_());
    }

    @Override
    public PlacementPreview getPlacement(Level level, ItemStack stack, PlacementPosition position, boolean allowLowResolution) {
        return PlacementPreview.relative(level, stack, position, allowLowResolution);
    }

    @Override
    public void saveTiles(ItemStack stack, LittleGroup group) {
        stack.m_41751_(LittleGroup.save(group));
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        String id = "none";
        if (stack.m_41784_().m_128441_("s")) {
            id = stack.m_41698_("s").m_128461_("id");
        }
        tooltip.add((Component)Component.m_237115_((String)"gui.structure").m_130946_(": ").m_7220_((Component)Component.m_237115_((String)("structure." + id))));
        tooltip.add(LittleGroup.printTooltip(stack.m_41784_()));
    }

    @Override
    public PlacementMode getPlacementMode(ItemStack stack) {
        return currentMode;
    }

    @Override
    public GuiConfigure getConfigure(Player player, ContainerSlotView view) {
        return new GuiModeSelector(view, currentGrid, currentMode){

            @Override
            public CompoundTag saveConfiguration(CompoundTag nbt, LittleGrid grid, PlacementMode mode) {
                currentGrid = grid;
                currentMode = mode;
                return nbt;
            }
        };
    }

    @Override
    public boolean containsIngredients(ItemStack stack) {
        return true;
    }

    @Override
    public LittleGrid getPositionGrid(ItemStack stack) {
        return currentGrid;
    }

    @Override
    public LittleVec getCachedSize(ItemStack stack) {
        return LittleGroup.getSize(stack.m_41784_());
    }

    @Override
    public LittleVec getCachedMin(ItemStack stack) {
        return LittleGroup.getMin(stack.m_41784_());
    }

    public static void reloadExampleStructures() {
        for (ExampleStructures example : ExampleStructures.values()) {
            try {
                example.stack = new ItemStack((ItemLike)LittleTilesRegistry.ITEM_TILES.get());
                CompoundTag nbt = TagParser.m_129359_((String)IOUtils.toString((InputStream)LittleStructurePremade.class.getClassLoader().getResourceAsStream(example.getFileName()), (Charset)Charsets.UTF_8));
                if (OldLittleTilesDataParser.isOld(nbt)) {
                    nbt = OldLittleTilesDataParser.convert(nbt);
                }
                example.stack.m_41751_(nbt);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Could not load '" + example.name() + " example structure!");
            }
        }
    }

    public static enum ExampleStructures {
        BASIC_LEVER,
        DOUBLE_DOOR,
        LIGHT_SWITCH,
        SIMPLE_LIGHT,
        STONE_PLATE,
        WOODEN_PLATE;

        public ItemStack stack;

        public String getFileName() {
            return "data/littletiles/example/" + this.name().toLowerCase() + ".struct";
        }
    }
}

