/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.item;

import java.util.HashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.util.inventory.ContainerSlotView;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.transformation.Rotation;
import team.creative.creativecore.common.util.mc.NBTUtils;
import team.creative.littletiles.api.common.tool.ILittlePlacer;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.gui.tool.GuiConfigure;
import team.creative.littletiles.common.gui.tool.GuiModeSelector;
import team.creative.littletiles.common.item.ItemLittleChisel;
import team.creative.littletiles.common.item.ItemMultiTiles;
import team.creative.littletiles.common.placement.PlacementPosition;
import team.creative.littletiles.common.placement.PlacementPreview;
import team.creative.littletiles.common.placement.mode.PlacementMode;
import team.creative.littletiles.common.structure.registry.premade.LittlePremadePreview;
import team.creative.littletiles.common.structure.registry.premade.LittlePremadeRegistry;
import team.creative.littletiles.common.structure.type.premade.LittleStructurePremade;

public class ItemPremadeStructure
extends Item
implements ILittlePlacer {
    private static HashMap<String, LittleGroup> cachedPreviews = new HashMap();

    public ItemPremadeStructure() {
        super(new Item.Properties());
    }

    public String m_5671_(ItemStack stack) {
        return super.m_5671_(stack) + "." + ItemPremadeStructure.getPremadeId(stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public LittleGrid getPositionGrid(ItemStack stack) {
        return ItemMultiTiles.currentGrid;
    }

    @Override
    public GuiConfigure getConfigure(Player player, ContainerSlotView view) {
        return new GuiModeSelector(view, ItemMultiTiles.currentGrid, ItemLittleChisel.currentMode){

            @Override
            public CompoundTag saveConfiguration(CompoundTag nbt, LittleGrid grid, PlacementMode mode) {
                ItemLittleChisel.currentMode = mode;
                ItemMultiTiles.currentGrid = grid;
                return nbt;
            }
        };
    }

    @Override
    public boolean hasTiles(ItemStack stack) {
        return LittlePremadeRegistry.getPreview(ItemPremadeStructure.getPremadeId(stack)) != null;
    }

    public void removeUnnecessaryData(ItemStack stack) {
        if (stack.m_41782_()) {
            stack.m_41783_().m_128473_("tiles");
            stack.m_41783_().m_128473_("size");
            stack.m_41783_().m_128473_("min");
        }
    }

    public static void clearCache() {
        cachedPreviews.clear();
    }

    private LittleGroup getPreviews(String id) {
        if (cachedPreviews.containsKey(id)) {
            return cachedPreviews.get(id).copy();
        }
        LittleGroup previews = LittlePremadeRegistry.getLittleGroup(id);
        if (previews != null) {
            return previews.copy();
        }
        return null;
    }

    @Override
    public LittleGroup getTiles(ItemStack stack) {
        String id = ItemPremadeStructure.getPremadeId(stack);
        LittleGroup previews = this.getPreviews(id);
        if (previews != null && previews.getStructureTag() != null && stack.m_41784_().m_128441_("structure")) {
            NBTUtils.mergeNotOverwrite((CompoundTag)previews.getStructureTag(), (CompoundTag)stack.m_41783_().m_128469_("structure"));
        }
        return previews;
    }

    @Override
    public LittleGroup getLow(ItemStack stack) {
        return this.getTiles(stack);
    }

    @Override
    public void rotate(Player player, ItemStack stack, Rotation rotation, boolean client) {
        String id = ItemPremadeStructure.getPremadeId(stack);
        LittleGroup previews = this.getPreviews(id);
        if (previews.isEmpty()) {
            return;
        }
        previews.rotate(rotation, previews.getGrid().rotationCenter);
        this.saveTiles(stack, previews);
    }

    @Override
    public void mirror(Player player, ItemStack stack, Axis axis, boolean client) {
        String id = ItemPremadeStructure.getPremadeId(stack);
        LittleGroup previews = this.getPreviews(id);
        if (previews.isEmpty()) {
            return;
        }
        previews.mirror(axis, previews.getGrid().rotationCenter);
        this.saveTiles(stack, previews);
    }

    @Override
    public PlacementPreview getPlacement(Level level, ItemStack stack, PlacementPosition position, boolean allowLowResolution) {
        return PlacementPreview.relative(level, stack, position, allowLowResolution);
    }

    @Override
    public void saveTiles(ItemStack stack, LittleGroup group) {
        cachedPreviews.put(ItemPremadeStructure.getPremadeId(stack), group);
    }

    @Override
    public boolean sendTransformationUpdate() {
        return false;
    }

    @Override
    public boolean containsIngredients(ItemStack stack) {
        return true;
    }

    @Override
    public PlacementMode getPlacementMode(ItemStack stack) {
        if (!ItemMultiTiles.currentMode.canPlaceStructures()) {
            return PlacementMode.getStructureDefault();
        }
        return ItemMultiTiles.currentMode;
    }

    @Override
    public boolean shouldCache() {
        return false;
    }

    @Override
    public boolean canSnapToGrid(ItemStack stack) {
        LittleStructurePremade.LittlePremadeType type = LittlePremadeRegistry.get(ItemPremadeStructure.getPremadeId(stack));
        if (type instanceof LittleStructurePremade.LittlePremadeType) {
            LittleStructurePremade.LittlePremadeType premade = type;
            return premade.canSnapToGrid();
        }
        return false;
    }

    @Override
    public boolean snapToGridByDefault(ItemStack stack) {
        LittleStructurePremade.LittlePremadeType type = LittlePremadeRegistry.get(ItemPremadeStructure.getPremadeId(stack));
        if (type instanceof LittleStructurePremade.LittlePremadeType) {
            LittleStructurePremade.LittlePremadeType premade = type;
            return premade.snapToGrid;
        }
        return false;
    }

    public static String getPremadeId(ItemStack stack) {
        return stack.m_41698_("structure").m_128461_("id");
    }

    public static LittlePremadePreview getPremade(ItemStack stack) {
        return LittlePremadeRegistry.getPreview(stack.m_41698_("structure").m_128461_("id"));
    }
}

