/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.level.handler;

import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.client.level.LittleAnimationHandlerClient;
import team.creative.littletiles.common.entity.LittleEntity;
import team.creative.littletiles.common.level.handler.LevelHandlers;
import team.creative.littletiles.common.level.handler.LittleAnimationHandler;
import team.creative.littletiles.server.level.handler.LittleAnimationHandlerServer;

public class LittleAnimationHandlers
extends LevelHandlers<LittleAnimationHandler> {
    @OnlyIn(value=Dist.CLIENT)
    private static LittleAnimationHandler createClient(Level level) {
        LittleTilesClient.ANIMATION_HANDLER = new LittleAnimationHandlerClient(level);
        return LittleTilesClient.ANIMATION_HANDLER;
    }

    public static void setPushedByDoor(ServerPlayer entity) {
    }

    public LittleAnimationHandlers() {
        super(level -> {
            if (level.f_46443_) {
                return LittleAnimationHandlers.createClient(level);
            }
            return new LittleAnimationHandlerServer((Level)level);
        });
        MinecraftForge.EVENT_BUS.addListener(this::tick);
        MinecraftForge.EVENT_BUS.addListener(this::trackEntity);
        MinecraftForge.EVENT_BUS.addListener(this::stopTrackEntity);
    }

    public LittleEntity find(boolean client, UUID uuid) {
        if (uuid == null) {
            return null;
        }
        for (LittleAnimationHandler handler : this.handlers(client)) {
            LittleEntity entity = handler.find(uuid);
            if (entity == null) continue;
            return entity;
        }
        return null;
    }

    public void tick(TickEvent.LevelTickEvent event) {
        ((LittleAnimationHandler)this.get(event.level)).tick(event);
    }

    public void trackEntity(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (entity instanceof LittleEntity) {
            LittleEntity levelEntity = (LittleEntity)entity;
            LittleTiles.NETWORK.sendToClient(levelEntity.initClientPacket(), (ServerPlayer)event.getEntity());
            levelEntity.startTracking((ServerPlayer)event.getEntity());
        }
    }

    public void stopTrackEntity(PlayerEvent.StopTracking event) {
        Entity entity = event.getTarget();
        if (entity instanceof LittleEntity) {
            LittleEntity levelEntity = (LittleEntity)entity;
            levelEntity.stopTracking((ServerPlayer)event.getEntity());
        }
    }
}

