/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.math.box;

import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.parent.IStructureParentCollection;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.box.LittleBoxAbsolute;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.math.vec.LittleVecAbsolute;

public class SurroundingBox {
    protected Level level;
    protected int count = 0;
    protected LittleGrid grid = LittleGrid.min();
    protected long minX = Long.MAX_VALUE;
    protected long minY = Long.MAX_VALUE;
    protected long minZ = Long.MAX_VALUE;
    protected long maxX = Long.MIN_VALUE;
    protected long maxY = Long.MIN_VALUE;
    protected long maxZ = Long.MIN_VALUE;
    protected int minYPos = Integer.MAX_VALUE;
    protected int maxYPos = Integer.MIN_VALUE;
    protected boolean mapScannedLists = false;
    protected HashMap<BlockPos, Iterable<LittleTile>> map = new HashMap();

    public SurroundingBox(boolean mapScannedLists, Level level) {
        this.mapScannedLists = mapScannedLists;
        this.level = level;
    }

    public void clear() {
        this.count = 0;
        this.grid = LittleGrid.min();
        this.minX = Long.MAX_VALUE;
        this.minY = Long.MAX_VALUE;
        this.minZ = Long.MAX_VALUE;
        this.maxX = Long.MIN_VALUE;
        this.maxY = Long.MIN_VALUE;
        this.maxZ = Long.MIN_VALUE;
        this.minYPos = Integer.MAX_VALUE;
        this.maxYPos = Integer.MIN_VALUE;
        this.map.clear();
    }

    public void convertTo(LittleGrid to) {
        if (this.count == 0) {
            this.grid = to;
            return;
        }
        if (this.grid.count > to.count) {
            int modifier = this.grid.count / to.count;
            this.minX /= (long)modifier;
            this.minY /= (long)modifier;
            this.minZ /= (long)modifier;
            this.maxX /= (long)modifier;
            this.maxY /= (long)modifier;
            this.maxZ /= (long)modifier;
        } else {
            int modifier = to.count / this.grid.count;
            this.minX *= (long)modifier;
            this.minY *= (long)modifier;
            this.minZ *= (long)modifier;
            this.maxX *= (long)modifier;
            this.maxY *= (long)modifier;
            this.maxZ *= (long)modifier;
        }
        this.grid = to;
    }

    protected boolean insertContext(LittleGrid to) {
        if (this.grid.count > to.count) {
            return false;
        }
        if (this.grid.count < to.count) {
            this.convertTo(to);
        }
        return true;
    }

    public SurroundingBox add(IStructureParentCollection list) {
        this.add(list.getGrid(), list.getPos(), list);
        return this;
    }

    public SurroundingBox add(LittleGrid context, BlockPos pos, Iterable<LittleTile> tiles) {
        int modifier = 1;
        if (!this.insertContext(context)) {
            modifier = this.grid.count / context.count;
        }
        for (LittleTile tile : tiles) {
            for (LittleBox box : tile) {
                this.add(box, modifier, pos);
            }
        }
        if (this.mapScannedLists) {
            this.map.put(pos, tiles);
        }
        return this;
    }

    protected void add(LittleBox box, int modifier, BlockPos pos) {
        this.minX = Math.min(this.minX, (long)(pos.m_123341_() * this.grid.count + box.minX * modifier));
        this.minY = Math.min(this.minY, (long)(pos.m_123342_() * this.grid.count + box.minY * modifier));
        this.minZ = Math.min(this.minZ, (long)(pos.m_123343_() * this.grid.count + box.minZ * modifier));
        this.maxX = Math.max(this.maxX, (long)(pos.m_123341_() * this.grid.count + box.maxX * modifier));
        this.maxY = Math.max(this.maxY, (long)(pos.m_123342_() * this.grid.count + box.maxY * modifier));
        this.maxZ = Math.max(this.maxZ, (long)(pos.m_123343_() * this.grid.count + box.maxZ * modifier));
        this.minYPos = Math.min(this.minYPos, pos.m_123342_());
        this.maxYPos = Math.max(this.maxYPos, pos.m_123342_());
        ++this.count;
    }

    public LittleBoxAbsolute getAbsoluteBox() {
        BlockPos pos = this.getMinPos();
        return new LittleBoxAbsolute(pos, new LittleBox((int)(this.minX - (long)this.grid.toGrid(pos.m_123341_())), (int)(this.minY - (long)this.grid.toGrid(pos.m_123342_())), (int)(this.minZ - (long)this.grid.toGrid(pos.m_123343_())), (int)(this.maxX - (long)this.grid.toGrid(pos.m_123341_())), (int)(this.maxY - (long)this.grid.toGrid(pos.m_123342_())), (int)(this.maxZ - (long)this.grid.toGrid(pos.m_123343_()))), this.grid);
    }

    public AABB getAABB() {
        return new AABB(this.grid.toVanillaGrid(this.minX), this.grid.toVanillaGrid(this.minY), this.grid.toVanillaGrid(this.minZ), this.grid.toVanillaGrid(this.maxX), this.grid.toVanillaGrid(this.maxY), this.grid.toVanillaGrid(this.maxZ));
    }

    public VoxelShape getShape(BlockPos pos) {
        return Shapes.m_83048_((double)(this.grid.toVanillaGrid(this.minX) - (double)pos.m_123341_()), (double)(this.grid.toVanillaGrid(this.minY) - (double)pos.m_123342_()), (double)(this.grid.toVanillaGrid(this.minZ) - (double)pos.m_123343_()), (double)(this.grid.toVanillaGrid(this.maxX) - (double)pos.m_123341_()), (double)(this.grid.toVanillaGrid(this.maxY) - (double)pos.m_123342_()), (double)(this.grid.toVanillaGrid(this.maxZ) - (double)pos.m_123343_()));
    }

    public double getPercentVolume() {
        return 0.125 * this.grid.toVanillaGrid(this.minX + this.maxX) * this.grid.toVanillaGrid(this.minY + this.maxY) * this.grid.toVanillaGrid(this.minZ + this.maxZ);
    }

    public LittleVecAbsolute getHighestCenterPoint() {
        int centerX = (int)Math.floor((double)(this.minX + this.maxX) / (double)this.grid.count / 2.0);
        int centerZ = (int)Math.floor((double)(this.minZ + this.maxZ) / (double)this.grid.count / 2.0);
        int centerTileX = (int)(Math.floor(this.minX + this.maxX) / 2.0) - centerX * this.grid.count;
        int centerTileZ = (int)(Math.floor(this.minZ + this.maxZ) / 2.0) - centerZ * this.grid.count;
        LittleVecAbsolute pos = new LittleVecAbsolute(new BlockPos(centerX, this.minYPos, centerZ), this.grid, new LittleVec(centerTileX, 0, centerTileZ));
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        for (int y = this.minYPos; y <= this.maxYPos; ++y) {
            Iterable<LittleTile> tilesInCenter = this.map.get(blockPos.m_122178_(centerX, y, centerZ));
            if (tilesInCenter == null) continue;
            BETiles be = this.getBE((BlockPos)blockPos);
            be.convertTo(this.grid);
            LittleBox box = new LittleBox(centerTileX, 0, centerTileZ, centerTileX + 1, this.grid.count, centerTileZ + 1);
            if (this.grid.count <= centerTileX) {
                box.minX = this.grid.count - 1;
                box.maxX = this.grid.count;
            }
            if (this.grid.count <= centerTileZ) {
                box.minZ = this.grid.count - 1;
                box.maxZ = this.grid.count;
            }
            for (LittleTile tile : tilesInCenter) {
                for (LittleBox littleBox : tile) {
                    if (!LittleBox.intersectsWith(box, littleBox)) continue;
                    pos.overwriteGrid(be.getGrid());
                    pos.getVec().y = Math.max((y - this.minYPos) * this.grid.count + littleBox.maxY, pos.getVec().y);
                }
            }
            be.convertToSmallest();
        }
        pos.removeInternalBlockOffset();
        pos.convertToSmallest();
        return pos;
    }

    public Vec3d getHighestCenterVec() {
        int centerX = (int)Math.floor((double)(this.minX + this.maxX) / (double)this.grid.count / 2.0);
        int centerZ = (int)Math.floor((double)(this.minZ + this.maxZ) / (double)this.grid.count / 2.0);
        int centerTileX = (int)(Math.floor(this.minX + this.maxX) / 2.0) - centerX * this.grid.count;
        int centerTileZ = (int)(Math.floor(this.minZ + this.maxZ) / 2.0) - centerZ * this.grid.count;
        LittleVecAbsolute pos = new LittleVecAbsolute(new BlockPos(centerX, this.minYPos, centerZ), this.grid, new LittleVec(centerTileX, 0, centerTileZ));
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        for (int y = this.minYPos; y <= this.maxYPos; ++y) {
            Iterable<LittleTile> tilesInCenter = this.map.get(blockPos.m_122178_(centerX, y, centerZ));
            if (tilesInCenter == null) continue;
            BETiles be = this.getBE((BlockPos)blockPos);
            be.convertTo(this.grid);
            LittleBox box = new LittleBox(centerTileX, 0, centerTileZ, centerTileX + 1, this.grid.count, centerTileZ + 1);
            if (this.grid.count >= centerTileX) {
                box.minX = this.grid.count - 1;
                box.maxX = this.grid.count;
            }
            if (this.grid.count >= centerTileZ) {
                box.minZ = this.grid.count - 1;
                box.maxZ = this.grid.count;
            }
            for (LittleTile tile : tilesInCenter) {
                for (LittleBox littleBox : tile) {
                    if (!LittleBox.intersectsWith(box, littleBox)) continue;
                    pos.overwriteGrid(be.getGrid());
                    pos.getVec().y = Math.max((y - this.minYPos) * this.grid.count + littleBox.maxY, pos.getVec().y);
                }
            }
            be.convertToSmallest();
        }
        return new Vec3d(this.grid.toVanillaGrid((double)(this.minX + this.maxX) / 2.0), pos.getPosY(), this.grid.toVanillaGrid((double)(this.minZ + this.maxZ) / 2.0));
    }

    private BETiles getBE(BlockPos pos) {
        BlockEntity be = this.level.m_7702_(pos);
        if (be instanceof BETiles) {
            return (BETiles)be;
        }
        throw new RuntimeException("TileEntity does not exist anymore");
    }

    public long getMinX() {
        return this.minX;
    }

    public long getMinY() {
        return this.minY;
    }

    public long getMinZ() {
        return this.minZ;
    }

    public long getMaxX() {
        return this.maxX;
    }

    public long getMaxY() {
        return this.maxY;
    }

    public long getMaxZ() {
        return this.maxZ;
    }

    public long getMin(Axis axis) {
        switch (axis) {
            case X: {
                return this.minX;
            }
            case Y: {
                return this.minY;
            }
            case Z: {
                return this.minZ;
            }
        }
        return 0L;
    }

    public long getMax(Axis axis) {
        switch (axis) {
            case X: {
                return this.maxX;
            }
            case Y: {
                return this.maxY;
            }
            case Z: {
                return this.maxZ;
            }
        }
        return 0L;
    }

    public LittleVec getMinPosOffset() {
        return new LittleVec((int)(this.minX - (long)(this.grid.toBlockOffset(this.minX) * this.grid.count)), (int)(this.minY - (long)(this.grid.toBlockOffset(this.minY) * this.grid.count)), (int)(this.minZ - (long)(this.grid.toBlockOffset(this.minZ) * this.grid.count)));
    }

    public LittleVec getMaxPosOffset() {
        return new LittleVec((int)(this.maxX - (long)(this.grid.toBlockOffset(this.maxX) * this.grid.count)), (int)(this.maxY - (long)(this.grid.toBlockOffset(this.maxY) * this.grid.count)), (int)(this.maxZ - (long)(this.grid.toBlockOffset(this.maxZ) * this.grid.count)));
    }

    public LittleVec getSize() {
        return new LittleVec((int)(this.maxX - this.minX), (int)(this.maxY - this.minY), (int)(this.maxZ - this.minZ));
    }

    public BlockPos getMinPos() {
        return new BlockPos(this.grid.toBlockOffset(this.minX), this.grid.toBlockOffset(this.minY), this.grid.toBlockOffset(this.minZ));
    }

    public BlockPos getMaxPos() {
        return new BlockPos(this.grid.toBlockOffset(this.maxX), this.grid.toBlockOffset(this.maxY), this.grid.toBlockOffset(this.maxZ));
    }

    public LittleGrid getGrid() {
        return this.grid;
    }

    public int count() {
        return this.count;
    }
}

