/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.math.box;

import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import team.creative.creativecore.common.util.math.Maths;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.AABBVoxelShape;
import team.creative.creativecore.common.util.math.geo.NormalPlane;
import team.creative.creativecore.common.util.math.geo.Ray3f;
import team.creative.creativecore.common.util.math.geo.VectorFan;
import team.creative.creativecore.common.util.math.vec.Vec3f;
import team.creative.creativecore.common.util.unsafe.CreativeHackery;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.box.LittleTransformableBox;

public class TransformableVoxelShape
extends AABBVoxelShape {
    private LittleGrid grid;
    private LittleBox box;

    public static TransformableVoxelShape create(LittleBox box, LittleGrid grid, AABB bb) {
        TransformableVoxelShape shape = (TransformableVoxelShape)((Object)CreativeHackery.allocateInstance(TransformableVoxelShape.class));
        shape.bb = bb;
        shape.box = box;
        shape.grid = grid;
        return shape;
    }

    public LittleTransformableBox.VectorFanFaceCache getFaceCache(Facing facing) {
        LittleTransformableBox.VectorFanCache cache = ((LittleTransformableBox)this.box).requestCache();
        if (cache != null) {
            return cache.get(facing);
        }
        return null;
    }

    public double m_83259_(Direction.Axis axis, AABB bb, double value) {
        return this.calculateOffset(bb, Axis.get((Direction.Axis)axis), value);
    }

    public double calculateOffset(AABB other, Axis axis, double offset) {
        if (offset == 0.0) {
            return offset;
        }
        boolean positive = offset > 0.0;
        Facing direction = Facing.get((Axis)axis, (boolean)positive);
        Axis one = axis.one();
        Axis two = axis.two();
        float minOne = (float)TransformableVoxelShape.getMin((AABB)other, (Axis)one);
        minOne = (float)((double)minOne - Math.floor(this.getMin(one)));
        minOne *= (float)this.grid.count;
        float minTwo = (float)TransformableVoxelShape.getMin((AABB)other, (Axis)two);
        minTwo = (float)((double)minTwo - Math.floor(this.getMin(two)));
        minTwo *= (float)this.grid.count;
        float maxOne = (float)TransformableVoxelShape.getMax((AABB)other, (Axis)one);
        maxOne = (float)((double)maxOne - Math.floor(this.getMin(one)));
        maxOne *= (float)this.grid.count;
        float maxTwo = (float)TransformableVoxelShape.getMax((AABB)other, (Axis)two);
        maxTwo = (float)((double)maxTwo - Math.floor(this.getMin(two)));
        float otherAxis = (float)(offset > 0.0 ? TransformableVoxelShape.getMax((AABB)other, (Axis)axis) : TransformableVoxelShape.getMin((AABB)other, (Axis)axis));
        otherAxis = (float)((double)otherAxis - Math.floor(this.getMin(axis)));
        otherAxis *= (float)this.grid.count;
        NormalPlane[] cuttingPlanes = new NormalPlane[]{new NormalPlane(one, minOne, Facing.get((Axis)one, (boolean)false)), new NormalPlane(two, minTwo, Facing.get((Axis)two, (boolean)false)), new NormalPlane(one, maxOne, Facing.get((Axis)one, (boolean)true)), new NormalPlane(two, maxTwo *= (float)this.grid.count, Facing.get((Axis)two, (boolean)true))};
        VectorFan tempFan = new VectorFan(null);
        LittleTransformableBox.VectorFanFaceCache front = this.getFaceCache(direction.opposite());
        if (front.hasAxisStrip()) {
            for (VectorFan vectorFan : front.axisStrips) {
                double d0;
                tempFan.set(vectorFan);
                if (!tempFan.cutWithoutCopy(cuttingPlanes)) continue;
                if (offset > 0.0 && TransformableVoxelShape.getMax((AABB)other, (Axis)axis) <= this.getMin(axis)) {
                    double d1 = this.getMin(axis) - TransformableVoxelShape.getMax((AABB)other, (Axis)axis);
                    if (d1 < offset) {
                        return d1;
                    }
                } else if (offset < 0.0 && TransformableVoxelShape.getMin((AABB)other, (Axis)axis) >= this.getMax(axis) && (d0 = this.getMax(axis) - TransformableVoxelShape.getMin((AABB)other, (Axis)axis)) > offset) {
                    return d0;
                }
                return offset;
            }
        }
        Ray3f ray = new Ray3f(new Vec3f(), direction);
        ray.origin.set(axis, otherAxis);
        float distance = Float.POSITIVE_INFINITY;
        for (int i = 0; i < Facing.values().length; ++i) {
            LittleTransformableBox.VectorFanFaceCache face;
            Facing facing = Facing.values()[i];
            if (facing == direction || !(face = this.getFaceCache(facing)).hasTiltedStrip()) continue;
            for (VectorFan vectorFan : face.tilted()) {
                tempFan.set(vectorFan);
                tempFan.cutWithoutCopy(cuttingPlanes);
                if (tempFan.isEmpty()) continue;
                for (int j = 0; j < tempFan.count(); ++j) {
                    float tempDistance;
                    Vec3f vec = tempFan.get(j);
                    float f = tempDistance = positive ? vec.get(axis) - otherAxis : otherAxis - vec.get(axis);
                    if (tempDistance < 0.0f && !Maths.equals((double)tempDistance, (double)0.0)) {
                        return offset;
                    }
                    if (!(tempDistance < distance)) continue;
                    distance = tempDistance;
                }
            }
        }
        if (Double.isInfinite(distance)) {
            return offset;
        }
        distance = (float)((double)distance * this.grid.pixelLength);
        if (offset > 0.0) {
            if ((double)distance < offset) {
                return distance;
            }
            return offset;
        }
        if (offset < 0.0) {
            if ((double)(-distance) > offset) {
                return -distance;
            }
            return offset;
        }
        return offset;
    }
}

