/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.math.box.volume;

import java.util.Map;
import java.util.Set;
import team.creative.creativecore.common.util.type.map.HashMapInteger;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.grid.IGridBased;
import team.creative.littletiles.common.grid.LittleGrid;

public class LittleVolumes
implements IGridBased {
    public LittleGrid grid;
    private HashMapInteger<LittleElement> volumes = new HashMapInteger();

    public LittleVolumes(LittleGrid grid) {
        this.grid = grid;
    }

    public LittleVolumes() {
        this.grid = LittleGrid.min();
    }

    @Override
    public LittleGrid getGrid() {
        return this.grid;
    }

    @Override
    public void convertTo(LittleGrid grid) {
        int ratio = grid.count / this.grid.count;
        this.volumes.scale(ratio);
    }

    public void clear() {
        this.grid = LittleGrid.min();
        this.volumes.clear();
    }

    public Set<Map.Entry<LittleElement, Integer>> entrySet() {
        return this.volumes.entrySet();
    }

    public void add(LittleVolumes volumes) {
        this.volumes.putAll(volumes.volumes);
    }

    public void add(LittleGroup group) {
        this.minGrid(group);
        for (LittleTile tile : group.allTiles()) {
            this.addDirectly(group.getGrid(), tile);
        }
    }

    public void add(LittleGrid grid, LittleElement element, int volume) {
        this.minGrid(grid);
        this.addDirectly(grid, element, volume);
    }

    public void add(LittleGrid grid, LittleTile tile) {
        this.minGrid(grid);
        this.addDirectly(grid, tile);
    }

    private void addDirectly(LittleGrid grid, LittleTile tile) {
        this.add(grid, tile, tile.getVolume());
    }

    private void addDirectly(LittleGrid grid, LittleElement tile, int volume) {
        Integer exist;
        if (grid.count < this.grid.count) {
            volume *= this.grid.count / grid.count;
        }
        if ((exist = (Integer)this.volumes.get((Object)tile)) == null) {
            exist = volume;
            tile = new LittleElement(tile);
        } else {
            exist = exist + volume;
        }
        this.volumes.put((Object)tile, exist);
    }

    @Override
    public int getSmallest() {
        int smallest = LittleGrid.min().count;
        for (Integer value : this.volumes.values()) {
            double root = Math.cbrt(value.intValue());
            if (root == Math.floor(root)) {
                smallest = Math.max(smallest, this.grid.getMinGrid((int)root));
                continue;
            }
            smallest = this.grid.count;
        }
        return smallest;
    }

    public int hashCode() {
        return this.volumes.size();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LittleVolumes) {
            LittleGrid beforeThis = this.grid;
            this.minGrid((IGridBased)obj);
            LittleGrid beforeTheirs = ((LittleVolumes)obj).grid;
            ((LittleVolumes)obj).minGrid(this);
            boolean result = ((LittleVolumes)obj).volumes.equals(this.volumes);
            if (beforeThis != this.grid) {
                this.convertTo(beforeThis);
            }
            if (beforeTheirs != ((LittleVolumes)obj).grid) {
                ((LittleVolumes)obj).convertTo(beforeTheirs);
            }
            return result;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.volumes.isEmpty();
    }
}

