/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.packet;

import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.network.type.NetworkFieldTypeClass;
import team.creative.creativecore.common.network.type.NetworkFieldTypes;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.type.Bunch;
import team.creative.creativecore.common.util.type.map.HashMapList;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.action.LittleAction;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.collection.LittleCollection;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.block.little.tile.group.LittleGroupAbsolute;
import team.creative.littletiles.common.block.little.tile.group.LittleGroupHolder;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.box.LittleBoxAbsolute;
import team.creative.littletiles.common.math.box.collection.LittleBoxes;
import team.creative.littletiles.common.math.box.collection.LittleBoxesNoOverlap;
import team.creative.littletiles.common.math.box.collection.LittleBoxesSimple;
import team.creative.littletiles.common.math.location.StructureLocation;
import team.creative.littletiles.common.math.location.TileLocation;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.math.vec.LittleVecAbsolute;
import team.creative.littletiles.common.math.vec.LittleVecGrid;
import team.creative.littletiles.common.packet.entity.animation.LittleBlockChange;
import team.creative.littletiles.common.placement.PlacementPosition;
import team.creative.littletiles.common.placement.PlacementPreview;
import team.creative.littletiles.common.placement.mode.PlacementMode;
import team.creative.littletiles.common.structure.animation.AnimationTimeline;
import team.creative.littletiles.common.structure.relative.StructureAbsolute;
import team.creative.littletiles.common.structure.relative.StructureRelative;
import team.creative.littletiles.common.structure.signal.SignalState;

public class LittlePacketTypes {
    public static void init() {
        NetworkFieldTypes.register((NetworkFieldTypeClass)new NetworkFieldTypeClass<TileLocation>(){

            protected void writeContent(TileLocation content, FriendlyByteBuf buffer) {
                buffer.m_130064_(content.pos);
                buffer.writeBoolean(content.isStructure);
                buffer.writeInt(content.index);
                buffer.m_130089_(content.box.getArray());
                if (content.levelUUID != null) {
                    buffer.writeBoolean(true);
                    buffer.m_130077_(content.levelUUID);
                } else {
                    buffer.writeBoolean(false);
                }
            }

            protected TileLocation readContent(FriendlyByteBuf buffer) {
                BlockPos pos = buffer.m_130135_();
                boolean isStructure = buffer.readBoolean();
                int index = buffer.readInt();
                int[] boxArray = buffer.m_130100_();
                UUID level = null;
                if (buffer.readBoolean()) {
                    level = buffer.m_130259_();
                }
                return new TileLocation(pos, isStructure, index, LittleBox.create(boxArray), level);
            }
        }, TileLocation.class);
        NetworkFieldTypes.register((NetworkFieldTypeClass)new NetworkFieldTypeClass<StructureLocation>(){

            protected void writeContent(StructureLocation content, FriendlyByteBuf buffer) {
                buffer.m_130064_(content.pos);
                buffer.writeInt(content.index);
                if (content.levelUUID != null) {
                    buffer.writeBoolean(true);
                    buffer.m_130077_(content.levelUUID);
                } else {
                    buffer.writeBoolean(false);
                }
            }

            protected StructureLocation readContent(FriendlyByteBuf buffer) {
                BlockPos pos = buffer.m_130135_();
                int index = buffer.readInt();
                UUID level = null;
                if (buffer.readBoolean()) {
                    level = buffer.m_130259_();
                }
                return new StructureLocation(pos, index, level);
            }
        }, StructureLocation.class);
        NetworkFieldTypes.register((NetworkFieldTypeClass)new NetworkFieldTypeClass<LittleTile>(){

            protected void writeContent(LittleTile content, FriendlyByteBuf buffer) {
                buffer.writeInt(content.size());
                for (LittleBox box : content) {
                    buffer.m_130089_(box.getArray());
                }
                buffer.m_130070_(content.getBlockName());
                buffer.writeInt(content.color);
            }

            protected LittleTile readContent(FriendlyByteBuf buffer) {
                int size = buffer.readInt();
                ArrayList<LittleBox> boxes = new ArrayList<LittleBox>(size);
                for (int i = 0; i < size; ++i) {
                    boxes.add(LittleBox.create(buffer.m_130100_()));
                }
                return new LittleTile(buffer.m_130277_(), buffer.readInt(), boxes);
            }
        }, LittleTile.class);
        NetworkFieldTypes.register((NetworkFieldTypeClass)new NetworkFieldTypeClass<LittleCollection>(){

            protected void writeContent(LittleCollection content, FriendlyByteBuf buffer) {
                buffer.writeInt(content.size());
                for (LittleTile tile : content) {
                    NetworkFieldTypes.write(LittleTile.class, (Object)tile, (FriendlyByteBuf)buffer);
                }
            }

            protected LittleCollection readContent(FriendlyByteBuf buffer) {
                int size = buffer.readInt();
                LittleCollection collection = new LittleCollection();
                for (int i = 0; i < size; ++i) {
                    collection.add((LittleTile)NetworkFieldTypes.read(LittleTile.class, (FriendlyByteBuf)buffer));
                }
                return collection;
            }
        }, LittleCollection.class);
        NetworkFieldTypes.register((NetworkFieldTypeClass)new NetworkFieldTypeClass<LittleGroup>(){

            protected void writeContent(LittleGroup content, FriendlyByteBuf buffer) {
                if (content instanceof LittleGroupHolder) {
                    throw new RuntimeException("LittleGroupHolder cannot be send across the network");
                }
                buffer.writeInt(content.children.sizeChildren());
                for (LittleGroup littleGroup : content.children.children()) {
                    NetworkFieldTypes.write(LittleGroup.class, (Object)littleGroup, (FriendlyByteBuf)buffer);
                }
                buffer.writeInt(content.getGrid().count);
                if (content.hasStructure()) {
                    buffer.writeBoolean(true);
                    buffer.m_130079_(content.getStructureTag());
                } else {
                    buffer.writeBoolean(false);
                }
                NetworkFieldTypes.writeMany(LittleTile.class, (Bunch)content, (FriendlyByteBuf)buffer);
                buffer.writeInt(content.children.sizeExtensions());
                for (Map.Entry entry : content.children.extensionEntries()) {
                    buffer.m_130070_((String)entry.getKey());
                    NetworkFieldTypes.write(LittleGroup.class, (Object)((LittleGroup)entry.getValue()), (FriendlyByteBuf)buffer);
                }
            }

            protected LittleGroup readContent(FriendlyByteBuf buffer) {
                int size = buffer.readInt();
                ArrayList<LittleGroup> children = new ArrayList<LittleGroup>(size);
                for (int i = 0; i < size; ++i) {
                    children.add((LittleGroup)NetworkFieldTypes.read(LittleGroup.class, (FriendlyByteBuf)buffer));
                }
                LittleGrid grid = LittleGrid.get(buffer.readInt());
                LittleGroup group = new LittleGroup(buffer.readBoolean() ? buffer.m_130261_() : null, children);
                group.addAll(grid, NetworkFieldTypes.readMany(LittleTile.class, (FriendlyByteBuf)buffer));
                int extensionCount = buffer.readInt();
                for (int i = 0; i < extensionCount; ++i) {
                    group.children.addExtension(buffer.m_130277_(), (LittleGroup)NetworkFieldTypes.read(LittleGroup.class, (FriendlyByteBuf)buffer));
                }
                return group;
            }
        }, LittleGroup.class);
        NetworkFieldTypes.register((NetworkFieldTypeClass)new NetworkFieldTypeClass<LittleGroupAbsolute>(){

            protected void writeContent(LittleGroupAbsolute content, FriendlyByteBuf buffer) {
                buffer.m_130064_(content.pos);
                NetworkFieldTypes.write(LittleGroup.class, (Object)content.group, (FriendlyByteBuf)buffer);
            }

            protected LittleGroupAbsolute readContent(FriendlyByteBuf buffer) {
                return new LittleGroupAbsolute(buffer.m_130135_(), (LittleGroup)NetworkFieldTypes.read(LittleGroup.class, (FriendlyByteBuf)buffer));
            }
        }, LittleGroupAbsolute.class);
        NetworkFieldTypes.register((NetworkFieldTypeClass)new NetworkFieldTypeClass<PlacementMode>(){

            protected void writeContent(PlacementMode content, FriendlyByteBuf buffer) {
                buffer.m_130070_(content.getId());
            }

            protected PlacementMode readContent(FriendlyByteBuf buffer) {
                return PlacementMode.getMode(buffer.m_130277_());
            }
        }, PlacementMode.class);
        NetworkFieldTypes.register((NetworkFieldTypeClass)new NetworkFieldTypeClass<LittleAction>(){

            protected void writeContent(LittleAction content, FriendlyByteBuf buffer) {
                buffer.m_130070_(((Object)((Object)content)).getClass().getName());
                LittleTiles.NETWORK.getPacketType(((Object)((Object)content)).getClass()).write((CreativePacket)content, buffer);
            }

            protected LittleAction readContent(FriendlyByteBuf buffer) {
                try {
                    Class<?> clazz = Class.forName(buffer.m_130277_());
                    return (LittleAction)LittleTiles.NETWORK.getPacketType(clazz).read(buffer);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }, LittleAction.class);
        NetworkFieldTypes.register((NetworkFieldTypeClass)new NetworkFieldTypeClass<LittleGrid>(){

            protected void writeContent(LittleGrid content, FriendlyByteBuf buffer) {
                buffer.writeInt(content.count);
            }

            protected LittleGrid readContent(FriendlyByteBuf buffer) {
                return LittleGrid.get(buffer.readInt());
            }
        }, LittleGrid.class);
        NetworkFieldTypes.register((NetworkFieldTypeClass)new NetworkFieldTypeClass<LittleVec>(){

            protected void writeContent(LittleVec vec, FriendlyByteBuf buffer) {
                buffer.writeInt(vec.x);
                buffer.writeInt(vec.y);
                buffer.writeInt(vec.z);
            }

            protected LittleVec readContent(FriendlyByteBuf buffer) {
                return new LittleVec(buffer.readInt(), buffer.readInt(), buffer.readInt());
            }
        }, LittleVec.class);
        NetworkFieldTypes.register((NetworkFieldTypeClass)new NetworkFieldTypeClass<LittleVecGrid>(){

            protected void writeContent(LittleVecGrid vec, FriendlyByteBuf buffer) {
                buffer.writeInt(vec.getVec().x);
                buffer.writeInt(vec.getVec().y);
                buffer.writeInt(vec.getVec().z);
                buffer.writeInt(vec.getGrid().count);
            }

            protected LittleVecGrid readContent(FriendlyByteBuf buffer) {
                return new LittleVecGrid(new LittleVec(buffer.readInt(), buffer.readInt(), buffer.readInt()), LittleGrid.get(buffer.readInt()));
            }
        }, LittleVecGrid.class);
        NetworkFieldTypes.register((NetworkFieldTypeClass)new NetworkFieldTypeClass<LittleVecAbsolute>(){

            protected void writeContent(LittleVecAbsolute content, FriendlyByteBuf buffer) {
                buffer.m_130064_(content.getPos());
                NetworkFieldTypes.write(LittleVecGrid.class, (Object)content.getVecGrid(), (FriendlyByteBuf)buffer);
            }

            protected LittleVecAbsolute readContent(FriendlyByteBuf buffer) {
                return new LittleVecAbsolute(buffer.m_130135_(), (LittleVecGrid)NetworkFieldTypes.read(LittleVecGrid.class, (FriendlyByteBuf)buffer));
            }
        }, LittleVecAbsolute.class);
        NetworkFieldTypes.register((NetworkFieldTypeClass)new NetworkFieldTypeClass<PlacementPosition>(){

            protected void writeContent(PlacementPosition content, FriendlyByteBuf buffer) {
                buffer.m_130064_(content.getPos());
                NetworkFieldTypes.write(LittleVecGrid.class, (Object)content.getVecGrid(), (FriendlyByteBuf)buffer);
                buffer.m_130068_((Enum)content.facing);
            }

            protected PlacementPosition readContent(FriendlyByteBuf buffer) {
                return new PlacementPosition(buffer.m_130135_(), (LittleVecGrid)NetworkFieldTypes.read(LittleVecGrid.class, (FriendlyByteBuf)buffer), (Facing)buffer.m_130066_(Facing.class));
            }
        }, PlacementPosition.class);
        NetworkFieldTypes.register((NetworkFieldTypeClass)new NetworkFieldTypeClass<LittleBox>(){

            protected void writeContent(LittleBox content, FriendlyByteBuf buffer) {
                buffer.m_130089_(content.getArray());
            }

            protected LittleBox readContent(FriendlyByteBuf buffer) {
                return LittleBox.create(buffer.m_130100_());
            }
        }, LittleBox.class);
        NetworkFieldTypes.register((NetworkFieldTypeClass)new NetworkFieldTypeClass<LittleBoxAbsolute>(){

            protected void writeContent(LittleBoxAbsolute content, FriendlyByteBuf buffer) {
                buffer.m_130064_(content.pos);
                buffer.m_130089_(content.box.getArray());
                buffer.writeInt(content.getGrid().count);
            }

            protected LittleBoxAbsolute readContent(FriendlyByteBuf buffer) {
                return new LittleBoxAbsolute(buffer.m_130135_(), LittleBox.create(buffer.m_130100_()), LittleGrid.get(buffer.readInt()));
            }
        }, LittleBoxAbsolute.class);
        NetworkFieldTypes.register((NetworkFieldTypeClass)new NetworkFieldTypeClass<StructureRelative>(){

            protected void writeContent(StructureRelative content, FriendlyByteBuf buffer) {
                buffer.m_130089_(content.getBox().getArray());
                buffer.writeInt(content.getGrid().count);
            }

            protected StructureRelative readContent(FriendlyByteBuf buffer) {
                return new StructureRelative(LittleBox.create(buffer.m_130100_()), LittleGrid.get(buffer.readInt()));
            }
        }, (Class[])new Class[]{StructureAbsolute.class});
        NetworkFieldTypes.register((NetworkFieldTypeClass)new NetworkFieldTypeClass<StructureAbsolute>(){

            protected void writeContent(StructureAbsolute content, FriendlyByteBuf buffer) {
                buffer.m_130064_(content.baseOffset);
                buffer.m_130089_(content.getBox().getArray());
                buffer.writeInt(content.getGrid().count);
            }

            protected StructureAbsolute readContent(FriendlyByteBuf buffer) {
                return new StructureAbsolute(buffer.m_130135_(), LittleBox.create(buffer.m_130100_()), LittleGrid.get(buffer.readInt()));
            }
        }, StructureAbsolute.class);
        NetworkFieldTypes.register((NetworkFieldTypeClass)new NetworkFieldTypeClass<LittleBoxes>(){

            protected void writeContent(LittleBoxes content, FriendlyByteBuf buffer) {
                buffer.m_130064_(content.pos);
                buffer.writeInt(content.grid.count);
                if (content instanceof LittleBoxesSimple) {
                    buffer.writeBoolean(true);
                    buffer.writeInt(content.size());
                    for (LittleBox box : content.all()) {
                        buffer.m_130089_(box.getArray());
                    }
                } else {
                    buffer.writeBoolean(false);
                    HashMapList<BlockPos, LittleBox> map = content.generateBlockWise();
                    buffer.writeInt(map.size());
                    for (Map.Entry entry : map.entrySet()) {
                        buffer.m_130064_((BlockPos)entry.getKey());
                        buffer.writeInt(((ArrayList)entry.getValue()).size());
                        for (LittleBox box : (ArrayList)entry.getValue()) {
                            buffer.m_130089_(box.getArray());
                        }
                    }
                }
            }

            protected LittleBoxes readContent(FriendlyByteBuf buffer) {
                BlockPos pos = buffer.m_130135_();
                LittleGrid grid = LittleGrid.get(buffer.readInt());
                if (buffer.readBoolean()) {
                    LittleBoxesSimple boxes = new LittleBoxesSimple(pos, grid);
                    int length = buffer.readInt();
                    for (int i = 0; i < length; ++i) {
                        ((LittleBoxes)boxes).add(LittleBox.create(buffer.m_130100_()));
                    }
                    return boxes;
                }
                int posCount = buffer.readInt();
                HashMapList map = new HashMapList();
                for (int i = 0; i < posCount; ++i) {
                    BlockPos posList = buffer.m_130135_();
                    int boxCount = buffer.readInt();
                    ArrayList<LittleBox> blockBoxes = new ArrayList<LittleBox>();
                    for (int j = 0; j < boxCount; ++j) {
                        blockBoxes.add(LittleBox.create(buffer.m_130100_()));
                    }
                    map.add((Object)posList, blockBoxes);
                }
                return new LittleBoxesNoOverlap(pos, grid, (HashMapList<BlockPos, LittleBox>)map);
            }
        }, (Class[])new Class[]{LittleBoxes.class, LittleBoxesNoOverlap.class, LittleBoxesSimple.class});
        NetworkFieldTypes.register((NetworkFieldTypeClass)new NetworkFieldTypeClass<PlacementPreview>(){

            protected void writeContent(PlacementPreview content, FriendlyByteBuf buffer) {
                if (content.levelUUID != null) {
                    buffer.writeBoolean(true);
                    buffer.m_130077_(content.levelUUID);
                } else {
                    buffer.writeBoolean(false);
                }
                NetworkFieldTypes.write(LittleGroup.class, (Object)content.previews, (FriendlyByteBuf)buffer);
                NetworkFieldTypes.write(PlacementMode.class, (Object)content.mode, (FriendlyByteBuf)buffer);
                NetworkFieldTypes.write(PlacementPosition.class, (Object)content.position, (FriendlyByteBuf)buffer);
                NetworkFieldTypes.write(LittleBoxAbsolute.class, (Object)content.box, (FriendlyByteBuf)buffer);
            }

            protected PlacementPreview readContent(FriendlyByteBuf buffer) {
                return PlacementPreview.load(buffer.readBoolean() ? buffer.m_130259_() : null, (LittleGroup)NetworkFieldTypes.read(LittleGroup.class, (FriendlyByteBuf)buffer), (PlacementMode)NetworkFieldTypes.read(PlacementMode.class, (FriendlyByteBuf)buffer), (PlacementPosition)NetworkFieldTypes.read(PlacementPosition.class, (FriendlyByteBuf)buffer), (LittleBoxAbsolute)NetworkFieldTypes.read(LittleBoxAbsolute.class, (FriendlyByteBuf)buffer));
            }
        }, PlacementPreview.class);
        NetworkFieldTypes.register((NetworkFieldTypeClass)new NetworkFieldTypeClass<SignalState>(){

            protected void writeContent(SignalState content, FriendlyByteBuf buffer) {
                content.write(buffer);
            }

            protected SignalState readContent(FriendlyByteBuf buffer) {
                return SignalState.read(buffer);
            }
        }, SignalState.class);
        NetworkFieldTypes.register((NetworkFieldTypeClass)new NetworkFieldTypeClass<LittleBlockChange>(){

            protected void writeContent(LittleBlockChange content, FriendlyByteBuf buffer) {
                buffer.m_130064_(content.pos());
                if (content.block() != null) {
                    buffer.writeBoolean(true);
                    buffer.m_130079_(content.block());
                } else {
                    buffer.writeBoolean(false);
                }
            }

            protected LittleBlockChange readContent(FriendlyByteBuf buffer) {
                return new LittleBlockChange(buffer.m_130135_(), buffer.readBoolean() ? buffer.m_130261_() : null);
            }
        }, LittleBlockChange.class);
        NetworkFieldTypes.register((NetworkFieldTypeClass)new NetworkFieldTypeClass<AnimationTimeline>(){

            protected void writeContent(AnimationTimeline content, FriendlyByteBuf buffer) {
                buffer.m_130079_(content.save());
            }

            protected AnimationTimeline readContent(FriendlyByteBuf buffer) {
                return new AnimationTimeline(buffer.m_130261_());
            }
        }, AnimationTimeline.class);
    }
}

