/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.placement.selection;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import team.creative.creativecore.common.util.registry.NamedHandlerRegistry;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.action.LittleAction;
import team.creative.littletiles.common.action.LittleActionException;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.entity.LittleEntity;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.level.handler.LittleAnimationHandler;
import team.creative.littletiles.common.mod.chiselsandbits.ChiselsAndBitsManager;
import team.creative.littletiles.common.placement.selection.AreaSelectionMode;

public abstract class SelectionMode {
    public static final NamedHandlerRegistry<SelectionMode> REGISTRY = new NamedHandlerRegistry(null);

    public String getName() {
        return REGISTRY.getId((Object)this);
    }

    public Component getTranslation() {
        return Component.m_237115_((String)("mode.selection." + REGISTRY.getId((Object)this)));
    }

    public abstract SelectionResult generateResult(Level var1, CompoundTag var2);

    public abstract void leftClick(Player var1, CompoundTag var2, BlockPos var3);

    public abstract void rightClick(Player var1, CompoundTag var2, BlockPos var3);

    public abstract void clear(ItemStack var1);

    public abstract LittleGroup getGroup(Level var1, Player var2, CompoundTag var3, boolean var4, boolean var5, boolean var6, boolean var7) throws LittleActionException;

    public void save(ItemStack stack) {
    }

    static {
        REGISTRY.registerDefault("area", (Object)new AreaSelectionMode());
    }

    public static class SelectionResult {
        public final Level level;
        public BlockPos.MutableBlockPos min = null;
        public BlockPos.MutableBlockPos max = null;
        public int blocks;
        public int ltBlocks = 0;
        public int ltTiles = 0;
        public LittleGrid minLtGrid = null;
        public int cbBlocks = 0;
        public int cbTiles = 0;
        public LittleGrid minCBGrid = null;

        public SelectionResult(Level level) {
            this.level = level;
        }

        private void addBlockDirectly(Level level, BlockPos pos) {
            LittleGroup specialPreviews;
            BlockEntity te = level.m_7702_(pos);
            if (te instanceof BETiles) {
                ++this.ltBlocks;
                this.ltTiles += ((BETiles)te).tilesCount();
                this.minLtGrid = this.minLtGrid == null ? ((BETiles)te).getGrid() : LittleGrid.max(this.minLtGrid, ((BETiles)te).getGrid());
            }
            if ((specialPreviews = ChiselsAndBitsManager.getGroup(te)) != null) {
                ++this.cbBlocks;
                this.cbTiles += specialPreviews.size();
                this.minCBGrid = this.minCBGrid == null ? specialPreviews.getGrid() : LittleGrid.max(this.minCBGrid, specialPreviews.getGrid());
            }
            if (LittleAction.isBlockValid(level.m_8055_(pos))) {
                ++this.blocks;
            }
        }

        public void addBlock(BlockPos pos) {
            if (this.min == null) {
                this.min = pos.m_122032_();
                this.max = pos.m_122032_();
            } else {
                this.min.m_122178_(Math.min(this.min.m_123341_(), pos.m_123341_()), Math.min(this.min.m_123342_(), pos.m_123342_()), Math.min(this.min.m_123343_(), pos.m_123343_()));
                this.max.m_122178_(Math.max(this.max.m_123341_(), pos.m_123341_()), Math.max(this.max.m_123342_(), pos.m_123342_()), Math.max(this.max.m_123343_(), pos.m_123343_()));
            }
            this.addBlockDirectly(this.level, pos);
        }

        protected void addBlocksWorld(Level level, BlockPos pos, BlockPos pos2) {
            int minX = Math.min(pos.m_123341_(), pos2.m_123341_());
            int minY = Math.min(pos.m_123342_(), pos2.m_123342_());
            int minZ = Math.min(pos.m_123343_(), pos2.m_123343_());
            int maxX = Math.max(pos.m_123341_(), pos2.m_123341_());
            int maxY = Math.max(pos.m_123342_(), pos2.m_123342_());
            int maxZ = Math.max(pos.m_123343_(), pos2.m_123343_());
            if (this.min == null) {
                this.min = new BlockPos.MutableBlockPos(minX, minY, minZ);
                this.max = new BlockPos.MutableBlockPos(maxX, maxY, maxZ);
            } else {
                this.min.m_122178_(Math.min(this.min.m_123341_(), minX), Math.min(this.min.m_123342_(), minY), Math.min(this.min.m_123343_(), minZ));
                this.max.m_122178_(Math.max(this.max.m_123341_(), minX), Math.max(this.max.m_123342_(), minY), Math.max(this.max.m_123343_(), minZ));
            }
            BlockPos.MutableBlockPos mutPos = new BlockPos.MutableBlockPos();
            for (int posX = minX; posX <= maxX; ++posX) {
                for (int posY = minY; posY <= maxY; ++posY) {
                    for (int posZ = minZ; posZ <= maxZ; ++posZ) {
                        this.addBlockDirectly(level, (BlockPos)mutPos.m_122178_(posX, posY, posZ));
                    }
                }
            }
        }

        public void addBlocks(BlockPos pos, BlockPos pos2) {
            int minX = Math.min(pos.m_123341_(), pos2.m_123341_());
            int minY = Math.min(pos.m_123342_(), pos2.m_123342_());
            int minZ = Math.min(pos.m_123343_(), pos2.m_123343_());
            int maxX = Math.max(pos.m_123341_(), pos2.m_123341_());
            int maxY = Math.max(pos.m_123342_(), pos2.m_123342_());
            int maxZ = Math.max(pos.m_123343_(), pos2.m_123343_());
            this.addBlocksWorld(this.level, pos, pos2);
            for (LittleEntity entity : ((LittleAnimationHandler)LittleTiles.ANIMATION_HANDLERS.get(this.level)).find(new AABB((double)minX, (double)minY, (double)minZ, (double)(maxX + 1), (double)(maxY + 1), (double)(maxZ + 1)))) {
                this.addBlocksWorld((Level)entity.getSubLevel(), pos, pos2);
            }
        }

        public Vec3i getSize() {
            return new Vec3i(this.max.m_123341_() - this.min.m_123341_(), this.max.m_123342_() - this.min.m_123342_(), this.max.m_123343_() - this.min.m_123343_());
        }
    }
}

