/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.placement.shape;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.transformation.Rotation;
import team.creative.creativecore.common.util.math.vec.VectorUtils;
import team.creative.creativecore.common.util.mc.PlayerUtils;
import team.creative.creativecore.common.util.mc.TickUtils;
import team.creative.littletiles.api.common.tool.ILittleTool;
import team.creative.littletiles.common.block.little.tile.LittleTileContext;
import team.creative.littletiles.common.grid.IGridBased;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.gui.GuiMarkShapeSelection;
import team.creative.littletiles.common.gui.tool.GuiConfigure;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.box.collection.LittleBoxes;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.placement.PlacementPosition;
import team.creative.littletiles.common.placement.mark.IMarkMode;
import team.creative.littletiles.common.placement.shape.LittleShape;
import team.creative.littletiles.common.placement.shape.ShapeRegistry;

public class ShapeSelection
implements Iterable<ShapeSelectPos>,
IGridBased,
IMarkMode {
    public ItemStack stack;
    public ILittleTool tool;
    private final List<ShapeSelectPos> positions = new ArrayList<ShapeSelectPos>();
    public final boolean inside;
    protected LittleShape shape;
    protected String shapeKey;
    protected BlockPos pos;
    private ShapeSelectPos last;
    protected LittleGrid grid = LittleGrid.min();
    protected LittleBox overallBox;
    protected ShapeSelectCache cache;
    private boolean marked;
    private int markedPosition;
    public boolean allowLowResolution = true;

    public ShapeSelection(ItemStack stack, boolean inside) {
        this.inside = inside;
        this.tool = (ILittleTool)stack.m_41720_();
        this.stack = stack;
        this.shapeKey = this.getNBT().m_128461_("shape");
        this.shape = (LittleShape)ShapeRegistry.REGISTRY.get(this.shapeKey);
    }

    public CompoundTag getNBT() {
        return this.stack.m_41784_();
    }

    protected boolean requiresCacheUpdate() {
        if (this.cache == null) {
            return true;
        }
        if (this.cache.grid != this.grid) {
            return true;
        }
        CompoundTag nbt = this.getNBT();
        if (!this.shapeKey.equals(nbt.m_128461_("shape"))) {
            this.shapeKey = nbt.m_128461_("shape");
            this.shape = (LittleShape)ShapeRegistry.REGISTRY.get(this.shapeKey);
            if (!this.cache.shapeKey.equals(this.shapeKey)) {
                return true;
            }
        }
        if (this.countPositions() != this.cache.positions.size()) {
            return true;
        }
        int i = 0;
        for (ShapeSelectPos pos : this) {
            if (!pos.equals(this.cache.positions.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public LittleBox getOverallBox() {
        return this.overallBox.copy();
    }

    protected ShapeSelectCache getCache() {
        if (this.requiresCacheUpdate()) {
            LittleBox[] pointBoxes = new LittleBox[this.countPositions()];
            ArrayList<ShapeSelectPos> positions = new ArrayList<ShapeSelectPos>(pointBoxes.length);
            int i = 0;
            for (ShapeSelectPos pos : this) {
                pointBoxes[i] = new LittleBox(pos.pos.getRelative(this.pos));
                positions.add(pos.copy());
                ++i;
            }
            this.overallBox = new LittleBox(pointBoxes);
            this.cache = new ShapeSelectCache(this.grid, positions);
        }
        return this.cache;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public LittleGrid getGrid() {
        return this.grid;
    }

    public LittleBoxes getBoxes(boolean allowLowResolution) {
        if (this.allowLowResolution && allowLowResolution) {
            return this.getCache().get(true);
        }
        return this.getCache().get(false);
    }

    public void deleteCache() {
        this.cache = null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addAndCheckIfPlace(Player player, PlacementPosition position, BlockHitResult result) {
        if (this.marked) {
            return true;
        }
        ShapeSelectPos pos = new ShapeSelectPos(player, position, result);
        if (!(this.shape.pointsBeforePlacing <= this.positions.size() + 1 && !Screen.m_96637_() || this.shape.maxAllowed() != -1 && this.shape.maxAllowed() <= this.positions.size() + 1)) {
            this.positions.add(pos);
            this.ensureSameContext(pos);
            return false;
        }
        this.last = pos;
        this.ensureSameContext(this.last);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setLast(Player player, ItemStack stack, PlacementPosition position, BlockHitResult result) {
        this.stack = stack;
        if (result == null) {
            return;
        }
        if (this.positions.isEmpty()) {
            this.pos = position.getPos();
        }
        this.last = new ShapeSelectPos(player, position, result);
        this.ensureSameContext(this.last);
    }

    private void ensureSameContext(ShapeSelectPos pos) {
        if (this.grid.count > pos.getGrid().count) {
            pos.convertTo(this.grid);
        } else if (this.grid.count < pos.getGrid().count) {
            this.convertTo(pos.getGrid());
        }
    }

    public void toggleMark() {
        if (this.marked) {
            while (this.shape.maxAllowed() != -1 && this.positions.size() >= this.shape.maxAllowed()) {
                this.positions.remove(this.positions.size() - 1);
            }
            this.markedPosition = this.positions.size() - 1;
            this.marked = false;
        } else {
            this.markedPosition = this.positions.size();
            this.positions.add(this.last);
            this.marked = true;
        }
    }

    @Override
    public boolean allowLowResolution() {
        return this.allowLowResolution;
    }

    @Override
    public PlacementPosition getPosition() {
        return this.positions.get((int)this.markedPosition).pos.copy();
    }

    @Override
    public GuiConfigure getConfigurationGui() {
        return new GuiMarkShapeSelection(this);
    }

    @Override
    public void move(LittleGrid grid, Facing facing) {
        this.positions.get(this.markedPosition).move(grid, facing);
        this.deleteCache();
    }

    @Override
    public void done() {
        this.toggleMark();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(LittleGrid positionGrid, PoseStack pose) {
        if (this.marked) {
            for (int i = 0; i < this.positions.size(); ++i) {
                this.positions.get(i).render(positionGrid, pose, this.markedPosition == i);
            }
        }
    }

    public void rotate(Player player, ItemStack stack, Rotation rotation) {
        this.shape.rotate(this.getNBT(), rotation);
        this.deleteCache();
    }

    public void mirror(Player player, ItemStack stack, Axis axis) {
        this.shape.mirror(this.getNBT(), axis);
        this.deleteCache();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void click(Player player) {
        if (!this.marked) {
            return;
        }
        int index = -1;
        double distance = Double.MAX_VALUE;
        float partialTickTime = TickUtils.getFrameTime((LevelAccessor)player.f_19853_);
        Vec3 pos = player.m_20318_(partialTickTime);
        double reach = PlayerUtils.getReach((Player)player);
        Vec3 view = player.m_20252_(partialTickTime);
        Vec3 look = pos.m_82520_(view.f_82479_ * reach, view.f_82480_ * reach, view.f_82481_ * reach);
        for (int i = 0; i < this.positions.size(); ++i) {
            double tempDistance;
            Optional result = this.positions.get(i).getBox().m_82371_(pos, look);
            if (!result.isPresent() || !((tempDistance = pos.m_82557_((Vec3)result.get())) < distance)) continue;
            index = i;
            distance = tempDistance;
        }
        if (index != -1) {
            this.markedPosition = index;
        }
    }

    @Override
    public Iterator<ShapeSelectPos> iterator() {
        if (this.marked) {
            return this.positions.iterator();
        }
        return new Iterator<ShapeSelectPos>(){
            private Iterator<ShapeSelectPos> iter;
            private boolean last;
            {
                this.iter = ShapeSelection.this.positions.iterator();
                this.last = false;
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext() || !this.last;
            }

            @Override
            public ShapeSelectPos next() {
                if (this.iter.hasNext()) {
                    return this.iter.next();
                }
                if (!this.last) {
                    this.last = true;
                    return ShapeSelection.this.last;
                }
                throw new UnsupportedOperationException();
            }
        };
    }

    public ShapeSelectPos getFirst() {
        if (this.positions.size() > 0) {
            return this.positions.get(0);
        }
        return this.last;
    }

    public ShapeSelectPos getLast() {
        if (this.marked) {
            return this.positions.get(this.positions.size() - 1);
        }
        return this.last;
    }

    @Override
    public void convertTo(LittleGrid to) {
        for (ShapeSelectPos other : this.positions) {
            other.convertTo(to);
        }
        this.grid = to;
    }

    @Override
    public int getSmallest() {
        int smallest = LittleGrid.min().count;
        for (int i = 0; i < this.positions.size(); ++i) {
            smallest = Math.max(smallest, this.positions.get(i).getSmallest());
        }
        return smallest;
    }

    public int countPositions() {
        return this.positions.size() + (this.marked ? 0 : 1);
    }

    public class ShapeSelectCache {
        protected final List<ShapeSelectPos> positions;
        protected final LittleGrid grid;
        protected final LittleShape shape;
        protected final String shapeKey;
        protected final LittleBoxes cachedBoxesLowRes;
        protected LittleBoxes cachedBoxes;

        public ShapeSelectCache(LittleGrid grid, List<ShapeSelectPos> positions) {
            this.grid = grid;
            CompoundTag nbt = ShapeSelection.this.getNBT();
            this.shapeKey = nbt.m_128461_("shape");
            this.shape = (LittleShape)ShapeRegistry.REGISTRY.get(this.shapeKey);
            this.positions = positions;
            this.cachedBoxesLowRes = this.shape.getBoxes(ShapeSelection.this, true);
        }

        public LittleBoxes get(boolean allowLowResolution) {
            if (allowLowResolution) {
                return this.cachedBoxesLowRes;
            }
            if (this.cachedBoxes == null) {
                this.cachedBoxes = this.shape.getBoxes(ShapeSelection.this, false);
            }
            return this.cachedBoxes;
        }
    }

    public class ShapeSelectPos
    implements IGridBased {
        public final PlacementPosition pos;
        public final BlockHitResult ray;
        public final LittleTileContext result;

        public ShapeSelectPos(Player player, PlacementPosition position, BlockHitResult result) {
            this.pos = position;
            this.ray = result;
            this.result = LittleTileContext.selectFocused((BlockGetter)player.f_19853_, result.m_82425_(), player);
            if (ShapeSelection.this.inside && result.m_82434_().m_122421_() == Direction.AxisDirection.POSITIVE && ShapeSelection.this.grid.isAtEdge(VectorUtils.get((Direction.Axis)result.m_82434_().m_122434_(), (Vec3)result.m_82450_()))) {
                this.pos.getVec().sub(Facing.get((Direction)result.m_82434_()));
            }
        }

        public ShapeSelectPos(PlacementPosition position, BlockHitResult ray, LittleTileContext result) {
            this.pos = position;
            this.ray = ray;
            this.result = result;
        }

        public void move(LittleGrid context, Facing facing) {
            LittleVec vec = new LittleVec(facing);
            vec.scale(Screen.m_96637_() ? context.count : 1);
            this.pos.subVec(vec);
        }

        public boolean equals(Object obj) {
            if (obj instanceof ShapeSelectPos) {
                if (!this.pos.equals(((ShapeSelectPos)obj).pos)) {
                    return false;
                }
                if (this.result.parent != ((ShapeSelectPos)obj).result.parent) {
                    return false;
                }
                return this.result.tile == ((ShapeSelectPos)obj).result.tile;
            }
            return false;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void render(LittleGrid grid, PoseStack pose, boolean selected) {
            Minecraft mc = Minecraft.m_91087_();
            AABB box = this.getBox().m_82400_(0.002);
            VertexConsumer consumer = mc.m_91269_().m_110104_().m_6299_(RenderType.m_110504_());
            RenderSystem.m_69832_((float)4.0f);
            LevelRenderer.m_109646_((PoseStack)pose, (VertexConsumer)consumer, (AABB)box, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            RenderSystem.m_69832_((float)1.0f);
            LevelRenderer.m_109646_((PoseStack)pose, (VertexConsumer)consumer, (AABB)box, (float)1.0f, (float)0.3f, (float)0.0f, (float)1.0f);
        }

        public AABB getBox() {
            return this.pos.getBox(ShapeSelection.this.grid);
        }

        @Override
        public LittleGrid getGrid() {
            return this.pos.getGrid();
        }

        @Override
        public void convertTo(LittleGrid to) {
            this.pos.convertTo(to);
        }

        @Override
        public int getSmallest() {
            return this.pos.getSmallest();
        }

        public ShapeSelectPos copy() {
            return new ShapeSelectPos(this.pos.copy(), this.ray, this.result);
        }
    }
}

