/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.placement.shape.type;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.simple.GuiStateButton;
import team.creative.creativecore.common.gui.controls.simple.GuiSteppedSlider;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.interpolation.CubicInterpolation;
import team.creative.creativecore.common.util.math.interpolation.HermiteInterpolation;
import team.creative.creativecore.common.util.math.interpolation.LinearInterpolation;
import team.creative.creativecore.common.util.math.transformation.Rotation;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.math.vec.VecNd;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.box.collection.LittleBoxes;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.placement.shape.LittleShape;
import team.creative.littletiles.common.placement.shape.ShapeSelection;

public class LittleShapeCurve
extends LittleShape {
    private static String[] interpolationTypes = new String[]{"hermite", "cubic", "linear"};

    public LittleShapeCurve() {
        super(2);
    }

    @Override
    protected void addBoxes(LittleBoxes boxes, ShapeSelection selection, boolean lowResolution) {
        ArrayList<Vec3d> points = new ArrayList<Vec3d>();
        double halfPixelSize = selection.getGrid().halfPixelLength;
        for (ShapeSelection.ShapeSelectPos pos : selection) {
            points.add(new Vec3d(pos.pos.getPosX() + halfPixelSize, pos.pos.getPosY() + halfPixelSize, pos.pos.getPosZ() + halfPixelSize));
        }
        int thickness = Math.max(0, selection.getNBT().m_128451_("thickness") - 1);
        if (points.size() <= 1) {
            LittleBox box = selection.getOverallBox();
            box.growCentered(thickness);
            boxes.add(box);
            return;
        }
        HermiteInterpolation interpolation = switch (selection.getNBT().m_128451_("interpolation")) {
            case 0 -> new HermiteInterpolation((VecNd[])points.toArray(new Vec3d[0]));
            case 1 -> new CubicInterpolation((VecNd[])points.toArray(new Vec3d[0]));
            default -> new LinearInterpolation((VecNd[])points.toArray(new Vec3d[0]));
        };
        Vec3d origin = new Vec3d((double)boxes.pos.m_123341_(), (double)boxes.pos.m_123342_(), (double)boxes.pos.m_123343_());
        double pointTime = 1.0 / (double)(points.size() - 1);
        for (int i = 0; i < points.size() - 1; ++i) {
            Vec3d before = (Vec3d)points.get(i);
            Vec3d end = (Vec3d)points.get(i + 1);
            Vec3d middle = (Vec3d)interpolation.valueAt(pointTime * ((double)i + 0.5));
            double distance = before.distance(middle) + middle.distance(end);
            int stepCount = (int)Math.ceil(distance / boxes.grid.pixelLength * 2.0);
            double stepSize = pointTime / (double)(stepCount - 1);
            for (int j = 0; j < stepCount; ++j) {
                Vec3d vec = (Vec3d)interpolation.valueAt(pointTime * (double)i + stepSize * (double)j);
                vec.sub(origin);
                LittleBox box = new LittleBox(new LittleVec(boxes.grid, vec));
                box.growCentered(thickness);
                boxes.add(box);
            }
        }
    }

    @Override
    public boolean requiresNoOverlap() {
        return true;
    }

    @Override
    public void addExtraInformation(CompoundTag nbt, List<Component> list) {
        list.add((Component)Component.m_237115_((String)"gui.interpolation").m_130946_(": ").m_7220_((Component)Component.m_237115_((String)("gui." + interpolationTypes[nbt.m_128451_("interpolation")]))));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<GuiControl> getCustomSettings(CompoundTag nbt, LittleGrid grid) {
        ArrayList<GuiControl> controls = new ArrayList<GuiControl>();
        controls.add((GuiControl)new GuiSteppedSlider("thickness", nbt.m_128451_("thickness"), 1, grid.count));
        controls.add((GuiControl)new GuiStateButton("interpolation", nbt.m_128451_("interpolation"), interpolationTypes));
        return controls;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void saveCustomSettings(GuiParent gui, CompoundTag nbt, LittleGrid grid) {
        GuiSteppedSlider slider = (GuiSteppedSlider)gui.get("thickness");
        nbt.m_128405_("thickness", (int)slider.value);
        nbt.m_128405_("interpolation", ((GuiStateButton)gui.get("interpolation")).getState());
    }

    @Override
    public void rotate(CompoundTag nbt, Rotation rotation) {
    }

    @Override
    public void mirror(CompoundTag nbt, Axis axis) {
    }
}

