/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.animation.event;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.registries.ForgeRegistries;
import team.creative.littletiles.common.structure.animation.context.AnimationContext;
import team.creative.littletiles.common.structure.animation.event.AnimationEvent;

public class PlaySoundEvent
extends AnimationEvent<CompoundTag> {
    public SoundEvent sound;
    public float volume;
    public float pitch;

    public static SoundEvent get(ResourceLocation location) {
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(location);
        if (sound != null) {
            return sound;
        }
        return SoundEvent.m_262824_((ResourceLocation)location);
    }

    public PlaySoundEvent(CompoundTag nbt) {
        this.sound = PlaySoundEvent.get(new ResourceLocation(nbt.m_128461_("s")));
        this.volume = nbt.m_128457_("v");
        this.pitch = nbt.m_128457_("p");
    }

    public PlaySoundEvent(SoundEvent event, float volume, float pitch) {
        this.sound = event;
        this.volume = volume;
        this.pitch = pitch;
    }

    @Override
    public CompoundTag save() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("s", this.sound.m_11660_().toString());
        nbt.m_128350_("v", this.volume);
        nbt.m_128350_("p", this.pitch);
        return nbt;
    }

    @Override
    public void start(AnimationContext context) {
        context.play(this.sound, this.volume, this.pitch);
    }

    @Override
    public boolean isDone(int ticksActive, AnimationContext context) {
        return true;
    }

    public PlaySoundEvent copy() {
        return new PlaySoundEvent(this.sound, this.volume, this.pitch);
    }

    @Override
    public int reverseTick(int start, int duration, AnimationContext context) {
        return start;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PlaySoundEvent) {
            PlaySoundEvent other = (PlaySoundEvent)obj;
            return this.sound.equals(other.sound) && this.volume == other.volume && this.pitch == other.pitch;
        }
        return false;
    }
}

