/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.registry.gui;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ArrayUtils;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.controls.simple.GuiCheckBox;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.littletiles.common.gui.controls.animation.GuiChildEventPanel;
import team.creative.littletiles.common.gui.tool.recipe.GuiTreeItemStructure;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.animation.AnimationState;
import team.creative.littletiles.common.structure.animation.AnimationTimeline;
import team.creative.littletiles.common.structure.animation.curve.ValueInterpolation;
import team.creative.littletiles.common.structure.animation.event.ChildDoorEvent;
import team.creative.littletiles.common.structure.registry.gui.LittleStructureGui;
import team.creative.littletiles.common.structure.registry.gui.LittleStructureGuiControl;
import team.creative.littletiles.common.structure.relative.StructureRelative;
import team.creative.littletiles.common.structure.type.animation.LittleActivatorDoor;
import team.creative.littletiles.common.structure.type.animation.LittleDoor;

@OnlyIn(value=Dist.CLIENT)
public class LittleDoorActivatorGui
extends LittleStructureGuiControl {
    public LittleDoorActivatorGui(LittleStructureGui gui, GuiTreeItemStructure item) {
        super(gui, item);
        this.flow = GuiFlow.STACK_Y;
        this.registerEventChanged(x -> this.updateTimeline());
    }

    @Override
    public void create(@Nullable LittleStructure structure) {
        boolean rightClick = true;
        int[] activated = new int[]{};
        if (structure instanceof LittleDoor) {
            LittleDoor door = (LittleDoor)structure;
            rightClick = door.rightClick;
            if (structure instanceof LittleActivatorDoor) {
                LittleActivatorDoor act = (LittleActivatorDoor)structure;
                activated = act.toActivate;
            } else {
                List<AnimationTimeline.AnimationEventEntry> events = GuiChildEventPanel.extract(door.getTransition("opening"), ChildDoorEvent.class);
                IntArrayList list = new IntArrayList();
                for (AnimationTimeline.AnimationEventEntry entry : events) {
                    list.add(((ChildDoorEvent)entry.getEvent()).childId);
                }
                activated = list.toIntArray();
            }
        }
        this.add(new GuiCheckBox("rightClick", rightClick).setTranslate("gui.rightclick").setTooltip("gui.door.rightclick.tooltip"));
        for (int i = 0; i < this.item.itemsCount(); ++i) {
            if (!(this.item.getChildStructure(i) instanceof LittleDoor)) continue;
            this.add((GuiControl)new GuiCheckBox("c" + i, ArrayUtils.contains((int[])activated, (int)i)).setTitle((Component)Component.m_237113_((String)((GuiTreeItemStructure)this.item.getItem(i)).getTitle())));
        }
        this.updateTimeline();
    }

    public void updateTimeline() {
        AnimationTimeline timeline = this.generateTimeline(this.generateActivated());
        this.item.recipe.animation.setTimeline(this.item, timeline);
    }

    public int[] generateActivated() {
        IntArrayList list = new IntArrayList();
        for (GuiChildControl child : this.controls) {
            GuiControl guiControl = child.control;
            if (!(guiControl instanceof GuiCheckBox)) continue;
            GuiCheckBox box = (GuiCheckBox)guiControl;
            if (!box.value || !box.name.startsWith("c")) continue;
            list.add(Integer.parseInt(box.name.replace("c", "")));
        }
        return list.toIntArray();
    }

    public AnimationTimeline generateTimeline(int[] activated) {
        int duration = 1;
        ArrayList<AnimationTimeline.AnimationEventEntry> entries = new ArrayList<AnimationTimeline.AnimationEventEntry>();
        for (int i = 0; i < activated.length; ++i) {
            LittleStructure littleStructure = this.item.getChildStructure(activated[i]);
            if (!(littleStructure instanceof LittleDoor)) continue;
            LittleDoor door = (LittleDoor)littleStructure;
            duration = Math.max(duration, door.duration);
            entries.add(new AnimationTimeline.AnimationEventEntry(0, new ChildDoorEvent(activated[i])));
        }
        return new AnimationTimeline(duration, entries);
    }

    @Override
    public LittleStructure save(LittleStructure structure) {
        LittleActivatorDoor door = (LittleActivatorDoor)structure;
        door.center = new StructureRelative(new LittleBox(this.item.group.getMinVec()), this.item.group.getGrid());
        door.rightClick = ((GuiCheckBox)this.get((String)"rightClick", GuiCheckBox.class)).value;
        door.toActivate = this.generateActivated();
        door.interpolation = ValueInterpolation.HERMITE;
        door.putState(new AnimationState("closed"));
        door.putState(new AnimationState("opened"));
        AnimationTimeline timeline = this.generateTimeline(door.toActivate);
        AnimationTimeline reversed = timeline.copy();
        reversed.reverse(this.item);
        door.putTransition("closed", "opened", "opening", timeline);
        door.putTransition("opened", "closed", "closing", reversed);
        return structure;
    }
}

