/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.registry.premade;

import com.google.common.base.Charsets;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.io.IOUtils;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.mc.NBTUtils;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.block.little.tile.parent.IStructureParentCollection;
import team.creative.littletiles.common.item.ItemPremadeStructure;
import team.creative.littletiles.common.structure.LittleStructureType;
import team.creative.littletiles.common.structure.attribute.LittleAttributeBuilder;
import team.creative.littletiles.common.structure.registry.LittleStructureRegistry;
import team.creative.littletiles.common.structure.registry.premade.LittlePremadePreview;
import team.creative.littletiles.common.structure.signal.logic.SignalMode;
import team.creative.littletiles.common.structure.type.premade.LittleBlankOMatic;
import team.creative.littletiles.common.structure.type.premade.LittleExporter;
import team.creative.littletiles.common.structure.type.premade.LittleImporter;
import team.creative.littletiles.common.structure.type.premade.LittleParticleEmitter;
import team.creative.littletiles.common.structure.type.premade.LittleStructureBuilder;
import team.creative.littletiles.common.structure.type.premade.LittleStructurePremade;
import team.creative.littletiles.common.structure.type.premade.LittleWorkbench;
import team.creative.littletiles.common.structure.type.premade.signal.LittleSignalCable;
import team.creative.littletiles.common.structure.type.premade.signal.LittleSignalDisplay;
import team.creative.littletiles.common.structure.type.premade.signal.LittleSignalInput;
import team.creative.littletiles.common.structure.type.premade.signal.LittleSignalOutput;

public class LittlePremadeRegistry {
    private static final List<LittleStructurePremade.LittlePremadeType> STRUCTURES = new ArrayList<LittleStructurePremade.LittlePremadeType>();
    private static final HashMap<String, LittlePremadePreview> PREVIEWS = new HashMap();

    public static void reload() {
        PREVIEWS.clear();
        ItemPremadeStructure.clearCache();
        int loaded = 0;
        for (LittleStructurePremade.LittlePremadeType type : STRUCTURES) {
            try {
                ItemStack stack = type.createItemStackEmpty();
                CompoundTag structureNBT = new CompoundTag();
                structureNBT.m_128359_("id", type.id);
                CompoundTag nbt = TagParser.m_129359_((String)IOUtils.toString((InputStream)LittleStructurePremade.class.getClassLoader().getResourceAsStream("data/" + type.modid + "/premade/" + type.id + ".struct"), (Charset)Charsets.UTF_8));
                CompoundTag originalNBT = nbt.m_128441_("s") ? nbt.m_128469_("s") : null;
                nbt.m_128365_("s", (Tag)structureNBT);
                if (originalNBT != null) {
                    NBTUtils.mergeNotOverwrite((CompoundTag)structureNBT, (CompoundTag)originalNBT);
                }
                stack.m_41751_(nbt);
                LittleGroup previews = LittleGroup.load(stack.m_41784_());
                CompoundTag stackNBT = new CompoundTag();
                stackNBT.m_128365_("s", (Tag)structureNBT);
                stack.m_41751_(stackNBT);
                PREVIEWS.put(type.id, new LittlePremadePreview(previews, stack));
                ++loaded;
            }
            catch (Exception e) {
                e.printStackTrace();
                LittleTiles.LOGGER.info("Could not load {}. Structure will not be available.", (Object)type.id);
            }
        }
        LittleTiles.LOGGER.info("Loaded {} premade structure models", (Object)loaded);
    }

    public static <T extends LittleStructurePremade> LittleStructurePremade.LittlePremadeType register(String id, String modid, Class<T> structureClass, BiFunction<? extends LittleStructurePremade.LittlePremadeType, IStructureParentCollection, T> factory) {
        return LittlePremadeRegistry.register(id, modid, structureClass, factory, new LittleAttributeBuilder());
    }

    public static <T extends LittleStructurePremade> LittleStructurePremade.LittlePremadeType register(String id, String modid, Class<T> structureClass, BiFunction<? extends LittleStructurePremade.LittlePremadeType, IStructureParentCollection, T> factory, LittleAttributeBuilder attribute) {
        LittleStructurePremade.LittlePremadeType type = (LittleStructurePremade.LittlePremadeType)LittleStructureRegistry.register(new LittleStructurePremade.LittlePremadeType(id, structureClass, factory, attribute, modid));
        STRUCTURES.add(type);
        return type;
    }

    public static LittleStructurePremade.LittlePremadeType register(LittleStructurePremade.LittlePremadeType type) {
        STRUCTURES.add((LittleStructurePremade.LittlePremadeType)LittleStructureRegistry.register(type));
        return type;
    }

    public static LittleGroup getLittleGroup(String id) {
        LittlePremadePreview type = LittlePremadeRegistry.getPreview(id);
        if (type != null) {
            return type.previews;
        }
        return null;
    }

    public static LittlePremadePreview getPreview(String id) {
        return PREVIEWS.get(id);
    }

    public static Collection<LittlePremadePreview> previews() {
        return PREVIEWS.values();
    }

    public static List<LittleStructurePremade.LittlePremadeType> types() {
        return STRUCTURES;
    }

    public static Set<String> keySet() {
        return PREVIEWS.keySet();
    }

    public static LittleStructurePremade.LittlePremadeType get(String id) {
        LittleStructureType type = (LittleStructureType)LittleStructureRegistry.REGISTRY.get(id);
        if (type instanceof LittleStructurePremade.LittlePremadeType) {
            return (LittleStructurePremade.LittlePremadeType)type;
        }
        return null;
    }

    public static ItemStack tryCreateStack(String id) {
        LittlePremadePreview preview = PREVIEWS.get(id);
        if (preview != null) {
            return preview.stack.m_41777_();
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack createStack(String id) {
        return LittlePremadeRegistry.PREVIEWS.get((Object)id).stack.m_41777_();
    }

    public static void initStructures() {
        LittlePremadeRegistry.register("workbench", "littletiles", LittleWorkbench.class, LittleWorkbench::new);
        LittlePremadeRegistry.register("importer", "littletiles", LittleImporter.class, LittleImporter::new);
        LittlePremadeRegistry.register("exporter", "littletiles", LittleExporter.class, LittleExporter::new);
        LittlePremadeRegistry.register(new LittleParticleEmitter.LittleStructureTypeParticleEmitter("particle_emitter", LittleParticleEmitter.class, LittleParticleEmitter::new, new LittleAttributeBuilder().ticking(), "littletiles")).addOutput("disabled", 1, SignalMode.TOGGLE, true).setFieldDefault("facing", Facing.UP);
        LittlePremadeRegistry.register("blankomatic", "littletiles", LittleBlankOMatic.class, LittleBlankOMatic::new);
        LittlePremadeRegistry.register(new LittleSignalCable.LittleStructureTypeCable("single_cable1", LittleSignalCable.class, LittleSignalCable::new, new LittleAttributeBuilder().extraRendering(), "littletiles", 1));
        LittlePremadeRegistry.register(new LittleSignalCable.LittleStructureTypeCable("single_cable4", LittleSignalCable.class, LittleSignalCable::new, new LittleAttributeBuilder().extraRendering(), "littletiles", 4));
        LittlePremadeRegistry.register(new LittleSignalCable.LittleStructureTypeCable("single_cable16", LittleSignalCable.class, LittleSignalCable::new, new LittleAttributeBuilder().extraRendering(), "littletiles", 16));
        LittlePremadeRegistry.register(new LittleSignalOutput.LittleStructureTypeOutput("single_output1", LittleSignalOutput.class, LittleSignalOutput::new, new LittleAttributeBuilder().extraRendering(), "littletiles", 1));
        LittlePremadeRegistry.register(new LittleSignalOutput.LittleStructureTypeOutput("single_output4", LittleSignalOutput.class, LittleSignalOutput::new, new LittleAttributeBuilder().extraRendering(), "littletiles", 4));
        LittlePremadeRegistry.register(new LittleSignalOutput.LittleStructureTypeOutput("single_output16", LittleSignalOutput.class, LittleSignalOutput::new, new LittleAttributeBuilder().extraRendering(), "littletiles", 16));
        LittlePremadeRegistry.register(new LittleSignalInput.LittleStructureTypeInput("single_input1", LittleSignalInput.class, LittleSignalInput::new, new LittleAttributeBuilder().extraRendering(), "littletiles", 1));
        LittlePremadeRegistry.register(new LittleSignalInput.LittleStructureTypeInput("single_input4", LittleSignalInput.class, LittleSignalInput::new, new LittleAttributeBuilder().extraRendering(), "littletiles", 4));
        LittlePremadeRegistry.register(new LittleSignalInput.LittleStructureTypeInput("single_input16", LittleSignalInput.class, LittleSignalInput::new, new LittleAttributeBuilder().extraRendering(), "littletiles", 16));
        LittlePremadeRegistry.register("signal_display_16", "littletiles", LittleSignalDisplay.class, LittleSignalDisplay::new, new LittleAttributeBuilder().tickRendering()).addOutput("pixels", 16, SignalMode.EQUAL, true);
        LittlePremadeRegistry.register("structure_builder", "littletiles", LittleStructureBuilder.class, LittleStructureBuilder::new);
    }
}

