/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.relative;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.transformation.Rotation;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.grid.IGridBased;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.math.vec.LittleVecGrid;
import team.creative.littletiles.common.placement.box.LittlePlaceBoxRelative;
import team.creative.littletiles.common.structure.directional.StructureDirectionalField;

public class StructureRelative
implements IGridBased {
    protected LittleGrid grid;
    protected LittleBox box;

    public StructureRelative(LittleBox box, LittleGrid grid) {
        this.box = box;
        this.grid = grid;
    }

    public StructureRelative(int[] array) {
        this.box = new LittleBox(array[0], array[1], array[2], array[3], array[4], array[5]);
        this.grid = LittleGrid.get(array[6]);
    }

    public LittleVec getDoubledCenterVec() {
        return new LittleVec(this.box.maxX + this.box.minX, this.box.maxY + this.box.minY, this.box.maxZ + this.box.minZ);
    }

    public Vec3d getCenter() {
        return new Vec3d(this.grid.toVanillaGrid(this.box.maxX + this.box.minX) / 2.0, this.grid.toVanillaGrid(this.box.maxY + this.box.minY) / 2.0, this.grid.toVanillaGrid(this.box.maxZ + this.box.minZ) / 2.0);
    }

    public boolean isEven() {
        return this.box.getSize(Axis.X) > 1;
    }

    public LittleBox getBox() {
        return this.box;
    }

    @Override
    public LittleGrid getGrid() {
        return this.grid;
    }

    @Override
    public void convertTo(LittleGrid grid) {
        this.box.convertTo(this.grid, grid);
        this.grid = grid;
    }

    @Override
    public int getSmallest() {
        return this.box.getSmallest(this.grid);
    }

    public int[] write() {
        return new int[]{this.box.minX, this.box.minY, this.box.minZ, this.box.maxX, this.box.maxY, this.box.maxZ, this.grid.count};
    }

    public void setBox(BlockPos pos, LittleBox box, LittleGrid grid) {
        this.box = box;
        this.grid = grid;
        this.add(pos);
    }

    public LittleVecGrid getMinVec() {
        return new LittleVecGrid(this.box.getMinVec(), this.grid);
    }

    public LittlePlaceBoxRelative getPlaceBox(LittleGroup previews, StructureDirectionalField type) {
        return new LittlePlaceBoxRelative(this.box, this, type);
    }

    public void move(LittleVecGrid offset) {
        this.sameGrid(offset, () -> this.box.add(offset.getVec()));
    }

    public void mirror(LittleGrid grid, Axis axis, LittleVec doubledCenter) {
        if (grid.count > this.grid.count) {
            this.convertTo(grid);
        } else if (grid.count < this.grid.count) {
            doubledCenter = doubledCenter.copy();
            doubledCenter.convertTo(grid, this.grid);
        }
        this.box.mirror(axis, doubledCenter);
        this.convertToSmallest();
    }

    public void rotate(LittleGrid grid, Rotation rotation, LittleVec doubledCenter) {
        if (grid.count > this.grid.count) {
            this.convertTo(grid);
        } else if (grid.count < this.grid.count) {
            doubledCenter = doubledCenter.copy();
            doubledCenter.convertTo(grid, this.grid);
        }
        this.box.rotate(rotation, doubledCenter);
        this.convertToSmallest();
    }

    public BlockPos getOffset() {
        return this.box.getMinVec().getBlockPos(this.grid);
    }

    public void add(BlockPos pos) {
        this.box.add(new LittleVec(this.grid, (Vec3i)pos));
    }

    public void add(LittleVecGrid vec) {
        int scale = 1;
        if (vec.getGrid().count > this.grid.count) {
            this.convertTo(vec.getGrid());
        } else if (vec.getGrid().count < this.grid.count) {
            scale = this.grid.count / vec.getGrid().count;
        }
        this.box.add(vec.getVec().x * scale, vec.getVec().y * scale, vec.getVec().z * scale);
        this.convertToSmallest();
    }

    public void sub(BlockPos pos) {
        this.box.sub(new LittleVec(this.grid, (Vec3i)pos));
    }

    public void sub(LittleVecGrid vec) {
        int scale = 1;
        if (vec.getGrid().count > this.grid.count) {
            this.convertTo(vec.getGrid());
        } else if (vec.getGrid().count < this.grid.count) {
            scale = this.grid.count / vec.getGrid().count;
        }
        this.box.sub(vec.getVec().x * scale, vec.getVec().y * scale, vec.getVec().z * scale);
        this.convertToSmallest();
    }

    public void advancedScale(int from, int to) {
        int current = this.grid.count;
        current = from > to ? (current *= from / to) : (current /= to / from);
        this.grid = LittleGrid.get(current);
    }
}

