/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.type;

import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.AlignedBox;
import team.creative.creativecore.common.util.math.vec.Vec3f;
import team.creative.creativecore.common.util.type.list.IndexedCollector;
import team.creative.littletiles.client.render.tile.LittleRenderBox;
import team.creative.littletiles.client.render.tile.LittleRenderBoxItem;
import team.creative.littletiles.common.block.little.tile.LittleTileContext;
import team.creative.littletiles.common.block.little.tile.parent.IStructureParentCollection;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.LittleStructureType;
import team.creative.littletiles.common.structure.directional.StructureDirectional;
import team.creative.littletiles.common.structure.relative.StructureRelative;
import team.creative.littletiles.common.structure.signal.SignalState;

public class LittleItemHolder
extends LittleStructure {
    @StructureDirectional(color=0xFF0001)
    public StructureRelative frame;
    @StructureDirectional
    public Facing facing;
    @StructureDirectional
    public Vec3f topRight;
    public ItemStack stack;

    public LittleItemHolder(LittleStructureType type, IStructureParentCollection mainBlock) {
        super(type, mainBlock);
    }

    @Override
    protected void loadExtra(CompoundTag nbt) {
        this.stack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("stack"));
    }

    @Override
    protected void saveExtra(CompoundTag nbt) {
        nbt.m_128365_("stack", (Tag)this.stack.m_41739_(new CompoundTag()));
    }

    @Override
    public boolean canInteract() {
        return true;
    }

    @Override
    public InteractionResult use(Level level, LittleTileContext context, BlockPos pos, Player player, BlockHitResult result) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack mainStack = player.m_21205_();
        if (mainStack.m_41619_() && !this.stack.m_41619_()) {
            if (player.m_150109_().m_36040_(player.m_150109_().f_35977_, this.stack)) {
                this.stack = ItemStack.f_41583_;
            }
            this.updateInput();
            this.updateStructure();
        } else if (this.stack.m_41619_()) {
            this.stack = mainStack.m_41777_();
            if (!player.m_150110_().f_35937_) {
                mainStack.m_41774_(1);
            }
            this.updateInput();
            this.updateStructure();
        }
        return InteractionResult.SUCCESS;
    }

    public void updateInput() {
        this.getInput(0).updateState(SignalState.of(!this.stack.m_41619_()));
    }

    @Override
    public void getRenderingBoxes(BlockPos pos, RenderType layer, IndexedCollector<LittleRenderBox> cubes) {
        if (layer == RenderType.m_110463_()) {
            AlignedBox box = this.frame.getBox().getBox(this.frame.getGrid());
            if (!this.stack.m_41619_()) {
                cubes.add((Object)new LittleRenderBoxItem(this, box, this.frame.getBox()));
            }
        }
    }
}

