/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.type.premade.signal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.client.render.box.RenderBox;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.AlignedBox;
import team.creative.creativecore.common.util.math.vec.VectorUtils;
import team.creative.creativecore.common.util.mc.ColorUtils;
import team.creative.creativecore.common.util.type.list.IndexedCollector;
import team.creative.creativecore.common.util.type.list.Pair;
import team.creative.creativecore.common.util.type.map.HashMapList;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.client.render.tile.LittleRenderBox;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;
import team.creative.littletiles.common.block.little.tile.parent.IStructureParentCollection;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.box.LittleBoxAbsolute;
import team.creative.littletiles.common.math.box.SurroundingBox;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.attribute.LittleAttributeBuilder;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;
import team.creative.littletiles.common.structure.signal.component.ISignalComponent;
import team.creative.littletiles.common.structure.signal.component.ISignalStructureBase;
import team.creative.littletiles.common.structure.signal.component.InvalidSignalComponent;
import team.creative.littletiles.common.structure.signal.component.SignalComponentType;
import team.creative.littletiles.common.structure.signal.network.SignalNetwork;
import team.creative.littletiles.common.structure.type.premade.LittleStructurePremade;

public abstract class LittleSignalCableBase
extends LittleStructurePremade
implements ISignalStructureBase {
    public static final int DEFAULT_CABLE_COLOR = -13619152;
    private SignalNetwork network;
    public int color;
    protected LittleConnectionFace[] faces = new LittleConnectionFace[this.getNumberOfConnections()];

    public LittleSignalCableBase(LittleStructureTypeNetwork type, IStructureParentCollection mainBlock) {
        super(type, mainBlock);
    }

    @Override
    public boolean compatible(ISignalStructureBase other) {
        if (ISignalStructureBase.super.compatible(other)) {
            if (other.getComponentType() == SignalComponentType.TRANSMITTER && this.getComponentType() == SignalComponentType.TRANSMITTER) {
                return other.getColor() == -13619152 || this.getColor() == -13619152 || this.getColor() == other.getColor();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hasStructureColor() {
        return true;
    }

    @Override
    public int getStructureColor() {
        return this.color;
    }

    @Override
    public int getDefaultColor() {
        return -13619152;
    }

    @Override
    public void paint(int color) {
        this.color = color;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public SignalNetwork getNetwork() {
        return this.network;
    }

    @Override
    public void setNetwork(SignalNetwork network) {
        this.network = network;
    }

    @Override
    public Level getStructureLevel() {
        return this.getLevel();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void loadUpdatePacket(CompoundTag nbt) {
        super.loadUpdatePacket(nbt);
        this.mainBlock.getBE().render.tilesChanged();
    }

    @Override
    protected void loadExtra(CompoundTag nbt) {
        int[] result = nbt.m_128465_("faces");
        if (result != null && result.length == this.getNumberOfConnections() * 3) {
            for (int i = 0; i < this.faces.length; ++i) {
                int distance = result[i * 3];
                if (distance < 0) {
                    this.faces[i] = null;
                    continue;
                }
                this.faces[i] = new LittleConnectionFace();
                this.faces[i].distance = distance;
                this.faces[i].grid = LittleGrid.get(result[i * 3 + 1]);
                this.faces[i].oneSidedRenderer = result[i * 3 + 2] == 1;
            }
        } else if (result != null && result.length == this.getNumberOfConnections() * 2) {
            for (int i = 0; i < this.faces.length; ++i) {
                int distance = result[i * 2];
                if (distance < 0) {
                    this.faces[i] = null;
                    continue;
                }
                this.faces[i] = new LittleConnectionFace();
                this.faces[i].distance = distance;
                this.faces[i].grid = LittleGrid.get(result[i * 2 + 1]);
            }
        }
        this.color = nbt.m_128441_("color") ? nbt.m_128451_("color") : -13619152;
    }

    @Override
    protected void saveInternalExtra(CompoundTag nbt, boolean preview) {
        super.saveInternalExtra(nbt, preview);
        if (!preview && this.faces != null) {
            int[] result = new int[this.getNumberOfConnections() * 3];
            for (int i = 0; i < this.faces.length; ++i) {
                if (this.faces[i] != null && !this.faces[i].invalid) {
                    result[i * 3] = this.faces[i].distance;
                    result[i * 3 + 1] = this.faces[i].grid.count;
                    result[i * 3 + 2] = this.faces[i].oneSidedRenderer ? 1 : 0;
                    continue;
                }
                result[i * 3] = -1;
                result[i * 3 + 1] = 0;
                result[i * 3 + 2] = 0;
            }
            nbt.m_128385_("faces", result);
        }
        if (this.color != -1) {
            nbt.m_128405_("color", this.color);
        }
    }

    @Override
    protected void saveExtra(CompoundTag nbt) {
    }

    public abstract Facing getFacing(int var1);

    public abstract int getIndex(Facing var1);

    @Override
    public int getBandwidth() {
        return ((LittleStructureTypeNetwork)this.type).bandwidth;
    }

    public int getNumberOfConnections() {
        return ((LittleStructureTypeNetwork)this.type).numberOfConnections;
    }

    @Override
    public boolean connect(Facing facing, ISignalStructureBase base, LittleGrid grid, int distance, boolean oneSidedRenderer) {
        int index = this.getIndex(facing);
        if (this.faces[index] != null) {
            if (this.faces[index].getConnection() == base) {
                return false;
            }
            this.faces[index].disconnect(facing);
        } else {
            this.faces[index] = new LittleConnectionFace();
        }
        this.faces[index].connect(base, grid, distance, oneSidedRenderer);
        return true;
    }

    @Override
    public void disconnect(Facing facing, ISignalStructureBase base) {
        int index = this.getIndex(facing);
        if (this.faces[index] != null) {
            this.faces[index] = null;
            this.updateStructure();
        }
    }

    @Override
    public void neighbourChanged() {
        try {
            this.checkConnections();
            if (this.isClient()) {
                return;
            }
            LittleBoxAbsolute box = this.getSurroundingBox().getAbsoluteBox();
            boolean changed = false;
            for (int i = 0; i < this.faces.length; ++i) {
                Facing facing = this.getFacing(i);
                LittleConnectResult result = this.checkConnection(facing, box);
                if (result != null) {
                    changed |= this.connect(facing, result.base, result.grid, result.distance, result.oneSidedRenderer);
                    changed |= result.base.connect(facing.opposite(), this, result.grid, result.distance, result.oneSidedRenderer);
                    continue;
                }
                if (this.faces[i] != null) {
                    this.faces[i].disconnect(facing);
                    changed = true;
                }
                this.faces[i] = null;
            }
            if (changed) {
                this.findNetwork();
            }
        }
        catch (CorruptedConnectionException | NotYetConnectedException structureException) {
            // empty catch block
        }
    }

    @Override
    public Iterator<ISignalStructureBase> connections() {
        try {
            this.checkConnections();
            return new Iterator<ISignalStructureBase>(){
                LittleBoxAbsolute box;
                int index;
                {
                    this.box = LittleSignalCableBase.this.getSurroundingBox().getAbsoluteBox();
                    this.index = this.searchForNextIndex(0);
                }

                int searchForNextIndex(int index) {
                    while (!(index >= LittleSignalCableBase.this.faces.length || LittleSignalCableBase.this.faces[index] != null && LittleSignalCableBase.this.faces[index].verifyConnect(LittleSignalCableBase.this.getFacing(index), this.box))) {
                        LittleSignalCableBase.this.faces[index] = null;
                        ++index;
                    }
                    return index;
                }

                @Override
                public boolean hasNext() {
                    return this.index < LittleSignalCableBase.this.faces.length && LittleSignalCableBase.this.faces[this.index] != null;
                }

                @Override
                public ISignalStructureBase next() {
                    ISignalStructureBase next = LittleSignalCableBase.this.faces[this.index].getConnection();
                    this.index = this.searchForNextIndex(this.index + 1);
                    return next;
                }
            };
        }
        catch (CorruptedConnectionException | NotYetConnectedException structureException) {
            return new Iterator<ISignalStructureBase>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public ISignalStructureBase next() {
                    return null;
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LittleConnectResult checkConnection(Level level, LittleBoxAbsolute box, Facing facing, BlockPos pos) throws ConnectionException, NotYetConnectedException {
        try {
            if (!level.m_46805_(pos)) {
                throw new NotYetConnectedException();
            }
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof BETiles) {
                BETiles be = (BETiles)blockEntity;
                LittleTile closest = null;
                IParentCollection parent = null;
                int minDistance = 0;
                for (Pair<IParentCollection, LittleTile> pair : be.allTiles()) {
                    LittleTile tile = (LittleTile)pair.value;
                    if (((IParentCollection)pair.key).isStructureChild(this)) continue;
                    Iterator<LittleBox> iterator = tile.iterator();
                    while (iterator.hasNext()) {
                        LittleBox tileBox = iterator.next();
                        int distance = box.getDistanceIfEqualFromOneSide(facing, tileBox, ((IParentCollection)pair.key).getPos(), ((IParentCollection)pair.key).getGrid());
                        if (distance < 0 || closest != null && minDistance <= distance) continue;
                        closest = tile;
                        parent = (IParentCollection)pair.key;
                        minDistance = distance;
                    }
                }
                if (closest != null && parent.isStructure()) {
                    LittleStructure structure = parent.getStructure();
                    if (structure instanceof ISignalStructureBase && ((ISignalStructureBase)((Object)structure)).compatible(this)) {
                        box = box.createBoxFromFace(facing, minDistance);
                        HashMapList<BlockPos, LittleBox> boxes = box.splitted();
                        for (Map.Entry entry : boxes.entrySet()) {
                            BlockEntity toSearchIn = level.m_7702_((BlockPos)entry.getKey());
                            if (toSearchIn instanceof BETiles) {
                                BETiles parsedSearch = (BETiles)toSearchIn;
                                LittleBox toCheck = (LittleBox)((ArrayList)entry.getValue()).get(0);
                                try {
                                    parsedSearch.minGrid(box.getGrid());
                                    if (parsedSearch.getGrid().count > box.getGrid().count) {
                                        toCheck.convertTo(box.getGrid(), parsedSearch.getGrid());
                                    }
                                    if (parsedSearch.isSpaceFor(toCheck)) continue;
                                    throw new ConnectionException("No space");
                                }
                                finally {
                                    parsedSearch.convertToSmallest();
                                    continue;
                                }
                            }
                            if (level.m_8055_((BlockPos)entry.getKey()).m_60767_().m_76336_()) continue;
                            throw new ConnectionException("Block in the way");
                        }
                        ISignalStructureBase base = (ISignalStructureBase)((Object)structure);
                        if (base.canConnect(facing.opposite())) {
                            return new LittleConnectResult(base, box.getGrid(), minDistance, false);
                        }
                        throw new ConnectionException("Side is invalid");
                    }
                    if (closest != null) {
                        throw new ConnectionException("Tile in the way");
                    }
                }
            } else if (blockEntity instanceof ISignalStructureBase && ((ISignalStructureBase)blockEntity).compatible(this)) {
                LittleGrid grid = box.grid;
                int minDistance = facing.positive ? 0 - grid.toGrid(VectorUtils.get((Axis)facing.axis, (Vec3i)box.pos) - VectorUtils.get((Axis)facing.axis, (Vec3i)pos)) - box.box.getMax(facing.axis) : box.box.getMin(facing.axis) - (grid.count - grid.toGrid(VectorUtils.get((Axis)facing.axis, (Vec3i)box.pos) - VectorUtils.get((Axis)facing.axis, (Vec3i)pos)));
                box = box.createBoxFromFace(facing, minDistance);
                HashMapList<BlockPos, LittleBox> boxes = box.splitted();
                for (Map.Entry entry : boxes.entrySet()) {
                    BlockEntity toSearchIn = level.m_7702_((BlockPos)entry.getKey());
                    if (toSearchIn instanceof BETiles) {
                        BETiles parsedSearch = (BETiles)toSearchIn;
                        LittleBox toCheck = (LittleBox)((ArrayList)entry.getValue()).get(0);
                        try {
                            parsedSearch.minGrid(box.getGrid());
                            if (parsedSearch.getGrid().count > box.getGrid().count) {
                                toCheck.convertTo(box.getGrid(), parsedSearch.getGrid());
                            }
                            if (parsedSearch.isSpaceFor(toCheck)) continue;
                            throw new ConnectionException("No space");
                        }
                        finally {
                            parsedSearch.convertToSmallest();
                            continue;
                        }
                    }
                    if (level.m_8055_((BlockPos)entry.getKey()).m_60767_().m_76336_()) continue;
                    throw new ConnectionException("Block in the way");
                }
                ISignalStructureBase base = (ISignalStructureBase)blockEntity;
                if (base.canConnect(facing.opposite())) {
                    return new LittleConnectResult(base, box.getGrid(), minDistance, true);
                }
                throw new ConnectionException("Side is invalid");
            }
        }
        catch (CorruptedConnectionException | NotYetConnectedException structureException) {
            // empty catch block
        }
        return null;
    }

    public LittleConnectResult checkConnection(Facing facing, LittleBoxAbsolute box) throws NotYetConnectedException {
        if (!this.canConnect(facing)) {
            return null;
        }
        BlockPos pos = box.getMinPos();
        if (facing.positive) {
            pos = VectorUtils.set((BlockPos)pos, (int)box.getMaxPos(facing.axis), (Axis)facing.axis);
        }
        Level level = this.getLevel();
        try {
            LittleConnectResult result;
            if ((facing.positive ? box.getMaxGridFrom(facing.axis, pos) < box.getGrid().count : box.getMinGridFrom(facing.axis, pos) > 0) && (result = this.checkConnection(level, box, facing, pos)) != null) {
                return result;
            }
            return this.checkConnection(level, box, facing, pos.m_121945_(facing.toVanilla()));
        }
        catch (ConnectionException e) {
            return null;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getRenderingBoxes(BlockPos pos, RenderType layer, IndexedCollector<LittleRenderBox> cubes) {
        if (ColorUtils.isInvisible((int)this.color)) {
            return;
        }
        if (layer != (ColorUtils.isTransparent((int)this.color) ? RenderType.m_110466_() : RenderType.m_110451_())) {
            return;
        }
        try {
            SurroundingBox box = this.getSurroundingBox();
            LittleVec min = box.getMinPosOffset();
            LittleVec max = box.getSize();
            max.add(min);
            LittleBox overallBox = new LittleBox(min, max);
            BlockPos difference = pos.m_121996_((Vec3i)box.getMinPos());
            overallBox.sub(box.getGrid().toGrid(difference.m_123341_()), box.getGrid().toGrid(difference.m_123342_()), box.getGrid().toGrid(difference.m_123343_()));
            this.render(box, overallBox, cubes);
        }
        catch (CorruptedConnectionException | NotYetConnectedException structureException) {
            // empty catch block
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderFace(Facing facing, LittleGrid grid, LittleBox renderBox, int distance, Axis axis, Axis one, Axis two, boolean positive, boolean oneSidedRenderer, IndexedCollector<LittleRenderBox> cubes) {
        if (positive) {
            renderBox.setMin(axis, renderBox.getMax(axis));
            renderBox.setMax(axis, renderBox.getMax(axis) + distance);
        } else {
            renderBox.setMax(axis, renderBox.getMin(axis));
            renderBox.setMin(axis, renderBox.getMin(axis) - distance);
        }
        LittleRenderBox cube = renderBox.getRenderingBox(grid, (BlockState)((Block)LittleTilesRegistry.SINGLE_CABLE.get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)axis.toVanilla()));
        if (!oneSidedRenderer) {
            if (positive) {
                cube.setMax(axis, cube.getMin(axis) + cube.getSize(axis) / 2.0f);
            } else {
                cube.setMin(axis, cube.getMax(axis) - cube.getSize(axis) / 2.0f);
            }
        }
        cube.color = this.color;
        cube.keepVU = true;
        cube.allowOverlap = true;
        float shrink = 0.18f;
        float shrinkOne = cube.getSize(one) * shrink;
        float shrinkTwo = cube.getSize(two) * shrink;
        cube.setMin(one, cube.getMin(one) + shrinkOne);
        cube.setMax(one, cube.getMax(one) - shrinkOne);
        cube.setMin(two, cube.getMin(two) + shrinkTwo);
        cube.setMax(two, cube.getMax(two) - shrinkTwo);
        cubes.add((Object)cube);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(SurroundingBox box, LittleBox overallBox, IndexedCollector<LittleRenderBox> cubes) {
        for (int i = 0; i < this.faces.length; ++i) {
            if (this.faces[i] == null) continue;
            int distance = this.faces[i].distance;
            Facing facing = this.getFacing(i);
            Axis one = facing.axis.one();
            Axis two = facing.axis.two();
            LittleGrid context = this.faces[i].grid;
            LittleBox renderBox = overallBox.copy();
            if (box.getGrid().count > context.count) {
                distance *= box.getGrid().count / context.count;
                context = box.getGrid();
            } else if (context.count > box.getGrid().count) {
                renderBox.convertTo(box.getGrid(), context);
            }
            this.renderFace(facing, context, renderBox, distance, facing.axis, one, two, facing.positive, this.faces[i].oneSidedRenderer, cubes);
        }
    }

    @Override
    public void structureDestroyed() {
        if (this.network != null && this.network.remove(this)) {
            for (int i = 0; i < this.faces.length; ++i) {
                if (this.faces[i] == null) continue;
                ISignalStructureBase connection = this.faces[i].connection;
                this.faces[i].disconnect(this.getFacing(i));
                connection.findNetwork();
            }
        }
    }

    @Override
    public void unload() {
        super.unload();
        for (int i = 0; i < this.faces.length; ++i) {
            if (this.faces[i] == null) continue;
            this.faces[i].unload(this.getFacing(i));
        }
        if (this.network != null) {
            this.network.unload(this);
        }
    }

    @Override
    public void unload(Facing facing, ISignalStructureBase base) {
        int index = this.getIndex(facing);
        if (this.faces[index] != null) {
            this.faces[index].connection = null;
        }
    }

    public class LittleConnectionFace {
        public ISignalStructureBase connection;
        public int distance;
        public LittleGrid grid;
        public boolean oneSidedRenderer;
        private boolean invalid;

        public void disconnect(Facing facing) {
            if (this.connection != null) {
                this.connection.disconnect(facing.opposite(), LittleSignalCableBase.this);
                if (LittleSignalCableBase.this.hasNetwork()) {
                    LittleSignalCableBase.this.getNetwork().remove(LittleSignalCableBase.this);
                }
            }
            this.connection = null;
            LittleSignalCableBase.this.updateStructure();
        }

        public void unload(Facing facing) {
            if (this.connection != null) {
                this.connection.unload(facing.opposite(), LittleSignalCableBase.this);
            }
            this.connection = null;
        }

        public void connect(ISignalStructureBase connection, LittleGrid grid, int distance, boolean oneSidedRenderer) {
            if (this.connection != null) {
                throw new RuntimeException("Cannot connect until old connection is closed");
            }
            this.oneSidedRenderer = oneSidedRenderer;
            if (LittleSignalCableBase.this.hasNetwork()) {
                LittleSignalCableBase.this.getNetwork().add(connection);
            }
            this.connection = connection;
            this.grid = grid;
            this.distance = distance;
            LittleSignalCableBase.this.updateStructure();
        }

        public boolean verifyConnect(Facing facing, LittleBoxAbsolute box) {
            if (this.connection != null) {
                return true;
            }
            try {
                LittleConnectResult result = LittleSignalCableBase.this.checkConnection(facing, box);
                this.invalid = false;
                if (result != null) {
                    this.connection = result.base;
                    this.grid = result.grid;
                    this.distance = result.distance;
                    return true;
                }
            }
            catch (NotYetConnectedException e) {
                this.invalid = true;
            }
            return false;
        }

        public ISignalStructureBase getConnection() {
            if (this.invalid) {
                return InvalidSignalComponent.INSTANCE;
            }
            return this.connection;
        }
    }

    public static abstract class LittleStructureTypeNetwork
    extends LittleStructurePremade.LittlePremadeType
    implements ISignalComponent {
        public final int bandwidth;
        public final int numberOfConnections;

        public <T extends LittleSignalCableBase> LittleStructureTypeNetwork(String id, Class<T> structureClass, BiFunction<? extends LittleStructureTypeNetwork, IStructureParentCollection, T> factory, LittleAttributeBuilder attribute, String modid, int bandwidth, int numberOfConnections) {
            super(id, structureClass, factory, attribute.neighborListener(), modid);
            this.bandwidth = bandwidth;
            this.numberOfConnections = numberOfConnections;
        }

        public int getColor(LittleGroup group) {
            if (group.hasStructure() && group.getStructureTag().m_128441_("color")) {
                return group.getStructureTag().m_128451_("color");
            }
            return -13619152;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public List<RenderBox> getPositingCubes(Level level, BlockPos pos, ItemStack stack) {
            try {
                ArrayList<RenderBox> cubes = new ArrayList<RenderBox>();
                for (int i = 0; i < 6; ++i) {
                    Facing facing = Facing.values()[i];
                    BlockEntity blockEntity = level.m_7702_(pos.m_121945_(facing.toVanilla()));
                    if (!(blockEntity instanceof BETiles)) continue;
                    for (LittleStructure structure : ((BETiles)blockEntity).loadedStructures()) {
                        if (!(structure instanceof ISignalStructureBase) || ((ISignalStructureBase)((Object)structure)).getBandwidth() != this.bandwidth || !((ISignalStructureBase)((Object)structure)).canConnect(facing.opposite())) continue;
                        RenderBox cube = new RenderBox(new AlignedBox(structure.getSurroundingBox().getAABB().m_82386_((double)(-blockEntity.m_58899_().m_123341_()), (double)(-blockEntity.m_58899_().m_123342_()), (double)(-blockEntity.m_58899_().m_123343_()))));
                        cube.setMin(facing.axis, 0.0f);
                        cube.setMax(facing.axis, 1.0f);
                        cubes.add(cube);
                    }
                }
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof BETiles) {
                    for (LittleStructure structure : ((BETiles)blockEntity).loadedStructures()) {
                        RenderBox cube;
                        if (!(structure instanceof ISignalStructureBase) || ((ISignalStructureBase)((Object)structure)).getBandwidth() != this.bandwidth) continue;
                        AABB box = structure.getSurroundingBox().getAABB().m_82386_((double)(-blockEntity.m_58899_().m_123341_()), (double)(-blockEntity.m_58899_().m_123342_()), (double)(-blockEntity.m_58899_().m_123343_()));
                        if (((ISignalStructureBase)((Object)structure)).canConnect(Facing.WEST) || ((ISignalStructureBase)((Object)structure)).canConnect(Facing.EAST)) {
                            cube = new RenderBox(new AlignedBox(box));
                            if (((ISignalStructureBase)((Object)structure)).canConnect(Facing.WEST)) {
                                cube.setMin(Axis.X, 0.0f);
                            }
                            if (((ISignalStructureBase)((Object)structure)).canConnect(Facing.EAST)) {
                                cube.setMax(Axis.X, 1.0f);
                            }
                            cubes.add(cube);
                        }
                        if (((ISignalStructureBase)((Object)structure)).canConnect(Facing.DOWN) || ((ISignalStructureBase)((Object)structure)).canConnect(Facing.UP)) {
                            cube = new RenderBox(new AlignedBox(box));
                            if (((ISignalStructureBase)((Object)structure)).canConnect(Facing.DOWN)) {
                                cube.setMin(Axis.Y, 0.0f);
                            }
                            if (((ISignalStructureBase)((Object)structure)).canConnect(Facing.UP)) {
                                cube.setMax(Axis.Y, 1.0f);
                            }
                            cubes.add(cube);
                        }
                        if (!((ISignalStructureBase)((Object)structure)).canConnect(Facing.NORTH) && !((ISignalStructureBase)((Object)structure)).canConnect(Facing.SOUTH)) continue;
                        cube = new RenderBox(new AlignedBox(box));
                        if (((ISignalStructureBase)((Object)structure)).canConnect(Facing.NORTH)) {
                            cube.setMin(Axis.Z, 0.0f);
                        }
                        if (((ISignalStructureBase)((Object)structure)).canConnect(Facing.SOUTH)) {
                            cube.setMax(Axis.Z, 1.0f);
                        }
                        cubes.add(cube);
                    }
                }
                if (cubes.isEmpty()) {
                    return null;
                }
                for (RenderBox cube : cubes) {
                    cube.color = ColorUtils.rgba((int)255, (int)255, (int)255, (int)90);
                }
                return cubes;
            }
            catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                return null;
            }
        }

        @Override
        public Level getStructureLevel() {
            return null;
        }

        @Override
        public LittleStructure getStructure() {
            return null;
        }

        @Override
        public boolean canSnapToGrid() {
            return false;
        }
    }

    public static class LittleConnectResult {
        public final ISignalStructureBase base;
        public final LittleGrid grid;
        public final int distance;
        public final boolean oneSidedRenderer;

        public LittleConnectResult(ISignalStructureBase base, LittleGrid grid, int distance, boolean oneSidedRenderer) {
            this.base = base;
            this.grid = grid;
            this.distance = distance;
            this.oneSidedRenderer = oneSidedRenderer;
        }
    }

    public static class ConnectionException
    extends Exception {
        public ConnectionException(String msg) {
            super(msg);
        }
    }
}

