/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.mixin.client.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import java.util.Set;
import net.minecraft.client.renderer.ChunkBufferBuilderPack;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Coerce;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import team.creative.creativecore.common.util.type.map.ChunkLayerMap;
import team.creative.littletiles.client.render.cache.ChunkLayerCache;
import team.creative.littletiles.client.render.level.LittleChunkDispatcher;
import team.creative.littletiles.client.render.mc.RebuildTaskExtender;
import team.creative.littletiles.client.render.mc.RenderChunkExtender;
import team.creative.littletiles.common.block.entity.BETiles;

@Mixin(targets={"net/minecraft/client/renderer/chunk/ChunkRenderDispatcher$RenderChunk$RebuildTask"})
public abstract class RebuildTaskMixin
implements RebuildTaskExtender {
    @Unique
    public Set<RenderType> renderTypes;
    @Unique
    public ChunkBufferBuilderPack pack;
    @Unique
    public ChunkLayerMap<ChunkLayerCache> caches;
    @Shadow(aliases={"this$0"})
    public ChunkRenderDispatcher.RenderChunk f_112859_;

    @Inject(at={@At(value="HEAD")}, method={"compile(FFFLnet/minecraft/client/renderer/ChunkBufferBuilderPack;)Lnet/minecraft/client/renderer/chunk/ChunkRenderDispatcher$RenderChunk$RebuildTask$CompileResults;"}, require=1)
    private void compileStart(float f1, float f2, float f3, ChunkBufferBuilderPack pack, CallbackInfoReturnable info) {
        this.pack = pack;
        LittleChunkDispatcher.startCompile((RenderChunkExtender)this.f_112859_);
    }

    @Inject(at={@At(value="TAIL")}, method={"compile(FFFLnet/minecraft/client/renderer/ChunkBufferBuilderPack;)Lnet/minecraft/client/renderer/chunk/ChunkRenderDispatcher$RenderChunk$RebuildTask$CompileResults;"}, require=1)
    private void compile(CallbackInfoReturnable info) {
        LittleChunkDispatcher.endCompile((RenderChunkExtender)this.f_112859_, this);
    }

    @Redirect(at=@At(value="NEW", target="(I)Lit/unimi/dsi/fastutil/objects/ReferenceArraySet;", remap=false), method={"compile(FFFLnet/minecraft/client/renderer/ChunkBufferBuilderPack;)Lnet/minecraft/client/renderer/chunk/ChunkRenderDispatcher$RenderChunk$RebuildTask$CompileResults;"}, require=1)
    private ReferenceArraySet afterSetCreated(int capacity) {
        this.renderTypes = new ReferenceArraySet(capacity);
        return (ReferenceArraySet)this.renderTypes;
    }

    @Inject(at={@At(value="HEAD")}, method={"handleBlockEntity(Lnet/minecraft/client/renderer/chunk/ChunkRenderDispatcher$RenderChunk$RebuildTask$CompileResults;Lnet/minecraft/world/level/block/entity/BlockEntity;)V"}, require=1)
    private void handleBlockEntity(@Coerce Object object, BlockEntity block, CallbackInfo info) {
        if (block instanceof BETiles) {
            BETiles tiles = (BETiles)block;
            LittleChunkDispatcher.add((RenderChunkExtender)this.f_112859_, tiles, this);
        }
    }

    @Override
    public BufferBuilder builder(RenderType layer) {
        BufferBuilder builder = this.pack.m_108839_(layer);
        if (this.renderTypes.add(layer)) {
            ((RenderChunkExtender)this.f_112859_).begin(builder);
        }
        return builder;
    }

    @Override
    public ChunkLayerMap<ChunkLayerCache> getLayeredCache() {
        return this.caches;
    }

    @Override
    public ChunkLayerCache getOrCreate(RenderType layer) {
        ChunkLayerCache cache;
        if (this.caches == null) {
            this.caches = new ChunkLayerMap();
        }
        if ((cache = (ChunkLayerCache)this.caches.get(layer)) == null) {
            cache = new ChunkLayerCache();
            this.caches.put(layer, (Object)cache);
        }
        return cache;
    }

    @Override
    public void clear() {
        this.pack = null;
        this.renderTypes = null;
    }
}

