/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.server.level.little;

import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.eventbus.api.Event;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.entity.animation.LittleAnimationLevel;
import team.creative.littletiles.common.level.little.LittleAnimationLevelCallback;
import team.creative.littletiles.common.packet.entity.LittleVanillaPacket;
import team.creative.littletiles.server.level.little.LittleServerEntity;

public class LittleAnimationLevelServerCallback
extends LittleAnimationLevelCallback {
    private final Int2ObjectMap<LittleServerEntity> entities = new Int2ObjectLinkedOpenHashMap();
    private final List<ServerPlayer> seenBy = new ArrayList<ServerPlayer>();
    private final BiConsumer<ServerPlayer, Packet<?>> broadcast = (x, y) -> LittleTiles.NETWORK.sendToClient((CreativePacket)new LittleVanillaPacket(this.level, (Packet)y), x);

    public LittleAnimationLevelServerCallback(LittleAnimationLevel level) {
        super(level);
    }

    public void onCreated(Entity entity) {
    }

    public void onDestroyed(Entity entity) {
        this.level.m_6188_().m_83420_(entity);
    }

    @Override
    public void tick() {
        super.tick();
        for (ServerEntity entity : this.entities.values()) {
            entity.m_8533_();
        }
    }

    public void onTrackingStart(Entity entity) {
        EntityType entitytype = entity.m_6095_();
        if (entitytype.m_20681_() * 16 != 0) {
            LittleServerEntity server = new LittleServerEntity((ServerLevel)this.level.getRealLevel(), entity, entitytype.m_20682_(), entitytype.m_20683_(), this::broadcast, this.broadcast);
            this.entities.put(entity.m_19879_(), (Object)server);
            for (ServerPlayer player : this.seenBy) {
                if (!entity.m_6459_(player)) continue;
                server.m_8541_(player);
            }
            entity.m_213651_(DynamicGameEventListener::m_223617_);
        }
    }

    public void onTrackingEnd(Entity entity) {
        ServerEntity server = (ServerEntity)this.entities.remove(entity.m_19879_());
        for (ServerPlayer player : this.seenBy) {
            server.m_8534_(player);
        }
        entity.m_213651_(DynamicGameEventListener::m_223634_);
        entity.onRemovedFromWorld();
        MinecraftForge.EVENT_BUS.post((Event)new EntityLeaveLevelEvent(entity, (Level)this.level));
    }

    @Override
    public void addTrackingPlayer(ServerPlayer player) {
        if (this.seenBy.add(player)) {
            for (ServerEntity entity : this.entities.values()) {
                entity.m_8541_(player);
            }
        }
    }

    @Override
    public void removeTrackingPlayer(ServerPlayer player) {
        if (this.seenBy.remove(player)) {
            for (ServerEntity entity : this.entities.values()) {
                entity.m_8534_(player);
            }
        }
    }

    public void broadcast(Packet<?> packet) {
        LittleVanillaPacket lt = new LittleVanillaPacket(this.level, packet);
        for (ServerPlayer player : this.seenBy) {
            LittleTiles.NETWORK.sendToClient((CreativePacket)lt, player);
        }
    }

    private boolean shouldDiscardEntity(Entity entity) {
        MinecraftServer server = this.level.m_7654_();
        if (server.m_6998_() || !(entity instanceof Animal) && !(entity instanceof WaterAnimal)) {
            return !server.m_6997_() && entity instanceof Npc;
        }
        return true;
    }

    @Override
    public void tickEntity(Entity entity) {
        if (entity.m_213877_()) {
            return;
        }
        if (this.shouldDiscardEntity(entity)) {
            entity.m_146870_();
            return;
        }
        entity.m_6043_();
        Entity vehicle = entity.m_20202_();
        if (vehicle != null) {
            if (!vehicle.m_213877_() && vehicle.m_20363_(entity)) {
                return;
            }
            entity.m_8127_();
        }
        if (!entity.m_213877_() && !(entity instanceof PartEntity)) {
            this.level.m_46653_(this::tickNonPassenger, entity);
        }
    }

    public void tickNonPassenger(Entity entity) {
        entity.m_146867_();
        ++entity.f_19797_;
        entity.m_8119_();
        for (Entity passenger : entity.m_20197_()) {
            this.tickPassenger(entity, passenger);
        }
    }

    private void tickPassenger(Entity vehicle, Entity entity) {
        if (!entity.m_213877_() && entity.m_20202_() == vehicle) {
            if (entity instanceof Player || this.tickingEntities.m_156914_(entity)) {
                entity.m_146867_();
                ++entity.f_19797_;
                if (entity.canUpdate()) {
                    entity.m_6083_();
                }
                for (Entity passenger : entity.m_20197_()) {
                    this.tickPassenger(entity, passenger);
                }
            }
        } else {
            entity.m_8127_();
        }
    }
}

