/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.server.level.little;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.io.IOException;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkTaskPriorityQueue;
import net.minecraft.server.level.ChunkTaskPriorityQueueSorter;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.util.thread.ProcessorHandle;
import net.minecraft.util.thread.ProcessorMailbox;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelStorageSource;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.util.unsafe.CreativeHackery;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.level.little.LittleChunkSerializer;
import team.creative.littletiles.common.level.little.LittleLevel;
import team.creative.littletiles.common.packet.entity.LittleVanillaPacket;
import team.creative.littletiles.server.level.little.LittleChunkHolder;
import team.creative.littletiles.server.level.little.LittleDistanceManager;
import team.creative.littletiles.server.level.little.LittleServerChunkCache;

public class LittleChunkMap
extends ChunkMap {
    private LittleServerChunkCache chunkCache;
    private ChunkScanAccess fakeAccess;
    private DistanceManager distanceManager;
    private ThreadedLevelLightEngine lightEngine;
    private ChunkTaskPriorityQueueSorter queueSorter;

    public LittleChunkMap(ServerLevel level, LevelStorageSource.LevelStorageAccess access, DataFixer fixer, StructureTemplateManager templateManager, Executor exe, BlockableEventLoop<Runnable> loop, LightChunkGetter lightGetter, ChunkGenerator generator, ChunkProgressListener progress, ChunkStatusUpdateListener status, Supplier<DimensionDataStorage> supplier, int viewDistance, boolean sync) {
        super(level, access, fixer, templateManager, exe, loop, lightGetter, generator, progress, status, supplier, viewDistance, sync);
    }

    public void init(ServerLevel level, LittleServerChunkCache chunkCache, LightChunkGetter lightGetter, Executor exe) {
        this.chunkCache = chunkCache;
        this.fakeAccess = (pos, visitor) -> CompletableFuture.runAsync(() -> {});
        ProcessorMailbox mailLight = ProcessorMailbox.m_18751_((Executor)exe, (String)"light");
        this.queueSorter = new ChunkTaskPriorityQueueSorter((List)ImmutableList.of((Object)mailLight), exe, Integer.MAX_VALUE);
        this.lightEngine = new ThreadedLevelLightEngine(lightGetter, (ChunkMap)this, level.m_6042_().f_223549_(), mailLight, this.queueSorter.m_140604_((ProcessorHandle)mailLight, false));
        this.distanceManager = (DistanceManager)CreativeHackery.allocateInstance(LittleDistanceManager.class);
    }

    public LittleChunkHolder addChunkLevel(LittleChunkHolder holder) {
        holder.chunk.m_62913_(true);
        holder.chunk.m_156369_();
        holder.chunk.m_187958_(this.chunkCache.f_8329_);
        return holder;
    }

    public LittleChunkHolder createHolder(ChunkPos pos) {
        return this.addChunkLevel(new LittleChunkHolder(this.chunkCache.f_8329_, pos, (LevelLightEngine)this.lightEngine));
    }

    public LittleChunkHolder createHolder(ChunkPos pos, CompoundTag nbt) {
        return this.addChunkLevel(new LittleChunkHolder(LittleChunkSerializer.read((LittleLevel)this.chunkCache.f_8329_, nbt), (LevelLightEngine)this.lightEngine));
    }

    public ClientboundLevelChunkWithLightPacket createPacket(LevelChunk chunk) {
        return new ClientboundLevelChunkWithLightPacket(chunk, (LevelLightEngine)this.lightEngine, (BitSet)null, (BitSet)null, true);
    }

    protected ChunkHolder m_140174_(long pos) {
        throw new UnsupportedOperationException();
    }

    protected ChunkHolder m_140327_(long pos) {
        throw new UnsupportedOperationException();
    }

    protected IntSupplier m_140371_(long pos) {
        return () -> ChunkTaskPriorityQueue.f_140508_ - 1;
    }

    public ThreadedLevelLightEngine m_140166_() {
        return this.lightEngine;
    }

    public void m_183825_() {
    }

    public String m_140204_(ChunkPos pos) {
        return "";
    }

    public ReportedException m_203751_(IllegalStateException exception, String message) {
        CrashReport crashreport = CrashReport.m_127521_((Throwable)exception, (String)"Chunk loading");
        CrashReportCategory crashreportcategory = crashreport.m_127514_("Chunk loading");
        crashreportcategory.m_128159_("Details", (Object)message);
        return new ReportedException(crashreport);
    }

    public void close() throws IOException {
    }

    public boolean m_201907_() {
        return false;
    }

    public CompletableFuture<Either<LevelChunk, ChunkHolder.ChunkLoadingFailure>> m_143117_(ChunkPos pos) {
        return null;
    }

    public CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> m_140292_(ChunkHolder holder, ChunkStatus status) {
        return null;
    }

    public CompletableFuture<Either<LevelChunk, ChunkHolder.ChunkLoadingFailure>> m_143053_(ChunkHolder holder) {
        return null;
    }

    public CompletableFuture<Either<LevelChunk, ChunkHolder.ChunkLoadingFailure>> m_143109_(ChunkHolder p_143110_) {
        return null;
    }

    public int m_140368_() {
        return 0;
    }

    public int m_140394_() {
        return this.chunkCache.m_8482_();
    }

    public DistanceManager m_143145_() {
        return this.distanceManager;
    }

    public List<ServerPlayer> m_183888_(ChunkPos pos) {
        return Collections.EMPTY_LIST;
    }

    public void m_140184_(ServerPlayer player) {
    }

    public List<ServerPlayer> m_183262_(ChunkPos pos, boolean all) {
        return Collections.EMPTY_LIST;
    }

    public String m_182285_() {
        return "";
    }

    public boolean m_223451_(ChunkPos pos, int range) {
        return false;
    }

    public CompoundTag m_188288_(ResourceKey<Level> levelKey, Supplier<DimensionDataStorage> storageSupplier, CompoundTag tag, Optional<ResourceKey<Codec<? extends ChunkGenerator>>> codec) {
        return tag;
    }

    public CompletableFuture<Optional<CompoundTag>> m_223454_(ChunkPos pos) {
        return null;
    }

    public void m_63502_(ChunkPos pos, CompoundTag tag) {
    }

    public void m_63514_() {
    }

    public ChunkScanAccess m_196922_() {
        return this.fakeAccess;
    }

    public void m_140421_() {
    }

    public void m_140331_(Entity entity) {
    }

    public void m_140199_(Entity entity) {
    }

    protected void m_140333_(Entity entity, Packet<?> packet) {
        LittleLevel level = (LittleLevel)this.chunkCache.m_7653_();
        LittleTiles.NETWORK.sendToClientTrackingAndSelf((CreativePacket)new LittleVanillaPacket(level, packet), level.getHolder());
    }

    public void m_140201_(Entity entity, Packet<?> packet) {
        LittleLevel level = (LittleLevel)this.chunkCache.m_7653_();
        LittleTiles.NETWORK.sendToClientTracking((CreativePacket)new LittleVanillaPacket(level, packet), level.getHolder());
    }
}

