/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.caprica.vlcj.factory.discovery;

import com.sun.jna.NativeLibrary;
import com.sun.jna.StringArray;
import java.lang.reflect.Field;
import java.util.Map;
import me.lib720.caprica.vlcj.binding.internal.libvlc_instance_t;
import me.lib720.caprica.vlcj.binding.lib.LibVlc;
import me.lib720.caprica.vlcj.binding.support.runtime.RuntimeUtil;
import me.lib720.caprica.vlcj.factory.discovery.strategy.LinuxNativeDiscoveryStrategy;
import me.lib720.caprica.vlcj.factory.discovery.strategy.NativeDiscoveryStrategy;
import me.lib720.caprica.vlcj.factory.discovery.strategy.OsxNativeDiscoveryStrategy;
import me.lib720.caprica.vlcj.factory.discovery.strategy.WindowsNativeDiscoveryStrategy;
import me.lib720.caprica.vlcj.support.version.LibVlcVersion;
import me.srrapero720.watermedia.Util;
import me.srrapero720.watermedia.WaterMedia;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class NativeDiscovery {
    protected static final String PLUGIN_ENV_NAME = "VLC_PLUGIN_PATH";
    private static boolean alreadyFound;
    private NativeDiscoveryStrategy successfulStrategy;
    private String discoveredPath;
    private static final NativeDiscoveryStrategy[] DEFAULT_STRATEGIES;
    private final NativeDiscoveryStrategy[] discoveryStrategies;
    private static Field searchPaths;
    private static Field libraries;
    private static final Marker IT;

    public NativeDiscovery(NativeDiscoveryStrategy ... discoveryStrategies) {
        this.discoveryStrategies = discoveryStrategies.length > 0 ? discoveryStrategies : DEFAULT_STRATEGIES;
    }

    public final boolean discover() {
        if (alreadyFound) {
            return true;
        }
        for (NativeDiscoveryStrategy discoveryStrategy : this.discoveryStrategies) {
            String path;
            if (!discoveryStrategy.supported() || (path = discoveryStrategy.discover()) == null) continue;
            WaterMedia.LOGGER.info(IT, "Attempt to load VLC in '{}'", (Object)path);
            if (discoveryStrategy.onFound(path)) {
                NativeLibrary.addSearchPath((String)RuntimeUtil.getLibVlcLibraryName(), (String)path);
            }
            this.tryPluginPath(path, discoveryStrategy);
            if (this.tryLoadingLibrary()) {
                this.successfulStrategy = discoveryStrategy;
                this.discoveredPath = path;
                this.onFound(path, discoveryStrategy);
                alreadyFound = true;
                return true;
            }
            WaterMedia.LOGGER.error(IT, "Failed loading VLC in '{}' using '{}' cleaning JNA", (Object)path, (Object)discoveryStrategy.getClass().getSimpleName());
            if (this.attemptFix(path, discoveryStrategy)) continue;
            this.onFailed(path, discoveryStrategy);
            return false;
        }
        this.onNotFound();
        return false;
    }

    public boolean attemptFix(String path, NativeDiscoveryStrategy discoveryStrategy) {
        if (searchPaths == null) {
            searchPaths = Util.getClassField(NativeLibrary.class, "searchPaths");
            libraries = Util.getClassField(NativeLibrary.class, "libraries");
        }
        try {
            Map libs = (Map)libraries.get(null);
            Map paths = (Map)searchPaths.get(null);
            libs.remove(RuntimeUtil.getLibVlcCoreLibraryName());
            paths.remove(RuntimeUtil.getLibVlcCoreLibraryName());
            libs.remove(RuntimeUtil.getLibVlcLibraryName());
            paths.remove(RuntimeUtil.getLibVlcLibraryName());
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            WaterMedia.LOGGER.error(IT, "attemptFix failed", (Throwable)e);
            return false;
        }
    }

    public final NativeDiscoveryStrategy successfulStrategy() {
        return this.successfulStrategy;
    }

    public final String discoveredPath() {
        return this.discoveredPath;
    }

    private void tryPluginPath(String path, NativeDiscoveryStrategy discoveryStrategy) {
        String env = System.getenv(PLUGIN_ENV_NAME);
        if (env == null || env.length() == 0) {
            discoveryStrategy.onSetPluginPath(path);
        }
    }

    private boolean tryLoadingLibrary() {
        try {
            libvlc_instance_t instance = LibVlc.libvlc_new(0, new StringArray(new String[0]));
            if (instance != null) {
                LibVlc.libvlc_release(instance);
                LibVlcVersion version = new LibVlcVersion();
                if (version.isSupported()) {
                    return true;
                }
            }
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println(e.getMessage());
        }
        return false;
    }

    protected void onFound(String path, NativeDiscoveryStrategy strategy) {
        WaterMedia.LOGGER.info(IT, "Located VLC in '{}' using '{}'", (Object)path, (Object)strategy.getClass().getSimpleName());
    }

    protected void onFailed(String path, NativeDiscoveryStrategy strategy) {
        WaterMedia.LOGGER.info(IT, "Failed to load VLC in '{}' using '{}'", (Object)path, (Object)strategy.getClass().getSimpleName());
    }

    protected void onNotFound() {
        WaterMedia.LOGGER.info(IT, "VLC cannot be found/loaded");
    }

    static {
        DEFAULT_STRATEGIES = new NativeDiscoveryStrategy[]{new WindowsNativeDiscoveryStrategy(), new OsxNativeDiscoveryStrategy(), new LinuxNativeDiscoveryStrategy()};
        IT = MarkerFactory.getMarker((String)"VideoLAN");
    }
}

