/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.caprica.vlcj.player.base;

import me.lib720.caprica.vlcj.binding.internal.libvlc_event_e;
import me.lib720.caprica.vlcj.binding.internal.libvlc_event_manager_t;
import me.lib720.caprica.vlcj.binding.internal.libvlc_event_t;
import me.lib720.caprica.vlcj.binding.internal.libvlc_instance_t;
import me.lib720.caprica.vlcj.binding.lib.LibVlc;
import me.lib720.caprica.vlcj.player.base.MediaPlayer;
import me.lib720.caprica.vlcj.player.base.MediaPlayerEventListener;
import me.lib720.caprica.vlcj.player.base.events.MediaPlayerEventFactory;
import me.lib720.caprica.vlcj.support.eventmanager.EventNotification;
import me.lib720.caprica.vlcj.support.eventmanager.NativeEventManager;

final class MediaPlayerNativeEventManager
extends NativeEventManager<MediaPlayer, MediaPlayerEventListener> {
    private boolean receivedPlayingEvent;

    MediaPlayerNativeEventManager(libvlc_instance_t libvlcInstance, MediaPlayer eventObject) {
        super(libvlcInstance, eventObject, libvlc_event_e.libvlc_MediaPlayerMediaChanged, libvlc_event_e.libvlc_MediaPlayerChapterChanged, "media-player-events");
    }

    @Override
    protected libvlc_event_manager_t onGetEventManager(MediaPlayer eventObject) {
        return LibVlc.libvlc_media_player_event_manager(eventObject.mediaPlayerInstance());
    }

    @Override
    protected EventNotification<MediaPlayerEventListener> onCreateEvent(libvlc_instance_t libvlcInstance, libvlc_event_t event, MediaPlayer eventObject) {
        switch (libvlc_event_e.event(event.type)) {
            case libvlc_MediaPlayerMediaChanged: {
                this.receivedPlayingEvent = false;
                break;
            }
            case libvlc_MediaPlayerPlaying: {
                this.receivedPlayingEvent = true;
                break;
            }
            case libvlc_MediaPlayerStopped: {
                if (this.receivedPlayingEvent) break;
                return null;
            }
        }
        return MediaPlayerEventFactory.createEvent(libvlcInstance, eventObject, event);
    }
}

