/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.jackson.databind.deser.std;

import java.io.IOException;
import me.lib720.jackson.core.JsonParser;
import me.lib720.jackson.databind.DeserializationConfig;
import me.lib720.jackson.databind.DeserializationContext;
import me.lib720.jackson.databind.JavaType;
import me.lib720.jackson.databind.deser.std.StdDeserializer;
import me.lib720.jackson.databind.jsontype.TypeDeserializer;
import me.lib720.jackson.databind.type.LogicalType;
import me.lib720.jackson.databind.util.AccessPattern;

public abstract class StdScalarDeserializer<T>
extends StdDeserializer<T> {
    private static final long serialVersionUID = 1L;

    protected StdScalarDeserializer(Class<?> vc) {
        super(vc);
    }

    protected StdScalarDeserializer(JavaType valueType) {
        super(valueType);
    }

    protected StdScalarDeserializer(StdScalarDeserializer<?> src) {
        super(src);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.OtherScalar;
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig config) {
        return Boolean.FALSE;
    }

    @Override
    public AccessPattern getNullAccessPattern() {
        return AccessPattern.ALWAYS_NULL;
    }

    @Override
    public AccessPattern getEmptyAccessPattern() {
        return AccessPattern.CONSTANT;
    }

    @Override
    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromScalar(p, ctxt);
    }

    @Override
    public T deserialize(JsonParser p, DeserializationContext ctxt, T intoValue) throws IOException {
        ctxt.handleBadMerge(this);
        return this.deserialize(p, ctxt);
    }
}

