/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import me.lib720.jackson.core.JsonGenerator;
import me.lib720.jackson.core.JsonToken;
import me.lib720.jackson.core.type.WritableTypeId;
import me.lib720.jackson.databind.JavaType;
import me.lib720.jackson.databind.JsonMappingException;
import me.lib720.jackson.databind.JsonNode;
import me.lib720.jackson.databind.SerializerProvider;
import me.lib720.jackson.databind.annotation.JacksonStdImpl;
import me.lib720.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import me.lib720.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import me.lib720.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import me.lib720.jackson.databind.jsontype.TypeSerializer;
import me.lib720.jackson.databind.node.ObjectNode;
import me.lib720.jackson.databind.ser.std.StdSerializer;

@JacksonStdImpl
public class ByteArraySerializer
extends StdSerializer<byte[]> {
    private static final long serialVersionUID = 1L;

    public ByteArraySerializer() {
        super(byte[].class);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, byte[] value) {
        return value.length == 0;
    }

    @Override
    public void serialize(byte[] value, JsonGenerator g, SerializerProvider provider) throws IOException {
        g.writeBinary(provider.getConfig().getBase64Variant(), value, 0, value.length);
    }

    @Override
    public void serializeWithType(byte[] value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId(value, JsonToken.VALUE_EMBEDDED_OBJECT));
        g.writeBinary(provider.getConfig().getBase64Variant(), value, 0, value.length);
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        ObjectNode o = this.createSchemaNode("array", true);
        ObjectNode itemSchema = this.createSchemaNode("byte");
        return o.set("items", itemSchema);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            v2.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

