/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import me.lib720.jackson.core.JsonGenerator;
import me.lib720.jackson.core.JsonToken;
import me.lib720.jackson.core.type.WritableTypeId;
import me.lib720.jackson.databind.JavaType;
import me.lib720.jackson.databind.JsonMappingException;
import me.lib720.jackson.databind.JsonNode;
import me.lib720.jackson.databind.SerializerProvider;
import me.lib720.jackson.databind.annotation.JacksonStdImpl;
import me.lib720.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import me.lib720.jackson.databind.jsontype.TypeSerializer;
import me.lib720.jackson.databind.ser.std.StdSerializer;

@JacksonStdImpl
public class ToEmptyObjectSerializer
extends StdSerializer<Object> {
    protected ToEmptyObjectSerializer(Class<?> raw) {
        super(raw, false);
    }

    public ToEmptyObjectSerializer(JavaType type) {
        super(type);
    }

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider ctxt) throws IOException {
        gen.writeStartObject(value, 0);
        gen.writeEndObject();
    }

    @Override
    public void serializeWithType(Object value, JsonGenerator gen, SerializerProvider ctxt, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen, typeSer.typeId(value, JsonToken.START_OBJECT));
        typeSer.writeTypeSuffix(gen, typeIdDef);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, Object value) {
        return true;
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return null;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        visitor.expectObjectFormat(typeHint);
    }
}

