/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.jackson.databind.util;

import java.io.Serializable;
import me.lib720.jackson.databind.AnnotationIntrospector;
import me.lib720.jackson.databind.BeanDescription;
import me.lib720.jackson.databind.JavaType;
import me.lib720.jackson.databind.PropertyName;
import me.lib720.jackson.databind.cfg.MapperConfig;
import me.lib720.jackson.databind.introspect.AnnotatedClass;
import me.lib720.jackson.databind.type.ClassKey;
import me.lib720.jackson.databind.util.LRUMap;

public class RootNameLookup
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient LRUMap<ClassKey, PropertyName> _rootNames = new LRUMap(20, 200);

    public PropertyName findRootName(JavaType rootType, MapperConfig<?> config) {
        return this.findRootName(rootType.getRawClass(), config);
    }

    public PropertyName findRootName(Class<?> rootType, MapperConfig<?> config) {
        AnnotatedClass ac;
        ClassKey key = new ClassKey(rootType);
        PropertyName name = this._rootNames.get(key);
        if (name != null) {
            return name;
        }
        BeanDescription beanDesc = config.introspectClassAnnotations(rootType);
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        name = intr.findRootName(ac = beanDesc.getClassInfo());
        if (name == null || !name.hasSimpleName()) {
            name = PropertyName.construct(rootType.getSimpleName());
        }
        this._rootNames.put(key, name);
        return name;
    }

    protected Object readResolve() {
        return new RootNameLookup();
    }
}

