/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.api.video;

import java.awt.Dimension;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import me.lib720.caprica.vlcj.binding.support.runtime.RuntimeUtil;
import me.lib720.caprica.vlcj.factory.MediaPlayerFactory;
import me.lib720.caprica.vlcj.media.InfoApi;
import me.lib720.caprica.vlcj.media.MediaRef;
import me.lib720.caprica.vlcj.media.MediaType;
import me.lib720.caprica.vlcj.media.TrackType;
import me.lib720.caprica.vlcj.player.base.MediaPlayer;
import me.lib720.caprica.vlcj.player.base.MediaPlayerEventListener;
import me.lib720.caprica.vlcj.player.base.State;
import me.lib720.caprica.vlcj.player.component.CallbackMediaPlayerComponent;
import me.lib720.caprica.vlcj.player.embedded.videosurface.callback.BufferFormatCallback;
import me.lib720.caprica.vlcj.player.embedded.videosurface.callback.RenderCallback;
import me.srrapero720.watermedia.WaterMedia;
import me.srrapero720.watermedia.api.WaterMediaAPI;
import me.srrapero720.watermedia.api.external.ThreadUtil;
import me.srrapero720.watermedia.api.video.VideoPlayer;
import me.srrapero720.watermedia.api.video.events.common.MediaFinishEvent;
import me.srrapero720.watermedia.api.video.events.common.MediaPauseEvent;
import me.srrapero720.watermedia.api.video.events.common.MediaResumeEvent;
import me.srrapero720.watermedia.api.video.events.common.MediaStoppedEvent;
import me.srrapero720.watermedia.api.video.events.common.MediaTimeChangedEvent;
import me.srrapero720.watermedia.api.video.events.common.MediaVolumeUpdateEvent;
import me.srrapero720.watermedia.api.video.events.common.PlayerBuffer;
import me.srrapero720.watermedia.api.video.events.common.PlayerExceptionEvent;
import me.srrapero720.watermedia.api.video.events.common.PlayerPreparingEvent;
import me.srrapero720.watermedia.api.video.events.common.PlayerReadyEvent;
import me.srrapero720.watermedia.api.video.events.common.PlayerStartedEvent;
import me.srrapero720.watermedia.core.videolan.VideoLAN;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

@Deprecated(forRemoval=true)
public class VideoLANPlayer
extends VideoPlayer {
    private static final Thread THREAD = Thread.currentThread();
    private static final ExecutorService EX = Executors.newSingleThreadExecutor(r -> {
        Thread t = new Thread(r);
        t.setPriority(1);
        t.setDaemon(true);
        t.setName("WATERMeDIA-services");
        t.setUncaughtExceptionHandler((t1, e) -> WaterMedia.LOGGER.error("Failed to execute release service", e));
        return t;
    });
    private static final Marker IT = MarkerFactory.getMarker((String)"VideoLanPlayer");
    private final AtomicBoolean buffering = new AtomicBoolean(false);
    private final AtomicBoolean prepared = new AtomicBoolean(false);
    private volatile int volume = 100;
    private volatile long duration = -1L;
    private volatile boolean safe = false;
    private volatile CallbackMediaPlayerComponent player;
    public final VideoPlayer.EventManager<VideoLANPlayer> EV = new VideoPlayer.EventManager();
    private final MediaPlayerEventListener eventListeners = new MediaPlayerEventListener(){

        @Override
        public void mediaChanged(MediaPlayer mediaPlayer, MediaRef media) {
            VideoLANPlayer.this.checkIfCurrentThreadHaveClassLoader();
            VideoLANPlayer.this.prepared.set(false);
        }

        @Override
        public void opening(MediaPlayer mediaPlayer) {
            VideoLANPlayer.this.checkIfCurrentThreadHaveClassLoader();
            VideoLANPlayer.this.EV.callPlayerPreparingEvent(VideoLANPlayer.this, new PlayerPreparingEvent.EventData());
        }

        @Override
        public void buffering(MediaPlayer mediaPlayer, float newCache) {
            VideoLANPlayer.this.checkIfCurrentThreadHaveClassLoader();
            VideoLANPlayer.this.EV.callPlayerBufferProgressEvent(VideoLANPlayer.this, new PlayerBuffer.EventProgressData(newCache));
            VideoLANPlayer.this.buffering.set(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void playing(MediaPlayer mediaPlayer) {
            VideoLANPlayer.this.checkIfCurrentThreadHaveClassLoader();
            VideoPlayer.EventManager<VideoLANPlayer> eventManager = VideoLANPlayer.this.EV;
            synchronized (eventManager) {
                if (VideoLANPlayer.this.buffering.getAndSet(false)) {
                    VideoLANPlayer.this.EV.callPlayerBufferEndEvent(VideoLANPlayer.this, new PlayerBuffer.EventEndData());
                }
                if (!VideoLANPlayer.this.prepared.get()) {
                    VideoLANPlayer.this.EV.callPlayerStartedEvent(VideoLANPlayer.this, new PlayerStartedEvent.EventData());
                } else {
                    VideoLANPlayer.this.EV.callMediaResumeEvent(VideoLANPlayer.this, new MediaResumeEvent.EventData(VideoLANPlayer.this.player.mediaPlayer().status().length()));
                }
            }
            mediaPlayer.submit(() -> mediaPlayer.audio().setVolume(VideoLANPlayer.this.volume));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paused(MediaPlayer mediaPlayer) {
            VideoLANPlayer.this.checkIfCurrentThreadHaveClassLoader();
            VideoPlayer.EventManager<VideoLANPlayer> eventManager = VideoLANPlayer.this.EV;
            synchronized (eventManager) {
                mediaPlayer.audio().setVolume(VideoLANPlayer.this.volume);
            }
            VideoLANPlayer.this.EV.callMediaPauseEvent(VideoLANPlayer.this, new MediaPauseEvent.EventData(VideoLANPlayer.this.player.mediaPlayer().status().length()));
        }

        @Override
        public void stopped(MediaPlayer mediaPlayer) {
            VideoLANPlayer.this.checkIfCurrentThreadHaveClassLoader();
            long current = RuntimeUtil.isWindows() ? mediaPlayer.status().length() : VideoLANPlayer.this.duration;
            VideoLANPlayer.this.EV.callMediaStoppedEvent(VideoLANPlayer.this, new MediaStoppedEvent.EventData(current));
        }

        @Override
        public void forward(MediaPlayer mediaPlayer) {
            VideoLANPlayer.this.checkIfCurrentThreadHaveClassLoader();
        }

        @Override
        public void backward(MediaPlayer mediaPlayer) {
            VideoLANPlayer.this.checkIfCurrentThreadHaveClassLoader();
        }

        @Override
        public void finished(MediaPlayer mediaPlayer) {
            VideoLANPlayer.this.checkIfCurrentThreadHaveClassLoader();
            ThreadUtil.trySimple(() -> VideoLANPlayer.this.EV.callMediaFinishEvent(VideoLANPlayer.this, new MediaFinishEvent.EventData(new URL(VideoLANPlayer.this.url))));
        }

        @Override
        public void timeChanged(MediaPlayer mediaPlayer, long newTime) {
            VideoLANPlayer.this.checkIfCurrentThreadHaveClassLoader();
        }

        @Override
        public void positionChanged(MediaPlayer mediaPlayer, float newPosition) {
            VideoLANPlayer.this.checkIfCurrentThreadHaveClassLoader();
        }

        @Override
        public void seekableChanged(MediaPlayer mediaPlayer, int newSeekable) {
            VideoLANPlayer.this.checkIfCurrentThreadHaveClassLoader();
        }

        @Override
        public void pausableChanged(MediaPlayer mediaPlayer, int newPausable) {
            VideoLANPlayer.this.checkIfCurrentThreadHaveClassLoader();
        }

        @Override
        public void titleChanged(MediaPlayer mediaPlayer, int newTitle) {
            VideoLANPlayer.this.checkIfCurrentThreadHaveClassLoader();
        }

        @Override
        public void snapshotTaken(MediaPlayer mediaPlayer, String filename) {
            VideoLANPlayer.this.checkIfCurrentThreadHaveClassLoader();
        }

        @Override
        public void lengthChanged(MediaPlayer mediaPlayer, long newLength) {
            VideoLANPlayer.this.checkIfCurrentThreadHaveClassLoader();
        }

        @Override
        public void videoOutput(MediaPlayer mediaPlayer, int newCount) {
            VideoLANPlayer.this.checkIfCurrentThreadHaveClassLoader();
        }

        @Override
        public void scrambledChanged(MediaPlayer mediaPlayer, int newScrambled) {
            VideoLANPlayer.this.checkIfCurrentThreadHaveClassLoader();
        }

        @Override
        public void elementaryStreamAdded(MediaPlayer mediaPlayer, TrackType type, int id) {
            VideoLANPlayer.this.checkIfCurrentThreadHaveClassLoader();
        }

        @Override
        public void elementaryStreamDeleted(MediaPlayer mediaPlayer, TrackType type, int id) {
            VideoLANPlayer.this.checkIfCurrentThreadHaveClassLoader();
        }

        @Override
        public void elementaryStreamSelected(MediaPlayer mediaPlayer, TrackType type, int id) {
            VideoLANPlayer.this.checkIfCurrentThreadHaveClassLoader();
        }

        @Override
        public void corked(MediaPlayer mediaPlayer, boolean corked) {
            VideoLANPlayer.this.checkIfCurrentThreadHaveClassLoader();
        }

        @Override
        public void muted(MediaPlayer mediaPlayer, boolean muted) {
            VideoLANPlayer.this.checkIfCurrentThreadHaveClassLoader();
        }

        @Override
        public void volumeChanged(MediaPlayer mediaPlayer, float volume) {
            VideoLANPlayer.this.checkIfCurrentThreadHaveClassLoader();
            VideoLANPlayer.this.EV.callMediaVolumeUpdate(VideoLANPlayer.this, new MediaVolumeUpdateEvent.EventData(VideoLANPlayer.this.getVolume(), (int)volume));
        }

        @Override
        public void audioDeviceChanged(MediaPlayer mediaPlayer, String audioDevice) {
            VideoLANPlayer.this.checkIfCurrentThreadHaveClassLoader();
        }

        @Override
        public void chapterChanged(MediaPlayer mediaPlayer, int newChapter) {
            VideoLANPlayer.this.checkIfCurrentThreadHaveClassLoader();
        }

        @Override
        public void error(MediaPlayer mediaPlayer) {
            VideoLANPlayer.this.checkIfCurrentThreadHaveClassLoader();
            VideoLANPlayer.this.EV.callPlayerExceptionEvent(VideoLANPlayer.this, new PlayerExceptionEvent.EventData(new RuntimeException("Something is wrong on VideoLanPlayer instance")));
        }

        @Override
        public void mediaPlayerReady(MediaPlayer mediaPlayer) {
            VideoLANPlayer.this.checkIfCurrentThreadHaveClassLoader();
            VideoLANPlayer.this.prepared.set(true);
            VideoLANPlayer.this.EV.callPlayerReadyEvent(VideoLANPlayer.this, new PlayerReadyEvent.EventData());
            mediaPlayer.submit(() -> mediaPlayer.audio().setVolume(VideoLANPlayer.this.volume));
        }
    };

    @Deprecated(forRemoval=true)
    public CallbackMediaPlayerComponent getRaw() {
        return this.player;
    }

    public CallbackMediaPlayerComponent raw() {
        return this.player;
    }

    public VideoLANPlayer(@Nullable MediaPlayerFactory factory, @Nullable RenderCallback renderCallback, @Nullable BufferFormatCallback bufferFormatCallback) {
        if (factory == null) {
            factory = VideoLAN.factory();
        }
        if (WaterMediaAPI.isVLCReady()) {
            this.player = this.init(factory, renderCallback, bufferFormatCallback);
        } else {
            WaterMedia.LOGGER.error(IT, "Failed to create CallbackMediaPlayerComponent because VLC is not loaded");
        }
        WaterMedia.LOGGER.warn(IT, "Created a unsafe instance of a VideoLANPlayer");
        WaterMedia.LOGGER.warn(IT, "Please contact with the dependent mod developer");
        WaterMedia.LOGGER.warn(IT, "Things may not work well");
    }

    @Override
    public void start(@NotNull CharSequence url) {
        this.start(url, new String[0]);
    }

    public synchronized void start(CharSequence url, String[] vlcArgs) {
        if (this.player == null) {
            return;
        }
        ThreadUtil.threadTry(() -> {
            VideoLANPlayer videoLANPlayer = this;
            synchronized (videoLANPlayer) {
                if (this.player == null) {
                    return;
                }
                this.safe = false;
                super.start(url.toString());
                this.player.mediaPlayer().media().start(this.url, vlcArgs);
                this.safe = true;
            }
        }, null, null);
    }

    @Override
    public void prepare(@NotNull CharSequence url) {
        this.prepare(url, new String[0]);
    }

    public void prepare(@NotNull CharSequence url, String[] vlcArgs) {
        if (this.player == null) {
            return;
        }
        ThreadUtil.threadTry(() -> {
            VideoLANPlayer videoLANPlayer = this;
            synchronized (videoLANPlayer) {
                if (this.player == null) {
                    return;
                }
                this.safe = false;
                super.start(url.toString());
                this.player.mediaPlayer().media().prepare(this.url, vlcArgs);
                this.safe = true;
            }
        }, null, null);
    }

    @Override
    public void play() {
        if (this.player == null) {
            return;
        }
        this.player.mediaPlayer().controls().play();
    }

    @Override
    public void pause() {
        if (this.player == null) {
            return;
        }
        if (this.player.mediaPlayer().status().canPause()) {
            this.player.mediaPlayer().controls().pause();
        }
    }

    @Override
    public void setPauseMode(boolean isPaused) {
        if (this.player == null) {
            return;
        }
        this.player.mediaPlayer().controls().setPause(isPaused);
    }

    @Override
    public void stop() {
        if (this.player == null) {
            return;
        }
        this.player.mediaPlayer().controls().stop();
    }

    @Override
    public void seekTo(long time) {
        if (this.player == null) {
            return;
        }
        this.EV.callMediaTimeChangedEvent(this, new MediaTimeChangedEvent.EventData(this.getTime(), time));
        this.player.mediaPlayer().controls().setTime(time);
    }

    @Override
    public void seekFastTo(long ticks) {
        if (this.player == null) {
            return;
        }
        this.player.mediaPlayer().controls().setTime(ticks);
    }

    @Override
    public void seekGameTicksTo(int ticks) {
        if (this.player == null) {
            return;
        }
        long time = WaterMediaAPI.gameTicksToMs(ticks);
        this.EV.callMediaTimeChangedEvent(this, new MediaTimeChangedEvent.EventData(this.getTime(), time));
        this.player.mediaPlayer().controls().setTime(time);
    }

    @Override
    public void seekGameTickFastTo(int ticks) {
        if (this.player == null) {
            return;
        }
        this.player.mediaPlayer().controls().setTime(WaterMediaAPI.gameTicksToMs(ticks));
    }

    @Override
    public void setRepeatMode(boolean repeatMode) {
        if (this.player == null) {
            return;
        }
        this.player.mediaPlayer().controls().setRepeat(repeatMode);
    }

    @Override
    public boolean isValid() {
        if (this.player == null) {
            return false;
        }
        if (RuntimeUtil.isNix()) {
            if (!(this.getRawPlayerState().equals((Object)State.ENDED) || this.getRawPlayerState().equals((Object)State.ERROR) || this.getRawPlayerState().equals((Object)State.OPENING) || this.getRawPlayerState().equals((Object)State.NOTHING_SPECIAL))) {
                return this.player.mediaPlayer().media().isValid();
            }
        } else {
            return this.player.mediaPlayer().media().isValid();
        }
        return false;
    }

    @Override
    public boolean isSafeToUse() {
        return this.safe;
    }

    @Override
    public Dimension getDimensions() {
        if (this.player == null) {
            return null;
        }
        return this.player.mediaPlayer().video().videoDimension();
    }

    @Override
    public boolean isPlaying() {
        if (this.player == null) {
            return false;
        }
        return this.getRawPlayerState().equals((Object)State.PLAYING);
    }

    @Override
    public boolean getRepeatMode() {
        if (this.player == null) {
            return false;
        }
        return this.player.mediaPlayer().controls().getRepeat();
    }

    @Override
    public void fastFoward() {
        if (this.player == null) {
            return;
        }
        this.player.mediaPlayer().controls().skipTime(5L);
    }

    @Override
    public void setSpeed(float rate) {
        if (this.player == null) {
            return;
        }
        this.player.mediaPlayer().controls().setRate(rate);
    }

    @Override
    public void rewind() {
        if (this.player == null) {
            return;
        }
        this.player.mediaPlayer().controls().skipTime(-5L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setVolume(int volume) {
        VideoPlayer.EventManager<VideoLANPlayer> eventManager = this.EV;
        synchronized (eventManager) {
            this.volume = volume;
        }
        if (RuntimeUtil.isNix() && !this.isValid()) {
            return;
        }
        if (this.player == null) {
            return;
        }
        this.player.mediaPlayer().audio().setVolume(this.volume);
        if (this.volume == 0 && !this.player.mediaPlayer().audio().isMute()) {
            this.player.mediaPlayer().audio().setMute(true);
        } else if (this.volume > 0 && this.player.mediaPlayer().audio().isMute()) {
            this.player.mediaPlayer().audio().setMute(false);
        }
    }

    @Override
    public int getVolume() {
        if (RuntimeUtil.isNix() && !this.isValid()) {
            return this.volume;
        }
        if (this.player == null) {
            return this.volume;
        }
        return this.player.mediaPlayer().audio().volume();
    }

    @Override
    public void mute() {
        if (this.player == null) {
            return;
        }
        this.player.mediaPlayer().audio().mute();
    }

    @Override
    public void unmute() {
        if (this.player == null) {
            return;
        }
        this.player.mediaPlayer().audio().setMute(false);
    }

    @Override
    public void setMuteMode(boolean mode) {
        if (this.player == null) {
            return;
        }
        this.player.mediaPlayer().audio().setMute(mode);
    }

    @Override
    public boolean isStream() {
        if (this.player == null) {
            return false;
        }
        InfoApi mediaInfo = this.player.mediaPlayer().media().info();
        return mediaInfo != null && (mediaInfo.type().equals((Object)MediaType.STREAM) || mediaInfo.mrl().endsWith(".m3u") || mediaInfo.mrl().endsWith(".m3u8"));
    }

    public State getRawPlayerState() {
        if (this.player == null) {
            return State.NOTHING_SPECIAL;
        }
        return this.player.mediaPlayer().status().state();
    }

    @Override
    public long getDuration() {
        if (this.player == null) {
            return 0L;
        }
        if (!this.isValid() || RuntimeUtil.isNix() && this.getRawPlayerState().equals((Object)State.STOPPED)) {
            return 0L;
        }
        this.duration = this.player.mediaPlayer().status().length();
        return this.duration;
    }

    @Override
    public int getGameTickDuration() {
        if (this.player == null) {
            return 0;
        }
        return WaterMediaAPI.msToGameTicks(this.player.mediaPlayer().status().length());
    }

    @Deprecated
    public long getMediaInfoDuration() {
        if (this.player == null) {
            return 0L;
        }
        InfoApi info = this.player.mediaPlayer().media().info();
        if (info != null) {
            return info.duration();
        }
        return 0L;
    }

    @Deprecated
    public int getGameTickMediaInfoDuration() {
        if (this.player == null) {
            return 0;
        }
        InfoApi info = this.player.mediaPlayer().media().info();
        if (info != null) {
            return WaterMediaAPI.msToGameTicks(info.duration());
        }
        return 0;
    }

    @Override
    public long getTime() {
        if (this.player == null) {
            return 0L;
        }
        return this.player.mediaPlayer().status().time();
    }

    @Override
    public int getGameTickTime() {
        if (this.player == null) {
            return 0;
        }
        return WaterMediaAPI.msToGameTicks(this.player.mediaPlayer().status().time());
    }

    @Override
    public boolean isSeekable() {
        if (this.player == null) {
            return false;
        }
        return this.player.mediaPlayer().status().isSeekable();
    }

    @Override
    public void release() {
        if (this.player == null) {
            return;
        }
        this.stop();
        CallbackMediaPlayerComponent tempPlayer = this.player;
        this.player = null;
        EX.execute(() -> {
            VideoLANPlayer videoLANPlayer = this;
            synchronized (videoLANPlayer) {
                this.safe = false;
                if (tempPlayer == null) {
                    return;
                }
                tempPlayer.mediaPlayer().release();
                try {
                    Thread.sleep(250L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.eventListeners.corked(null, false);
            }
        });
    }

    private void checkIfCurrentThreadHaveClassLoader() {
        if (Thread.currentThread().getContextClassLoader() == null) {
            Thread.currentThread().setContextClassLoader(THREAD.getContextClassLoader());
        }
    }

    private CallbackMediaPlayerComponent init(MediaPlayerFactory factory, RenderCallback renderCallback, BufferFormatCallback bufferFormatCallback) {
        CallbackMediaPlayerComponent component = new CallbackMediaPlayerComponent(factory, null, null, false, renderCallback, bufferFormatCallback, null);
        component.mediaPlayer().events().addMediaPlayerEventListener(this.eventListeners);
        return component;
    }
}

