/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.core.videolan;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Date;
import java.util.zip.GZIPOutputStream;
import me.lib720.caprica.vlcj.factory.MediaPlayerFactory;
import me.lib720.caprica.vlcj.factory.discovery.provider.CustomDirectoryProvider;
import me.srrapero720.watermedia.Util;
import me.srrapero720.watermedia.WaterMedia;
import me.srrapero720.watermedia.api.WaterMediaAPI;
import me.srrapero720.watermedia.api.external.ThreadUtil;
import me.srrapero720.watermedia.core.videolan.VLCBinaries;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class VideoLAN {
    public static final Marker IT = MarkerFactory.getMarker((String)"VideoLAN");
    private static MediaPlayerFactory FACTORY;

    public static MediaPlayerFactory factory() {
        return FACTORY;
    }

    public static boolean init(Path workingDir) {
        if (FACTORY != null) {
            WaterMedia.LOGGER.error(IT, "Rejected attempt to reload VideoLAN");
            return true;
        }
        Path logs = workingDir.resolve("logs/latest.log");
        Path path = workingDir.resolve("vlc/");
        if (!Files.exists(logs.toAbsolutePath(), new LinkOption[0])) {
            if (logs.getParent().toFile().mkdirs()) {
                WaterMedia.LOGGER.info(IT, "Logger dir created");
            }
        } else {
            VideoLAN.compressAndDeleteLogFile(logs);
        }
        CustomDirectoryProvider.init(path);
        VLCBinaries.init(path);
        if (Util.ARCH.wrapped) {
            boolean fresh = false;
            if (!VLCBinaries.resVersion().equals(VLCBinaries.installedVersion())) {
                WaterMedia.LOGGER.warn(IT, "Running VLC installation cleanup");
                VLCBinaries.cleanup();
                WaterMedia.LOGGER.warn(IT, "Running VLC extraction");
                VLCBinaries.extractAll();
                try {
                    Path config = path.resolve("version.cfg");
                    if (!Files.exists(config.getParent(), new LinkOption[0])) {
                        Files.createDirectories(config.getParent(), new FileAttribute[0]);
                    }
                    Files.writeString(config, (CharSequence)VLCBinaries.resVersion(), new OpenOption[0]);
                }
                catch (Exception e2) {
                    WaterMedia.LOGGER.error(IT, "Could not write configuration file", (Throwable)e2);
                }
                fresh = true;
            } else {
                WaterMedia.LOGGER.warn(IT, "Detected WaterMedia's VLC installation, skipping extract");
            }
            if (!fresh) {
                WaterMedia.LOGGER.info(IT, "Running integrity check");
                for (VLCBinaries binary : VLCBinaries.values()) {
                    binary.checkIntegrity();
                }
            }
        } else {
            WaterMedia.LOGGER.error(IT, "###########################  VLC NOT PRE-INSTALLED  ###################################");
            WaterMedia.LOGGER.error(IT, "WATERMeDIA doesn't include VLC binaries for your operative system / system architecture");
            WaterMedia.LOGGER.error(IT, "You had to install VLC manually on https://www.videolan.org/ - More info ask to SrRapero720");
            WaterMedia.LOGGER.error(IT, "###########################  VLC NOT PRE-INSTALLED  ###################################");
        }
        FACTORY = ThreadUtil.tryAndReturnNull(defaultVar -> {
            String[] args = Util.getArrayStringFromRes("vlc/command-line.json");
            for (int i = 0; i < args.length; ++i) {
                args[i] = args[i].replace("%logfile%", logs.toAbsolutePath().toString());
            }
            return WaterMediaAPI.createVLCFactory(args);
        }, e -> WaterMedia.LOGGER.error(IT, "Failed to load VLC", (Throwable)e));
        return FACTORY != null;
    }

    private static void compressAndDeleteLogFile(Path logFilePath) {
        File logFile = logFilePath.toFile();
        if (!logFile.exists() || !logFile.isFile()) {
            return;
        }
        String date = new Date(System.currentTimeMillis()).toLocalDate().toString();
        String compressedFilePath = logFile.getParent() + "/" + date + ".log.gz";
        int count = 0;
        while (new File(compressedFilePath).exists()) {
            compressedFilePath = logFile.getParent() + "/" + date + "-" + ++count + ".log.gz";
        }
        try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(new FileOutputStream(compressedFilePath));
             FileInputStream inputStream = new FileInputStream(logFile);){
            int bytesRead;
            byte[] buffer = new byte[4096];
            while ((bytesRead = ((InputStream)inputStream).read(buffer)) != -1) {
                gzipOutputStream.write(buffer, 0, bytesRead);
            }
        }
        catch (Exception e) {
            WaterMedia.LOGGER.error(IT, "Failed to compress {}", (Object)logFilePath, (Object)e);
        }
        logFile.delete();
    }
}

