/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.level;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.prediction.BlockStatePredictionHandler;
import net.minecraft.client.multiplayer.prediction.PredictiveAction;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundInteractPacket;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.network.protocol.game.ServerboundPickItemPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.network.protocol.game.ServerboundUseItemOnPacket;
import net.minecraft.network.protocol.game.ServerboundUseItemPacket;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.mutable.MutableObject;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.client.level.ClientLevelExtender;
import team.creative.littletiles.common.level.handler.LevelHandler;
import team.creative.littletiles.mixin.client.MultiPlayerGameModeAccessor;

public class LittleInteractionHandlerClient
extends LevelHandler {
    private static Minecraft mc = Minecraft.m_91087_();
    private Level destroyLevel;
    private BlockPos destroyBlockPos = new BlockPos(-1, -1, -1);
    private ItemStack destroyingItem = ItemStack.f_41583_;
    private float destroyProgress;
    private float destroyTicks;
    private boolean isDestroying;

    public LittleInteractionHandlerClient(Level level) {
        super(level);
    }

    public Player getPlayer() {
        return LittleInteractionHandlerClient.mc.f_91074_;
    }

    public GameType getGameMode() {
        return LittleInteractionHandlerClient.mc.f_91072_.m_105295_();
    }

    public ClientPacketListener getVanillaConnection() {
        return ((MultiPlayerGameModeAccessor)LittleInteractionHandlerClient.mc.f_91072_).getConnection();
    }

    private void ensureHasSentCarriedItem() {
        ((MultiPlayerGameModeAccessor)LittleInteractionHandlerClient.mc.f_91072_).callEnsureHasSentCarriedItem();
    }

    public boolean destroyBlock(Level level, BlockPos pos) {
        Player player = this.getPlayer();
        if (player.m_21205_().onBlockStartBreak(pos, player)) {
            return false;
        }
        if (player.m_36187_(level, pos, this.getGameMode())) {
            return false;
        }
        BlockState blockstate = level.m_8055_(pos);
        if (!player.m_21205_().m_41720_().m_6777_(blockstate, level, pos, player)) {
            return false;
        }
        Block block = blockstate.m_60734_();
        if (block instanceof GameMasterBlock && !player.m_36337_()) {
            return false;
        }
        if (blockstate.m_60795_()) {
            return false;
        }
        FluidState fluidstate = level.m_6425_(pos);
        boolean flag = blockstate.onDestroyedByPlayer(level, pos, player, false, fluidstate);
        if (flag) {
            block.m_6786_((LevelAccessor)level, pos, blockstate);
        }
        return flag;
    }

    public boolean startDestroyBlock(Level level, BlockPos pos, Direction direction) {
        Player player = this.getPlayer();
        if (player.m_36187_(level, pos, this.getGameMode())) {
            return false;
        }
        if (!level.m_6857_().m_61937_(pos)) {
            return false;
        }
        if (this.getGameMode().m_46408_()) {
            BlockState blockstate = level.m_8055_(pos);
            if (level instanceof ClientLevel) {
                ClientLevel client = (ClientLevel)level;
                mc.m_91301_().m_120581_(client, pos, blockstate, 1.0f);
            }
            this.startPrediction(level, sequence -> {
                if (!ForgeHooks.onLeftClickBlock((Player)player, (BlockPos)pos, (Direction)direction).isCanceled()) {
                    this.destroyBlock(level, pos);
                }
                return new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK, pos, direction, sequence);
            });
            ((MultiPlayerGameModeAccessor)LittleInteractionHandlerClient.mc.f_91072_).setDestroyDelay(5);
            return true;
        }
        if (!this.isDestroying || !this.sameDestroyTarget(level, pos)) {
            if (this.isDestroying) {
                LittleTilesClient.PLAYER_CONNECTION.send(level, (Packet)new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK, this.destroyBlockPos, direction));
            }
            PlayerInteractEvent.LeftClickBlock event = ForgeHooks.onLeftClickBlock((Player)player, (BlockPos)pos, (Direction)direction);
            BlockState blockstate1 = level.m_8055_(pos);
            if (level instanceof ClientLevel) {
                ClientLevel client = (ClientLevel)level;
                mc.m_91301_().m_120581_(client, pos, blockstate1, 0.0f);
            }
            this.startPrediction(level, sequence -> {
                boolean flag;
                boolean bl = flag = !blockstate1.m_60795_();
                if (flag && this.destroyProgress == 0.0f && event.getUseBlock() != Event.Result.DENY) {
                    blockstate1.m_60686_(level, pos, player);
                }
                ServerboundPlayerActionPacket packet = new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK, pos, direction, sequence);
                if (event.getUseItem() == Event.Result.DENY) {
                    return packet;
                }
                if (flag && blockstate1.m_60625_(player, (BlockGetter)level, pos) >= 1.0f) {
                    this.destroyBlock(level, pos);
                } else {
                    this.isDestroying = true;
                    this.destroyLevel = level;
                    this.destroyBlockPos = pos;
                    this.destroyingItem = player.m_21205_();
                    this.destroyProgress = 0.0f;
                    this.destroyTicks = 0.0f;
                    level.m_6801_(player.m_19879_(), this.destroyBlockPos, (int)(this.destroyProgress * 10.0f) - 1);
                }
                return packet;
            });
        }
        return true;
    }

    public void stopDestroyBlock() {
        if (this.isDestroying) {
            Player player = this.getPlayer();
            BlockState blockstate = this.destroyLevel.m_8055_(this.destroyBlockPos);
            Level level = this.destroyLevel;
            if (level instanceof ClientLevel) {
                ClientLevel client = (ClientLevel)level;
                mc.m_91301_().m_120581_(client, this.destroyBlockPos, blockstate, -1.0f);
            }
            LittleTilesClient.PLAYER_CONNECTION.send(this.destroyLevel, (Packet)new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK, this.destroyBlockPos, Direction.DOWN));
            this.isDestroying = false;
            this.destroyLevel.m_6801_(player.m_19879_(), this.destroyBlockPos, -1);
            this.destroyLevel = null;
            this.destroyProgress = 0.0f;
            player.m_36334_();
        }
    }

    public boolean continueDestroyBlock(Level level, BlockPos pos, Direction direction) {
        this.ensureHasSentCarriedItem();
        if (((MultiPlayerGameModeAccessor)LittleInteractionHandlerClient.mc.f_91072_).getDestroyDelay() > 0) {
            ((MultiPlayerGameModeAccessor)LittleInteractionHandlerClient.mc.f_91072_).setDestroyDelay(((MultiPlayerGameModeAccessor)LittleInteractionHandlerClient.mc.f_91072_).getDestroyDelay() - 1);
            return true;
        }
        Player player = this.getPlayer();
        if (this.getGameMode().m_46408_() && level.m_6857_().m_61937_(pos)) {
            ((MultiPlayerGameModeAccessor)LittleInteractionHandlerClient.mc.f_91072_).setDestroyDelay(5);
            BlockState blockstate1 = level.m_8055_(pos);
            if (level instanceof ClientLevel) {
                ClientLevel client = (ClientLevel)level;
                mc.m_91301_().m_120581_(client, pos, blockstate1, 1.0f);
            }
            this.startPrediction(level, sequence -> {
                if (!ForgeHooks.onLeftClickBlock((Player)player, (BlockPos)pos, (Direction)direction).isCanceled()) {
                    this.destroyBlock(level, pos);
                }
                return new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK, pos, direction, sequence);
            });
            return true;
        }
        if (this.sameDestroyTarget(level, pos)) {
            BlockState blockstate = level.m_8055_(pos);
            if (blockstate.m_60795_()) {
                this.isDestroying = false;
                this.destroyLevel = null;
                return false;
            }
            this.destroyProgress += blockstate.m_60625_(player, (BlockGetter)level, pos);
            if (this.destroyTicks % 4.0f == 0.0f) {
                SoundType soundtype = blockstate.getSoundType((LevelReader)level, pos, (Entity)player);
                mc.m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance(soundtype.m_56778_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 8.0f, soundtype.m_56774_() * 0.5f, SoundInstance.m_235150_(), pos));
            }
            this.destroyTicks += 1.0f;
            if (level instanceof ClientLevel) {
                ClientLevel client = (ClientLevel)level;
                mc.m_91301_().m_120581_(client, pos, blockstate, Mth.m_14036_((float)this.destroyProgress, (float)0.0f, (float)1.0f));
            }
            if (ForgeHooks.onLeftClickBlock((Player)player, (BlockPos)pos, (Direction)direction).getUseItem() == Event.Result.DENY) {
                return true;
            }
            if (this.destroyProgress >= 1.0f) {
                this.isDestroying = false;
                this.destroyLevel = null;
                this.startPrediction(level, sequence -> {
                    this.destroyBlock(level, pos);
                    return new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK, pos, direction, sequence);
                });
                this.destroyProgress = 0.0f;
                this.destroyTicks = 0.0f;
                ((MultiPlayerGameModeAccessor)LittleInteractionHandlerClient.mc.f_91072_).setDestroyDelay(5);
            }
            level.m_6801_(player.m_19879_(), this.destroyBlockPos, (int)(this.destroyProgress * 10.0f) - 1);
            return true;
        }
        return this.startDestroyBlock(level, pos, direction);
    }

    private void startPrediction(Level level, PredictiveAction action) {
        try (BlockStatePredictionHandler blockstatepredictionhandler = ((ClientLevelExtender)level).blockStatePredictionHandler().m_233855_();){
            int i = blockstatepredictionhandler.m_233871_();
            Packet packet = action.m_233885_(i);
            LittleTilesClient.PLAYER_CONNECTION.send(level, packet);
        }
    }

    public float getPickRange() {
        return (float)this.getPlayer().getReachDistance();
    }

    private boolean sameDestroyTarget(Level level, BlockPos pos) {
        boolean flag;
        if (level != this.destroyLevel) {
            return false;
        }
        ItemStack itemstack = this.getPlayer().m_21205_();
        boolean bl = flag = this.destroyingItem.m_41619_() && itemstack.m_41619_();
        if (!this.destroyingItem.m_41619_() && !itemstack.m_41619_()) {
            flag = !this.destroyingItem.shouldCauseBlockBreakReset(itemstack);
        }
        return pos.equals((Object)this.destroyBlockPos) && flag;
    }

    public InteractionResult useItemOn(Level level, LocalPlayer player, InteractionHand hand, BlockHitResult result) {
        this.ensureHasSentCarriedItem();
        if (!level.m_6857_().m_61937_(result.m_82425_())) {
            return InteractionResult.FAIL;
        }
        MutableObject mutableobject = new MutableObject();
        this.startPrediction(level, sequence -> {
            mutableobject.setValue((Object)this.performUseItemOn(level, player, hand, result));
            return new ServerboundUseItemOnPacket(hand, result, sequence);
        });
        return (InteractionResult)mutableobject.getValue();
    }

    private InteractionResult performUseItemOn(Level level, LocalPlayer player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult interactionresult;
        InteractionResult result;
        BlockPos blockpos = hit.m_82425_();
        ItemStack itemstack = player.m_21120_(hand);
        PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((Player)player, (InteractionHand)hand, (BlockPos)blockpos, (BlockHitResult)hit);
        if (event.isCanceled()) {
            return event.getCancellationResult();
        }
        if (this.getGameMode() == GameType.SPECTATOR) {
            return InteractionResult.SUCCESS;
        }
        UseOnContext useoncontext = new UseOnContext(level, (Player)player, hand, itemstack, hit);
        if (event.getUseItem() != Event.Result.DENY && (result = itemstack.onItemUseFirst(useoncontext)) != InteractionResult.PASS) {
            return result;
        }
        boolean flag = !player.m_21205_().doesSneakBypassUse((LevelReader)player.m_9236_(), blockpos, (Player)player) || !player.m_21206_().doesSneakBypassUse((LevelReader)player.m_9236_(), blockpos, (Player)player);
        boolean flag1 = player.m_36341_() && flag;
        BlockState blockstate = level.m_8055_(blockpos);
        if (!this.getVanillaConnection().m_246351_(blockstate.m_60734_().m_245183_())) {
            return InteractionResult.FAIL;
        }
        if ((event.getUseBlock() == Event.Result.ALLOW || event.getUseBlock() != Event.Result.DENY && !flag1) && (interactionresult = blockstate.m_60664_(level, (Player)player, hand, hit)).m_19077_()) {
            return interactionresult;
        }
        if (event.getUseItem() == Event.Result.DENY) {
            return InteractionResult.PASS;
        }
        if (event.getUseItem() == Event.Result.ALLOW || !itemstack.m_41619_() && !player.m_36335_().m_41519_(itemstack.m_41720_())) {
            if (this.getGameMode().m_46408_()) {
                int i = itemstack.m_41613_();
                InteractionResult interactionresult1 = itemstack.m_41661_(useoncontext);
                itemstack.m_41764_(i);
                return interactionresult1;
            }
            return itemstack.m_41661_(useoncontext);
        }
        return InteractionResult.PASS;
    }

    public InteractionResult useItem(Level level, Player player, InteractionHand hand) {
        if (this.getGameMode() == GameType.SPECTATOR) {
            return InteractionResult.PASS;
        }
        this.ensureHasSentCarriedItem();
        this.getVanillaConnection().m_104955_((Packet)new ServerboundMovePlayerPacket.PosRot(player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_146908_(), player.m_146909_(), player.m_20096_()));
        MutableObject mutableobject = new MutableObject();
        this.startPrediction(level, sequence -> {
            ServerboundUseItemPacket serverbounduseitempacket = new ServerboundUseItemPacket(hand, sequence);
            ItemStack itemstack = player.m_21120_(hand);
            if (player.m_36335_().m_41519_(itemstack.m_41720_())) {
                mutableobject.setValue((Object)InteractionResult.PASS);
                return serverbounduseitempacket;
            }
            InteractionResult cancelResult = ForgeHooks.onItemRightClick((Player)player, (InteractionHand)hand);
            if (cancelResult != null) {
                mutableobject.setValue((Object)cancelResult);
                return serverbounduseitempacket;
            }
            InteractionResultHolder interactionresultholder = itemstack.m_41682_(level, player, hand);
            ItemStack itemstack1 = (ItemStack)interactionresultholder.m_19095_();
            if (itemstack1 != itemstack) {
                player.m_21008_(hand, itemstack1);
                if (itemstack1.m_41619_()) {
                    ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)itemstack, (InteractionHand)hand);
                }
            }
            mutableobject.setValue((Object)interactionresultholder.m_19089_());
            return serverbounduseitempacket;
        });
        return (InteractionResult)mutableobject.getValue();
    }

    public void attack(Level level, Player player, Entity entity) {
        this.ensureHasSentCarriedItem();
        LittleTilesClient.PLAYER_CONNECTION.send(level, (Packet)ServerboundInteractPacket.m_179605_((Entity)entity, (boolean)player.m_6144_()));
        if (this.getGameMode() != GameType.SPECTATOR) {
            player.m_5706_(entity);
            player.m_36334_();
        }
    }

    public InteractionResult interact(Level level, Player player, Entity entity, InteractionHand hand) {
        this.ensureHasSentCarriedItem();
        LittleTilesClient.PLAYER_CONNECTION.send(level, (Packet)ServerboundInteractPacket.m_179608_((Entity)entity, (boolean)player.m_6144_(), (InteractionHand)hand));
        return this.getGameMode() == GameType.SPECTATOR ? InteractionResult.PASS : player.m_36157_(entity, hand);
    }

    public InteractionResult interactAt(Level level, Player player, Entity entity, EntityHitResult hit, InteractionHand hand) {
        this.ensureHasSentCarriedItem();
        Vec3 vec3 = hit.m_82450_().m_82492_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        LittleTilesClient.PLAYER_CONNECTION.send(level, (Packet)ServerboundInteractPacket.m_179612_((Entity)entity, (boolean)player.m_6144_(), (InteractionHand)hand, (Vec3)vec3));
        if (this.getGameMode() == GameType.SPECTATOR) {
            return InteractionResult.PASS;
        }
        InteractionResult cancelResult = ForgeHooks.onInteractEntityAt((Player)player, (Entity)entity, (HitResult)hit, (InteractionHand)hand);
        if (cancelResult != null) {
            return cancelResult;
        }
        return this.getGameMode() == GameType.SPECTATOR ? InteractionResult.PASS : entity.m_7111_(player, vec3, hand);
    }

    public void releaseUsingItem(Level level, Player player) {
        this.ensureHasSentCarriedItem();
        LittleTilesClient.PLAYER_CONNECTION.send(level, (Packet)new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.RELEASE_USE_ITEM, BlockPos.f_121853_, Direction.DOWN));
        player.m_21253_();
    }

    public boolean isDestroying() {
        return this.isDestroying;
    }

    public void handlePickItem(int slot) {
        this.getVanillaConnection().m_104955_((Packet)new ServerboundPickItemPacket(slot));
    }
}

