/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.block;

import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import team.creative.littletiles.api.common.block.ILittleMCBlock;
import team.creative.littletiles.api.common.block.LittleBlock;

public class LittleBlockClientRegistry {
    private static final ChunkRenderTypeSet SOLID = ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110451_()});
    private static final HashMap<LittleBlock, ChunkRenderTypeSet> CACHED_LAYERS = new HashMap();

    public static boolean canRenderInLayer(LittleBlock block, RenderType layer) {
        ChunkRenderTypeSet layers = CACHED_LAYERS.get(block);
        if (layers == null) {
            if (block.shouldUseStateForRenderType()) {
                Minecraft.m_91087_().m_18709_(() -> CACHED_LAYERS.put(block, Minecraft.m_91087_().m_91289_().m_110910_(block.getState()).getRenderTypes(block.getState(), ILittleMCBlock.RANDOM, ModelData.EMPTY)));
            } else {
                Minecraft.m_91087_().m_18709_(() -> CACHED_LAYERS.put(block, SOLID));
            }
            layers = CACHED_LAYERS.get(block);
        }
        return layers.contains(layer);
    }

    public static void clearCache() {
        CACHED_LAYERS.clear();
    }
}

