/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.cache.buffer;

import java.nio.ByteBuffer;
import team.creative.littletiles.client.render.cache.buffer.BufferHolder;

public class UploadableBufferHolder
implements BufferHolder {
    public int index;
    private int length;
    private int vertexCount;
    private ByteBuffer byteBuffer;
    private boolean invalid;
    private final int[] indexes;
    private int indexCount;

    public UploadableBufferHolder(ByteBuffer buffer, int index, int length, int count, int[] indexes) {
        this.byteBuffer = buffer;
        this.index = index;
        this.length = length;
        this.vertexCount = count;
        this.indexes = indexes;
        this.indexCount = indexes != null ? indexes.length / 2 : 0;
    }

    public void uploaded(boolean doNotErase) {
        if (!doNotErase) {
            this.byteBuffer = null;
        }
    }

    public void downloaded(ByteBuffer buffer) {
        this.byteBuffer = buffer;
        this.index = -1;
    }

    public boolean isAvailable() {
        return this.byteBuffer != null;
    }

    @Override
    public ByteBuffer byteBuffer() {
        return this.byteBuffer;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public int vertexCount() {
        return this.vertexCount;
    }

    @Override
    public int[] indexes() {
        return this.indexes;
    }

    @Override
    public int indexCount() {
        return this.indexCount;
    }

    @Override
    public void removeEntry(int length, int vertexCount) {
        this.length -= length;
        this.vertexCount -= vertexCount;
        --this.indexCount;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public void invalidate() {
        this.invalid = true;
    }
}

