/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.cache.build;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.lighting.QuadLighter;
import org.apache.commons.lang3.ArrayUtils;
import team.creative.creativecore.client.render.model.CreativeQuadLighter;
import team.creative.creativecore.common.level.LevelAccesorFake;
import team.creative.creativecore.common.mod.OptifineHelper;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.type.list.IndexedCollector;
import team.creative.creativecore.common.util.type.list.SingletonList;
import team.creative.creativecore.mixin.BufferBuilderAccessor;
import team.creative.creativecore.mixin.ForgeModelBlockRendererAccessor;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.api.client.IFakeRenderingBlock;
import team.creative.littletiles.client.render.block.BERenderManager;
import team.creative.littletiles.client.render.cache.BlockBufferCache;
import team.creative.littletiles.client.render.cache.build.RenderingBlockContext;
import team.creative.littletiles.client.render.level.LittleChunkDispatcher;
import team.creative.littletiles.client.render.mc.RenderChunkExtender;
import team.creative.littletiles.client.render.overlay.LittleTilesProfilerOverlay;
import team.creative.littletiles.client.render.tile.LittleRenderBox;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.level.little.LittleSubLevel;

@OnlyIn(value=Dist.CLIENT)
public class RenderingThread
extends Thread {
    private static final String[] fakeLeveldMods = new String[]{"chisel"};
    public static List<RenderingThread> THREADS;
    public static final HashMap<RenderChunkExtender, Integer> CHUNKS;
    public static final Minecraft mc;
    private static final ConcurrentLinkedQueue<RenderingBlockContext> QUEUE;
    private final SingletonList<BakedQuad> bakedQuadWrapper = new SingletonList(null);
    private final LevelAccesorFake fakeAccess = new LevelAccesorFake();
    public boolean active = true;
    public BufferBuilder builder = null;

    public static synchronized void initThreads(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("count has to be at least equal or greater than one");
        }
        if (THREADS != null) {
            for (RenderingThread thread : THREADS) {
                if (thread == null) continue;
                thread.interrupt();
            }
            while (QUEUE.size() > 0) {
                RenderingThread.QUEUE.poll().be.render.resetRenderingState();
            }
        }
        THREADS = new ArrayList<RenderingThread>();
        for (int i = 0; i < count; ++i) {
            THREADS.add(new RenderingThread());
        }
    }

    public static synchronized void unload() {
        for (RenderingThread thread : THREADS) {
            if (thread == null) continue;
            thread.interrupt();
        }
        THREADS = null;
        QUEUE.clear();
        CHUNKS.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean queue(BETiles be, @Nullable RenderChunkExtender chunk) {
        if (THREADS == null) {
            RenderingThread.initThreads(LittleTiles.CONFIG.rendering.renderingThreadCount);
        }
        if (chunk == null) {
            chunk = be.render.getRenderChunk();
        }
        if (chunk == null) {
            System.out.println("Invalid tileentity with no rendering chunk! pos: " + be.m_58899_() + ", level: " + be.m_58904_());
            return false;
        }
        if (be.isRenderingEmpty()) {
            int index = be.render.startBuildingCache();
            be.render.boxCache.clear();
            BERenderManager bERenderManager = be.render;
            synchronized (bERenderManager) {
                be.render.getBufferCache().setEmpty();
            }
            if (!be.render.finishBuildingCache(index, LittleChunkDispatcher.currentRenderState, true)) {
                return RenderingThread.queue(be, chunk);
            }
            return false;
        }
        HashMap<RenderChunkExtender, Integer> hashMap = CHUNKS;
        synchronized (hashMap) {
            Integer count = CHUNKS.get(chunk);
            if (count == null) {
                count = 0;
            }
            CHUNKS.put(chunk, count + 1);
        }
        QUEUE.add(new RenderingBlockContext(be, chunk));
        return true;
    }

    public static int queueSize() {
        return QUEUE.size();
    }

    public RenderingThread() {
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (this.active) {
                ClientLevel level = RenderingThread.mc.f_91073_;
                long duration = 0L;
                RandomSource rand = RandomSource.m_216327_();
                PoseStack posestack = new PoseStack();
                if (level != null && !QUEUE.isEmpty()) {
                    RenderingBlockContext data = QUEUE.poll();
                    if (data == null) continue;
                    try {
                        if (LittleTilesProfilerOverlay.isActive()) {
                            duration = System.nanoTime();
                        }
                        data.checkRemoved();
                        data.index = data.be.render.startBuildingCache();
                        BlockPos pos = data.be.m_58899_();
                        data.checkLoaded();
                        data.beforeBuilding();
                        for (RenderType layer : RenderType.m_110506_()) {
                            IndexedCollector<LittleRenderBox> cubes = data.be.render.getRenderingBoxes(data, layer);
                            if (cubes == null) continue;
                            for (LittleRenderBox cube : cubes) {
                                if (!cube.doesNeedQuadUpdate) continue;
                                if (ArrayUtils.contains((Object[])fakeLeveldMods, (Object)cube.state.m_60734_().m_204297_().m_205785_().m_135782_().m_135827_())) {
                                    this.fakeAccess.set(data.be.m_58904_(), pos, cube.state);
                                    level = this.fakeAccess;
                                } else {
                                    level = data.be.m_58904_();
                                }
                                BlockState modelState = cube.state;
                                rand.m_188584_(modelState.m_60726_(pos));
                                BakedModel blockModel = OptifineHelper.getRenderModel((BakedModel)mc.m_91289_().m_110910_(modelState), (LevelAccessor)level, (BlockState)modelState, (BlockPos)pos);
                                BlockPos offset = cube.getOffset();
                                for (int h = 0; h < Facing.VALUES.length; ++h) {
                                    Facing facing = Facing.VALUES[h];
                                    if (cube.shouldRenderFace(facing)) {
                                        if (cube.getQuad(facing) != null) continue;
                                        cube.setQuad(facing, cube.getBakedQuad((LevelAccessor)level, pos, offset, modelState, blockModel, facing, layer, rand, true, -1));
                                        continue;
                                    }
                                    cube.setQuad(facing, null);
                                }
                                cube.doesNeedQuadUpdate = false;
                            }
                        }
                        data.clearQuadBuilding();
                        this.fakeAccess.set(null, null, null);
                        data.checkRemoved();
                        level = RenderingThread.mc.f_91073_;
                        int renderState = LittleChunkDispatcher.currentRenderState;
                        BlockBufferCache layerBuffer = data.be.render.getBufferCache();
                        VertexFormat format = DefaultVertexFormat.f_85811_;
                        try {
                            LittleSubLevel sub;
                            Level renderLevel = data.be.m_58904_();
                            while (renderLevel instanceof LittleSubLevel && !(sub = (LittleSubLevel)renderLevel).shouldUseLightingForRenderig()) {
                                renderLevel = sub.getParent();
                            }
                            ForgeModelBlockRendererAccessor renderer = (ForgeModelBlockRendererAccessor)mc.m_91289_().m_110937_();
                            boolean smooth = Minecraft.m_91086_() && data.state.getLightEmission((BlockGetter)data.be.m_58904_(), pos) == 0;
                            QuadLighter lighter = smooth ? (QuadLighter)renderer.getSmoothLighter().get() : (QuadLighter)renderer.getFlatLighter().get();
                            lighter.setup((BlockAndTintGetter)renderLevel, pos, data.state);
                            int overlay = OverlayTexture.f_118083_;
                            posestack.m_166856_();
                            data.chunk.prepareBlockTranslation(posestack, pos);
                            for (Map.Entry entry : data.be.render.boxCache.tuples()) {
                                RenderType layer = (RenderType)entry.getKey();
                                IndexedCollector cubes = (IndexedCollector)entry.getValue();
                                if (cubes == null || cubes.isEmpty()) {
                                    BERenderManager bERenderManager = data.be.render;
                                    synchronized (bERenderManager) {
                                        layerBuffer.set(layer, null, null);
                                        continue;
                                    }
                                }
                                if (this.builder == null) {
                                    this.builder = new BufferBuilder(131072);
                                }
                                this.builder.m_166779_(VertexFormat.Mode.QUADS, format);
                                IntArrayList indexes = new IntArrayList();
                                Iterator iterator = cubes.sectionIterator(x -> {
                                    indexes.add(x);
                                    indexes.add(((BufferBuilderAccessor)this.builder).getVertices() * format.m_86020_());
                                });
                                while (iterator.hasNext()) {
                                    LittleRenderBox cube = (LittleRenderBox)((Object)iterator.next());
                                    BlockState state = cube.state;
                                    ((CreativeQuadLighter)lighter).setState(state);
                                    ((CreativeQuadLighter)lighter).setCustomTint(cube.color);
                                    if (OptifineHelper.isShaders()) {
                                        if (state.m_60734_() instanceof IFakeRenderingBlock) {
                                            state = ((IFakeRenderingBlock)state.m_60734_()).getFakeState(state);
                                        }
                                        OptifineHelper.pushBuffer((BlockState)state, (BlockPos)pos, (LevelAccessor)data.be.m_58904_(), (BufferBuilder)this.builder);
                                    }
                                    for (int h = 0; h < Facing.VALUES.length; ++h) {
                                        Facing facing = Facing.VALUES[h];
                                        Object quadObject = cube.getQuad(facing);
                                        SingletonList<BakedQuad> quads = null;
                                        if (quadObject instanceof List) {
                                            quads = (SingletonList<BakedQuad>)quadObject;
                                        } else if (quadObject instanceof BakedQuad) {
                                            this.bakedQuadWrapper.setElement((Object)((BakedQuad)quadObject));
                                            quads = this.bakedQuadWrapper;
                                        }
                                        if (quads == null || quads.isEmpty()) continue;
                                        for (BakedQuad quad : quads) {
                                            lighter.process((VertexConsumer)this.builder, posestack.m_85850_(), quad, overlay);
                                        }
                                    }
                                    this.bakedQuadWrapper.setElement(null);
                                    if (OptifineHelper.isShaders()) {
                                        OptifineHelper.popBuffer((BufferBuilder)this.builder);
                                    }
                                    if (LittleTiles.CONFIG.rendering.useQuadCache) continue;
                                    cube.deleteQuadCache();
                                }
                                if (OptifineHelper.isShaders()) {
                                    OptifineHelper.calcNormalChunkLayer((BufferBuilder)this.builder);
                                }
                                BERenderManager bERenderManager = data.be.render;
                                synchronized (bERenderManager) {
                                    layerBuffer.set(layer, indexes.toIntArray(), this.builder.m_231175_());
                                }
                            }
                            ((CreativeQuadLighter)lighter).setCustomTint(-1);
                            lighter.reset();
                            if (!LittleTiles.CONFIG.rendering.useCubeCache) {
                                data.be.render.boxCache.clear();
                            }
                            if (!RenderingThread.finish(data, renderState, false)) {
                                QUEUE.add(data);
                            }
                            if (LittleTilesProfilerOverlay.isActive()) {
                                LittleTilesProfilerOverlay.finishBuildingCache(System.nanoTime() - duration);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            if (!RenderingThread.finish(data, -1, false)) {
                                QUEUE.add(data);
                            }
                        }
                    }
                    catch (RemovedBlockEntityException e) {
                        RenderingThread.finish(data, -1, true);
                    }
                    catch (Exception e) {
                        if (!(e instanceof RenderingException)) {
                            e.printStackTrace();
                        }
                    }
                    catch (OutOfMemoryError error) {
                        QUEUE.add(data);
                        error.printStackTrace();
                    }
                    data = null;
                } else if (level == null || QUEUE.isEmpty()) {
                    RenderingThread.sleep(1L);
                }
                if (!Thread.currentThread().isInterrupted()) continue;
                throw new InterruptedException();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean finish(RenderingBlockContext data, int renderState, boolean force) {
        if (!data.be.render.finishBuildingCache(data.index, renderState, force)) {
            return false;
        }
        boolean complete = false;
        HashMap<RenderChunkExtender, Integer> hashMap = CHUNKS;
        synchronized (hashMap) {
            Integer count = CHUNKS.get(data.chunk);
            if (count != null) {
                if (count <= 1) {
                    CHUNKS.remove(data.chunk);
                    complete = true;
                } else {
                    CHUNKS.put(data.chunk, count - 1);
                }
            }
        }
        if (complete) {
            ++LittleTilesProfilerOverlay.chunkUpdates;
            data.chunk.markReadyForUpdate(false);
        }
        return true;
    }

    static {
        CHUNKS = new HashMap();
        mc = Minecraft.m_91087_();
        QUEUE = new ConcurrentLinkedQueue();
        RenderingThread.initThreads(LittleTiles.CONFIG.rendering.renderingThreadCount);
    }

    public static class RemovedBlockEntityException
    extends Exception {
        public RemovedBlockEntityException(String arg0) {
            super(arg0);
        }
    }

    public static class RenderingException
    extends Exception {
        public RenderingException(String arg0) {
            super(arg0);
        }
    }
}

