/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.level;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.MemoryTracker;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL15;
import team.creative.creativecore.common.mod.OptifineHelper;
import team.creative.creativecore.common.util.type.map.ChunkLayerMap;
import team.creative.creativecore.common.util.type.map.HashMapList;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.client.render.block.BERenderManager;
import team.creative.littletiles.client.render.cache.BlockBufferCache;
import team.creative.littletiles.client.render.cache.ChunkLayerCache;
import team.creative.littletiles.client.render.cache.ChunkLayerUploadManager;
import team.creative.littletiles.client.render.cache.LayeredBufferCache;
import team.creative.littletiles.client.render.cache.buffer.BufferHolder;
import team.creative.littletiles.client.render.mc.RenderChunkExtender;
import team.creative.littletiles.client.render.mc.VertexBufferExtender;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.entity.animation.LittleAnimationEntity;

@OnlyIn(value=Dist.CLIENT)
public class RenderUploader {
    private static final Minecraft mc = Minecraft.m_91087_();
    private static final HashMap<Level, RenderDataLevel> CACHES = new HashMap();

    private static RenderDataLevel getOrCreate(Level level) {
        RenderDataLevel data = CACHES.get(level);
        if (data == null) {
            data = new RenderDataLevel(level);
            CACHES.put(level, data);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queue(Level targetLevel, LittleAnimationEntity entity) {
        HashMap<Level, RenderDataLevel> hashMap = CACHES;
        synchronized (hashMap) {
            RenderUploader.getOrCreate(entity.f_19853_).queue(targetLevel, entity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyReceiveClientUpdate(BETiles be) {
        if (CACHES.isEmpty()) {
            return;
        }
        HashMap<Level, RenderDataLevel> hashMap = CACHES;
        synchronized (hashMap) {
            RenderDataLevel data = CACHES.get(be.m_58904_());
            if (data != null && data.notifyReceiveClientUpdate(be)) {
                CACHES.remove(be.m_58904_());
            }
        }
    }

    public static void unload() {
        CACHES.clear();
    }

    public static void longTick(int index) {
        Iterator<RenderDataLevel> iterator = CACHES.values().iterator();
        while (iterator.hasNext()) {
            RenderDataLevel level = iterator.next();
            if (!level.longTick(index)) continue;
            iterator.remove();
        }
    }

    public static void uploadRenderData(RenderChunkExtender chunk, Iterable<? extends LayeredBufferCache> blocks) {
        if (OptifineHelper.isRenderRegions() || !LittleTiles.CONFIG.rendering.uploadToVBODirectly) {
            return;
        }
        for (RenderType layer : RenderType.m_110506_()) {
            ChunkLayerCache cache = new ChunkLayerCache();
            int size = 0;
            for (LayeredBufferCache layeredBufferCache : blocks) {
                size += layeredBufferCache.length(layer);
            }
            if (size == 0) continue;
            try {
                VertexBuffer uploadBuffer = chunk.getVertexBuffer(layer);
                if (uploadBuffer == null) {
                    return;
                }
                VertexFormat vertexFormat = uploadBuffer.m_166892_();
                if (vertexFormat == null) {
                    VertexFormat vertexFormat2 = DefaultVertexFormat.f_85811_;
                }
                ChunkRenderDispatcher dispatcher = RenderUploader.mc.f_91060_.m_173015_();
                Buffer vanillaBuffer = null;
                if (!chunk.isEmpty(layer)) {
                    GlStateManager.m_84480_((int)34962, (int)((VertexBufferExtender)uploadBuffer).getVertexBufferId());
                    vanillaBuffer = RenderUploader.glMapBufferRange(((VertexBufferExtender)uploadBuffer).getLastUploadedLength());
                    VertexBuffer.m_85931_();
                }
                BufferBuilder builder = new BufferBuilder(((vanillaBuffer != null ? vanillaBuffer.limit() : 0) + size + DefaultVertexFormat.f_85811_.m_86020_()) / 6);
                chunk.begin(builder);
                if (vanillaBuffer != null) {
                    BufferBuilder.SortState state;
                    if (layer == RenderType.m_110466_() && (state = chunk.getTransparencyState()) != null) {
                        builder.m_166775_(state);
                    }
                    builder.putBulkData((ByteBuffer)vanillaBuffer);
                }
                for (LayeredBufferCache layeredBufferCache : blocks) {
                    cache.add(builder, layeredBufferCache.get(layer));
                }
                if (layer == RenderType.m_110466_()) {
                    chunk.setQuadSortOrigin(builder, dispatcher.m_112727_());
                }
                uploadBuffer.m_85921_();
                uploadBuffer.m_231221_(builder.m_231175_());
                VertexBuffer.m_85931_();
                chunk.setHasBlock(layer);
            }
            catch (IllegalArgumentException | NotSupportedException e) {
                e.printStackTrace();
            }
        }
    }

    public static ByteBuffer glMapBufferRange(long length) throws NotSupportedException {
        try {
            ByteBuffer result = MemoryTracker.m_182527_((int)((int)length));
            GL15.glGetBufferSubData((int)34962, (long)0L, (ByteBuffer)result);
            return result;
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            if (e instanceof IllegalStateException) {
                throw new NotSupportedException(e);
            }
            e.printStackTrace();
            return null;
        }
    }

    public static class RenderDataLevel {
        public final Level level;
        private final HashMap<BlockPos, RenderDataToAdd> caches = new HashMap();
        private int waitTill;

        public RenderDataLevel(Level level) {
            this.level = level;
        }

        private RenderDataToAdd getOrCreate(RenderChunkExtender chunk, BlockPos pos) {
            RenderDataToAdd data = this.caches.get(pos);
            if (data == null) {
                data = new RenderDataToAdd(chunk);
                this.caches.put(pos, data);
            }
            return data;
        }

        public void queue(Level targetLevel, LittleAnimationEntity entity) {
            HashSet<RenderChunkExtender> chunks = new HashSet<RenderChunkExtender>();
            for (BETiles be : entity.getSubLevel()) {
                RenderChunkExtender chunk = be.render.getRenderChunk();
                if (chunks.add(chunk)) {
                    for (RenderType layer : RenderType.m_110506_()) {
                        VertexBufferExtender buffer = (VertexBufferExtender)chunk.getVertexBuffer(layer);
                        ChunkLayerUploadManager manager = buffer.getManager();
                        if (manager == null) continue;
                        manager.backToRAM();
                    }
                }
                RenderDataToAdd block = this.getOrCreate(BERenderManager.getRenderChunk(targetLevel, be.m_58899_()), be.m_58899_());
                block.queueNew(be);
            }
            this.waitTill = LittleTilesClient.ANIMATION_HANDLER.longTickIndex + 2;
            HashMapList chunksList = new HashMapList();
            for (RenderDataToAdd block : this.caches.values()) {
                chunksList.add((Object)block.targetChunk, (Object)block);
            }
            for (Map.Entry entry : chunksList.entrySet()) {
                RenderUploader.uploadRenderData((RenderChunkExtender)entry.getKey(), (Iterable)entry.getValue());
            }
        }

        public boolean notifyReceiveClientUpdate(BETiles be) {
            RenderDataToAdd data = this.caches.remove(be.m_58899_());
            if (data != null) {
                data.receiveUpdate(be);
            }
            return this.caches.isEmpty();
        }

        public boolean longTick(int index) {
            return index >= this.waitTill;
        }
    }

    public static class NotSupportedException
    extends Exception {
        public NotSupportedException(Exception e) {
            super(e);
        }
    }

    private static class RenderDataToAdd
    implements LayeredBufferCache {
        private final ChunkLayerMap<BufferHolder> holders = new ChunkLayerMap();
        private final RenderChunkExtender targetChunk;

        public RenderDataToAdd(RenderChunkExtender chunk) {
            this.targetChunk = chunk;
        }

        @Override
        public int length(RenderType type) {
            BufferHolder holder = (BufferHolder)this.holders.get(type);
            if (holder != null) {
                return holder.length();
            }
            return 0;
        }

        @Override
        public BufferHolder get(RenderType layer) {
            return (BufferHolder)this.holders.get(layer);
        }

        public void queueNew(BETiles be) {
            BlockBufferCache cache = be.render.getBufferCache();
            Vec3 vec = this.targetChunk.offsetCorrection(be.render.getRenderChunk());
            for (RenderType layer : RenderType.m_110506_()) {
                BufferHolder holder = cache.get(layer);
                if (holder == null) continue;
                if (vec != null) {
                    holder.applyOffset(vec);
                }
                this.holders.put(layer, (Object)BlockBufferCache.combine((BufferHolder)this.holders.get(layer), holder));
            }
        }

        public void receiveUpdate(BETiles be) {
            be.render.getBufferCache().additional(this);
        }
    }
}

