/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.block.little.element;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import team.creative.littletiles.api.common.block.LittleBlock;
import team.creative.littletiles.common.block.little.registry.LittleBlockRegistry;

public class LittleElement {
    private BlockState state;
    protected LittleBlock block;
    public int color;

    public static LittleElement of(ItemStack stack, int color) throws NotBlockException {
        Block block = Block.m_49814_((Item)stack.m_41720_());
        if (block != null && !(block instanceof AirBlock)) {
            return new LittleElement(block.m_49966_(), color);
        }
        throw new NotBlockException();
    }

    public LittleElement(LittleElement element) {
        this.state = element.state;
        this.block = element.block;
        this.color = element.color;
    }

    public LittleElement(LittleElement element, int color) {
        this.state = element.state;
        this.block = element.block;
        this.color = color;
    }

    public LittleElement(BlockState state, int color) {
        this.setState(state);
        this.color = color;
    }

    @Deprecated
    public LittleElement(BlockState state, LittleBlock block, int color) {
        this.state = state;
        this.block = block;
        this.color = color;
    }

    public LittleElement(CompoundTag nbt) {
        this(nbt.m_128461_("s"), nbt.m_128441_("c") ? nbt.m_128451_("c") : -1);
    }

    public LittleElement(String name, int color) {
        this.setState(LittleBlockRegistry.loadState(name));
        if (this.state.m_60734_() instanceof AirBlock) {
            this.block = LittleBlockRegistry.getMissing(name);
        }
        this.color = color;
    }

    public BlockState getState() {
        return this.state;
    }

    public void setState(BlockState state) {
        if (this.state != state) {
            this.state = state;
            this.block = LittleBlockRegistry.get(state.m_60734_());
        }
    }

    public LittleBlock getBlock() {
        return this.block;
    }

    public boolean hasColor() {
        return this.color != -1;
    }

    public int hashCode() {
        return this.block.hashCode() + this.color;
    }

    public String getBlockName() {
        String name = LittleBlockRegistry.saveState(this.getState());
        if (name == null) {
            return this.getBlock().blockName();
        }
        return name;
    }

    public CompoundTag save(CompoundTag nbt) {
        nbt.m_128359_("s", this.getBlockName());
        nbt.m_128405_("c", this.color);
        return nbt;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LittleElement) {
            return ((LittleElement)obj).state == this.state && ((LittleElement)obj).color == this.color;
        }
        return super.equals(obj);
    }

    public boolean is(LittleElement element) {
        return element.state == this.state && element.block == this.block && element.color == this.color;
    }

    public String toString() {
        return "[" + this.getBlockName() + "|" + this.color + "]";
    }

    public boolean checkEntityCollision() {
        return this.block.checkEntityCollision();
    }

    public static class NotBlockException
    extends Exception {
    }
}

