/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.config;

import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import team.creative.creativecore.common.config.api.CreativeConfig;
import team.creative.creativecore.common.config.converation.ConfigTypeConveration;

public class LittleBuildingConfig {
    @CreativeConfig
    public boolean limitAffectedBlocks;
    @CreativeConfig
    public int maxAffectedBlocks = 2;
    @CreativeConfig
    public HarvestLevel harvestLevelBlock;
    @CreativeConfig
    public boolean editUnbreakable;
    @CreativeConfig
    @CreativeConfig.IntRange(min=0, max=255)
    public int minimumTransparency;
    @CreativeConfig
    public boolean limitEditBlocks;
    @CreativeConfig
    public int maxEditBlocks = 10;
    @CreativeConfig
    public boolean limitPlaceBlocks;
    @CreativeConfig
    public int maxPlaceBlocks = 10;
    @CreativeConfig
    public boolean limitRecipeSize = false;
    @CreativeConfig
    public int recipeBlocksLimit = 16;

    public LittleBuildingConfig() {
        this.limitAffectedBlocks = true;
        this.editUnbreakable = false;
        this.minimumTransparency = 0;
        this.limitEditBlocks = true;
        this.limitPlaceBlocks = true;
        this.harvestLevelBlock = HarvestLevel.WOOD;
        this.maxAffectedBlocks = 0;
        this.maxEditBlocks = 0;
        this.maxPlaceBlocks = 0;
    }

    public LittleBuildingConfig(boolean survival) {
        this.limitAffectedBlocks = survival;
        this.editUnbreakable = !survival;
        this.minimumTransparency = survival ? 255 : 0;
        this.limitEditBlocks = survival;
        this.limitPlaceBlocks = survival;
        this.harvestLevelBlock = survival ? HarvestLevel.STONE : HarvestLevel.DIAMOND;
    }

    static {
        ConfigTypeConveration.registerTypeCreator(LittleBuildingConfig.class, () -> new LittleBuildingConfig());
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum HarvestLevel {
        DIAMOND{

            @Override
            public boolean is(Block block) {
                return true;
            }
        }
        ,
        IRON{

            @Override
            public boolean is(Block block) {
                return block.m_204297_().m_203656_(BlockTags.f_144285_) || !block.m_204297_().m_203656_(BlockTags.f_144284_);
            }
        }
        ,
        STONE{

            @Override
            public boolean is(Block block) {
                return block.m_204297_().m_203656_(BlockTags.f_144286_) || !block.m_204297_().m_203656_(BlockTags.f_144285_) && !block.m_204297_().m_203656_(BlockTags.f_144284_);
            }
        }
        ,
        WOOD{

            @Override
            public boolean is(Block block) {
                return !block.m_204297_().m_203656_(BlockTags.f_144286_) && !block.m_204297_().m_203656_(BlockTags.f_144285_) && !block.m_204297_().m_203656_(BlockTags.f_144284_);
            }
        };


        public abstract boolean is(Block var1);
    }
}

