/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.entity.level;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.type.itr.FunctionIterator;
import team.creative.creativecore.common.util.type.set.QuadBitSet;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.entity.LittleEntity;
import team.creative.littletiles.common.level.little.LevelBoundsListener;
import team.creative.littletiles.common.level.little.LittleLevel;
import team.creative.littletiles.common.packet.entity.LittleEntityPhysicPacket;

public class BlockUpdateLevelSystem {
    public final LittleLevel level;
    private final List<LevelBoundsListener> levelBoundListeners = new ArrayList<LevelBoundsListener>();
    private final ConcurrentHashMap<BlockPos, BlockState> changes = new ConcurrentHashMap();
    private boolean emptyLevel = true;
    private int minX = Integer.MAX_VALUE;
    private int minY = Integer.MAX_VALUE;
    private int minZ = Integer.MAX_VALUE;
    private int maxX = Integer.MIN_VALUE;
    private int maxY = Integer.MIN_VALUE;
    private int maxZ = Integer.MIN_VALUE;
    private boolean[] changed = new boolean[6];
    private QuadBitSet east = new QuadBitSet();
    private QuadBitSet west = new QuadBitSet();
    private QuadBitSet up = new QuadBitSet();
    private QuadBitSet down = new QuadBitSet();
    private QuadBitSet south = new QuadBitSet();
    private QuadBitSet north = new QuadBitSet();

    public BlockUpdateLevelSystem(LittleLevel level) {
        this.level = level;
    }

    public void load(CompoundTag nbt) {
        this.clearAllEdges();
        if (nbt.m_128471_("empty")) {
            this.rescanEntireLevel();
            return;
        }
        int[] bounds = nbt.m_128465_("bounds");
        if (bounds.length != 6) {
            this.rescanEntireLevel();
            return;
        }
        this.minX = bounds[0];
        this.minY = bounds[1];
        this.minZ = bounds[2];
        this.maxX = bounds[3];
        this.maxY = bounds[4];
        this.maxZ = bounds[5];
        this.emptyLevel = false;
        this.east.load(nbt.m_128469_("e"));
        this.west.load(nbt.m_128469_("w"));
        this.up.load(nbt.m_128469_("u"));
        this.down.load(nbt.m_128469_("d"));
        this.south.load(nbt.m_128469_("s"));
        this.north.load(nbt.m_128469_("n"));
    }

    public CompoundTag save() {
        CompoundTag nbt = new CompoundTag();
        if (this.emptyLevel) {
            nbt.m_128379_("empty", this.emptyLevel);
            return nbt;
        }
        nbt.m_128385_("bounds", new int[]{this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ});
        nbt.m_128365_("e", (Tag)this.east.save());
        nbt.m_128365_("w", (Tag)this.west.save());
        nbt.m_128365_("u", (Tag)this.up.save());
        nbt.m_128365_("d", (Tag)this.down.save());
        nbt.m_128365_("s", (Tag)this.south.save());
        nbt.m_128365_("n", (Tag)this.north.save());
        return nbt;
    }

    private void clearAllEdges() {
        this.east.clear();
        this.west.clear();
        this.up.clear();
        this.down.clear();
        this.south.clear();
        this.north.clear();
    }

    public int get(Facing facing) {
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Facing.EAST -> this.maxX;
            case Facing.WEST -> this.minX;
            case Facing.UP -> this.maxY;
            case Facing.DOWN -> this.minY;
            case Facing.SOUTH -> this.maxZ;
            case Facing.NORTH -> this.minZ;
        };
    }

    protected void set(Facing facing, int value) {
        switch (facing) {
            case EAST: {
                this.maxX = value;
                break;
            }
            case WEST: {
                this.minX = value;
                break;
            }
            case UP: {
                this.maxY = value;
                break;
            }
            case DOWN: {
                this.minY = value;
                break;
            }
            case SOUTH: {
                this.maxZ = value;
                break;
            }
            case NORTH: {
                this.minZ = value;
            }
        }
    }

    public QuadBitSet getEdgeSet(Facing facing) {
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Facing.EAST -> this.east;
            case Facing.WEST -> this.west;
            case Facing.UP -> this.up;
            case Facing.DOWN -> this.down;
            case Facing.SOUTH -> this.south;
            case Facing.NORTH -> this.north;
        };
    }

    public void registerLevelBoundListener(LevelBoundsListener listener) {
        this.levelBoundListeners.add(listener);
    }

    public Iterable<LevelBoundsListener> levelBoundListeners() {
        return this.levelBoundListeners;
    }

    protected boolean isWithinBoundsNoEdge(BlockPos pos) {
        return this.minX < pos.m_123341_() && this.maxX > pos.m_123341_() && this.minY < pos.m_123342_() && this.maxY > pos.m_123342_() && this.minZ < pos.m_123343_() && this.maxZ > pos.m_123343_();
    }

    protected boolean isWithinBounds(BlockPos pos) {
        return this.minX <= pos.m_123341_() && this.maxX >= pos.m_123341_() && this.minY <= pos.m_123342_() && this.maxY >= pos.m_123342_() && this.minZ <= pos.m_123343_() && this.maxZ >= pos.m_123343_();
    }

    private Iterable<BlockPos> edges(Facing facing) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        facing.axis.set(pos, this.get(facing));
        Axis one = facing.one();
        Axis two = facing.two();
        return () -> new FunctionIterator((Iterable)this.getEdgeSet(facing), x -> {
            one.set(pos, x.x);
            two.set(pos, x.y);
            return pos;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick(LittleEntity entity) {
        ConcurrentHashMap<BlockPos, BlockState> concurrentHashMap = this.changes;
        synchronized (concurrentHashMap) {
            if (!this.changes.isEmpty()) {
                for (Map.Entry<BlockPos, BlockState> entry : this.changes.entrySet()) {
                    this.blockChangedInternal(entry.getKey(), entry.getValue());
                }
                this.changes.clear();
            }
        }
        boolean needsUpdate = false;
        for (int i = 0; i < this.changed.length; ++i) {
            if (!this.changed[i]) continue;
            Facing facing = Facing.get((int)i);
            this.levelBoundListeners.forEach(x -> x.rescan(this.level, this, facing, this.edges(facing), facing.positive ? this.get(facing) + 1 : this.get(facing)));
            this.changed[i] = false;
            needsUpdate = true;
        }
        if (needsUpdate) {
            this.levelBoundListeners.forEach(x -> x.afterChangesApplied(this));
            if (!entity.f_19853_.f_46443_) {
                LittleTiles.NETWORK.sendToClientTracking((CreativePacket)new LittleEntityPhysicPacket(entity), (Entity)entity);
            }
        }
    }

    protected boolean isEmpty(ChunkAccess chunk) {
        LevelChunkSection[] sections = chunk.m_7103_();
        for (int i = 0; i < sections.length; ++i) {
            if (sections[i].m_188008_()) continue;
            return false;
        }
        return true;
    }

    protected int getMax(ChunkAccess chunk) {
        LevelChunkSection[] sections = chunk.m_7103_();
        for (int i = sections.length - 1; i >= 0; --i) {
            if (sections[i].m_188008_()) continue;
            return i;
        }
        return -1;
    }

    protected int getMin(ChunkAccess chunk) {
        LevelChunkSection[] sections = chunk.m_7103_();
        for (int i = 0; i < sections.length; ++i) {
            if (sections[i].m_188008_()) continue;
            return i;
        }
        return -1;
    }

    protected void findYEdge(Facing facing, int start) {
        QuadBitSet edge = this.getEdgeSet(facing);
        edge.clear();
        ArrayList<ChunkAccess> edgeChunks = new ArrayList<ChunkAccess>();
        int currentSection = facing.positive ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        for (ChunkAccess chunkAccess : this.level.chunks()) {
            int pos = facing.positive ? this.getMax(chunkAccess) : this.getMin(chunkAccess);
            if (pos == -1 || (!facing.positive ? pos > currentSection : pos < currentSection)) continue;
            if (currentSection == pos) {
                edgeChunks.add(chunkAccess);
                continue;
            }
            currentSection = pos;
            edgeChunks.clear();
            edgeChunks.add(chunkAccess);
        }
        if (edgeChunks.isEmpty()) {
            this.set(facing, facing.positive ? Integer.MIN_VALUE : Integer.MAX_VALUE);
            this.emptyLevel = true;
            return;
        }
        this.emptyLevel = false;
        int sectionIndex = this.level.m_151568_(currentSection);
        boolean bl = SectionPos.m_123171_((int)start) != sectionIndex;
        int blockPosOffset = SectionPos.m_123223_((int)sectionIndex);
        int axisValueStart = bl ? (facing.positive ? 15 : 0) : (facing.positive ? Math.min(start - blockPosOffset, 15) : Math.max(start - blockPosOffset, 0));
        int axisValueEnd = facing.positive ? 0 : 15;
        Axis one = facing.one();
        Axis two = facing.two();
        block1: for (ChunkAccess chunk : edgeChunks) {
            int offsetOne = SectionPos.m_123223_((int)one.get(chunk.m_7697_()));
            int offsetTwo = SectionPos.m_123223_((int)two.get(chunk.m_7697_()));
            LevelChunkSection section = chunk.m_183278_(currentSection);
            int axisValue = axisValueStart;
            while (facing.positive ? axisValue >= axisValueEnd : axisValue <= axisValueEnd) {
                boolean found = false;
                for (int valueOne = 0; valueOne < 16; ++valueOne) {
                    for (int valueTwo = 0; valueTwo < 16; ++valueTwo) {
                        int z;
                        int x = one == Axis.X ? valueOne : valueTwo;
                        int y = axisValue;
                        int n = z = one == Axis.Z ? valueOne : valueTwo;
                        if (section.m_62982_(x, y, z).m_60795_()) continue;
                        if (facing.positive ? axisValue > axisValueEnd : axisValue < axisValueEnd) {
                            edge.clear();
                            axisValueEnd = axisValue;
                        }
                        edge.set(valueOne + offsetOne, valueTwo + offsetTwo);
                        found = true;
                    }
                }
                if (found) continue block1;
                axisValue += facing.positive ? -1 : 1;
            }
        }
        this.set(facing, axisValueEnd + blockPosOffset);
    }

    protected void findEdge(Facing facing, int start) {
        if (facing.axis == Axis.Y) {
            this.findYEdge(facing, start);
            return;
        }
        Axis axis = facing.axis;
        QuadBitSet edge = this.getEdgeSet(facing);
        edge.clear();
        ArrayList<ChunkAccess> edgeChunks = new ArrayList<ChunkAccess>();
        int currentChunkPos = facing.positive ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        for (ChunkAccess chunkAccess : this.level.chunks()) {
            int pos = axis.get(chunkAccess.m_7697_());
            if ((!facing.positive ? pos > currentChunkPos : pos < currentChunkPos) || this.isEmpty(chunkAccess)) continue;
            if (currentChunkPos == pos) {
                edgeChunks.add(chunkAccess);
                continue;
            }
            currentChunkPos = pos;
            edgeChunks.clear();
            edgeChunks.add(chunkAccess);
        }
        if (edgeChunks.isEmpty()) {
            this.set(facing, facing.positive ? Integer.MIN_VALUE : Integer.MAX_VALUE);
            this.emptyLevel = true;
            return;
        }
        this.emptyLevel = false;
        boolean ignoreStart = SectionPos.m_123171_((int)start) != currentChunkPos;
        int n = SectionPos.m_123223_((int)currentChunkPos);
        int axisValueStart = ignoreStart ? (facing.positive ? 15 : 0) : (facing.positive ? Math.min(start - n, 15) : Math.max(start - n, 0));
        int axisValueEnd = facing.positive ? 0 : 15;
        Axis one = facing.one();
        Axis two = facing.two();
        block1: for (ChunkAccess chunk : edgeChunks) {
            int sectionOffsetX = SectionPos.m_123223_((int)chunk.m_7697_().f_45578_);
            int sectionOffsetZ = SectionPos.m_123223_((int)chunk.m_7697_().f_45579_);
            int axisValue = axisValueStart;
            while (facing.positive ? axisValue >= axisValueEnd : axisValue <= axisValueEnd) {
                boolean found = false;
                LevelChunkSection[] sections = chunk.m_7103_();
                for (int i = 0; i < sections.length; ++i) {
                    if (sections[i].m_188008_()) continue;
                    LevelChunkSection section = sections[i];
                    int offsetOne = one.get(sectionOffsetX, section.m_63017_(), sectionOffsetZ);
                    int offsetTwo = two.get(sectionOffsetX, section.m_63017_(), sectionOffsetZ);
                    for (int valueOne = 0; valueOne < 16; ++valueOne) {
                        for (int valueTwo = 0; valueTwo < 16; ++valueTwo) {
                            int z;
                            int y;
                            int x;
                            int n2 = one == Axis.X ? valueOne : (x = two == Axis.X ? valueTwo : axisValue);
                            int n3 = one == Axis.Y ? valueOne : (y = two == Axis.Y ? valueTwo : axisValue);
                            int n4 = one == Axis.Z ? valueOne : (z = two == Axis.Z ? valueTwo : axisValue);
                            if (section.m_62982_(x, y, z).m_60795_()) continue;
                            if (facing.positive ? axisValue > axisValueEnd : axisValue < axisValueEnd) {
                                edge.clear();
                                axisValueEnd = axisValue;
                            }
                            edge.set(valueOne + offsetOne, valueTwo + offsetTwo);
                            found = true;
                        }
                    }
                }
                if (found) continue block1;
                axisValue += facing.positive ? -1 : 1;
            }
        }
        this.set(facing, axisValueEnd + n);
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean isSameThreadClient() {
        return Minecraft.m_91087_().m_18695_();
    }

    private boolean isSameThread() {
        if (this.level.m_5776_()) {
            return this.isSameThreadClient();
        }
        return this.level.m_7654_().m_18695_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockChanged(BlockPos pos, BlockState newState) {
        ConcurrentHashMap<BlockPos, BlockState> concurrentHashMap = this.changes;
        synchronized (concurrentHashMap) {
            if (this.isSameThread() && this.changes.isEmpty()) {
                this.blockChangedInternal(pos, newState);
            } else {
                this.changes.put(pos.m_7949_(), newState);
            }
        }
    }

    protected void blockChangedInternal(BlockPos pos, BlockState newState) {
        if (this.isWithinBoundsNoEdge(pos)) {
            return;
        }
        if (newState.m_60795_()) {
            for (int i = 0; i < Facing.VALUES.length; ++i) {
                Facing facing = Facing.get((int)i);
                if (facing.axis.get((Vec3i)pos) != this.get(facing)) continue;
                QuadBitSet set = this.getEdgeSet(facing);
                set.set(facing.one().get((Vec3i)pos), facing.two().get((Vec3i)pos), false);
                if (set.isEmpty()) {
                    this.findEdge(facing, this.get(facing) + (facing.positive ? -1 : 1));
                }
                this.changed[facing.ordinal()] = true;
            }
            return;
        }
        for (int i = 0; i < Facing.VALUES.length; ++i) {
            QuadBitSet set;
            Facing facing = Facing.get((int)i);
            int bound = this.get(facing);
            if (facing.axis.get((Vec3i)pos) == bound) {
                set = this.getEdgeSet(facing);
                set.set(facing.one().get((Vec3i)pos), facing.two().get((Vec3i)pos), true);
                this.emptyLevel = false;
                this.changed[facing.ordinal()] = true;
                continue;
            }
            if (!(facing.positive ? facing.axis.get((Vec3i)pos) > bound : facing.axis.get((Vec3i)pos) < bound)) continue;
            set = this.getEdgeSet(facing);
            set.clear();
            set.set(facing.one().get((Vec3i)pos), facing.two().get((Vec3i)pos), true);
            this.set(facing, facing.axis.get((Vec3i)pos));
            this.emptyLevel = false;
            this.changed[facing.ordinal()] = true;
        }
    }

    protected void rescanEntireLevel() {
        for (int i = 0; i < Facing.VALUES.length; ++i) {
            this.findEdge(Facing.get((int)i), Facing.get((int)i).positive ? Integer.MIN_VALUE : Integer.MAX_VALUE);
        }
        Arrays.fill(this.changed, true);
    }

    public boolean isEntirelyEmpty() {
        return this.emptyLevel;
    }
}

