/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.controls.animation;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.controls.collection.GuiComboBoxMapped;
import team.creative.creativecore.common.gui.controls.parent.GuiLabeledControl;
import team.creative.creativecore.common.gui.controls.simple.GuiButton;
import team.creative.creativecore.common.gui.controls.simple.GuiIconButton;
import team.creative.creativecore.common.gui.controls.simple.GuiSlider;
import team.creative.creativecore.common.gui.controls.simple.GuiTextfield;
import team.creative.creativecore.common.gui.controls.timeline.GuiTimeline;
import team.creative.creativecore.common.gui.controls.timeline.GuiTimelineChannel;
import team.creative.creativecore.common.gui.controls.timeline.GuiTimelineKey;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.style.GuiIcon;
import team.creative.creativecore.common.util.math.vec.Vec1d;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.creativecore.common.util.type.list.Pair;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.gui.controls.GuiDistanceControl;
import team.creative.littletiles.common.gui.controls.animation.GuiChildEventPanel;
import team.creative.littletiles.common.gui.controls.animation.GuiSoundEventPanel;
import team.creative.littletiles.common.gui.controls.animation.GuiTimelinePanel;
import team.creative.littletiles.common.gui.tool.recipe.GuiRecipeAnimationHandler;
import team.creative.littletiles.common.gui.tool.recipe.GuiTreeItemStructure;
import team.creative.littletiles.common.structure.animation.AnimationTimeline;
import team.creative.littletiles.common.structure.animation.PhysicalPart;
import team.creative.littletiles.common.structure.animation.curve.ValueCurve;
import team.creative.littletiles.common.structure.animation.curve.ValueCurveInterpolation;
import team.creative.littletiles.common.structure.animation.curve.ValueInterpolation;
import team.creative.littletiles.common.structure.animation.event.AnimationEvent;
import team.creative.littletiles.common.structure.animation.event.ChildDoorEvent;
import team.creative.littletiles.common.structure.animation.event.PlaySoundEvent;
import team.creative.littletiles.common.structure.registry.gui.LittleDoorAdvancedGui;
import team.creative.littletiles.common.structure.type.animation.LittleDoor;

public class GuiAnimationTimelinePanel
extends GuiTimelinePanel {
    private LittleDoorAdvancedGui.GuiAdvancedTimelineChannel rotX;
    private LittleDoorAdvancedGui.GuiAdvancedTimelineChannel rotY;
    private LittleDoorAdvancedGui.GuiAdvancedTimelineChannel rotZ;
    private LittleDoorAdvancedGui.GuiAdvancedTimelineChannel offX;
    private LittleDoorAdvancedGui.GuiAdvancedTimelineChannel offY;
    private LittleDoorAdvancedGui.GuiAdvancedTimelineChannel offZ;
    protected final List<GuiSoundEventPanel.GuiSoundTimelineChannel> soundChannels = new ArrayList<GuiSoundEventPanel.GuiSoundTimelineChannel>();
    protected final List<GuiChildEventPanel.GuiChildTimelineChannel> childChannels = new ArrayList<GuiChildEventPanel.GuiChildTimelineChannel>();
    public final GuiTreeItemStructure item;
    public GuiTimelineKey edited;

    public GuiAnimationTimelinePanel(GuiTreeItemStructure item, GuiRecipeAnimationHandler handler, int duration, AnimationTimeline timeline, boolean limited) {
        super(handler, duration);
        Object channel;
        this.item = item;
        for (PhysicalPart part : PhysicalPart.values()) {
            channel = new LittleDoorAdvancedGui.GuiAdvancedTimelineChannel(this.time, part.offset, limited);
            ValueCurve<Vec1d> valueCurve = timeline.get(part);
            if (valueCurve instanceof ValueCurveInterpolation) {
                ValueCurveInterpolation curve = (ValueCurveInterpolation)valueCurve;
                for (Pair pair : curve) {
                    channel.addKey((Integer)pair.key, ((Vec1d)pair.value).x);
                }
            }
            this.time.addGuiTimelineChannel(part.title(), (GuiTimelineChannel)channel);
            this.set(part, (LittleDoorAdvancedGui.GuiAdvancedTimelineChannel)((Object)channel));
        }
        List<AnimationTimeline.AnimationEventEntry> soundEvents = GuiAnimationTimelinePanel.extract(timeline, PlaySoundEvent.class);
        for (int i = 0; i < soundEvents.size(); ++i) {
            AnimationTimeline.AnimationEventEntry entry = soundEvents.get(i);
            int id = 0;
            while (true) {
                if (id >= this.soundChannels.size()) {
                    channel = new GuiSoundEventPanel.GuiSoundTimelineChannel(this.time);
                    this.soundChannels.add((GuiSoundEventPanel.GuiSoundTimelineChannel)((Object)channel));
                    this.time.addGuiTimelineChannel(GuiAnimationTimelinePanel.translatable((String)"gui.door.sound").m_130946_("" + id), (GuiTimelineChannel)channel);
                    continue;
                }
                if (this.soundChannels.get(id).isSpaceFor(null, entry.start)) break;
                ++id;
            }
            this.soundChannels.get(id).addKey(entry.start, (PlaySoundEvent)entry.getEvent());
        }
        List<AnimationTimeline.AnimationEventEntry> childEvents = GuiAnimationTimelinePanel.extract(timeline, ChildDoorEvent.class);
        for (AnimationTimeline.AnimationEventEntry entry : childEvents) {
            ChildDoorEvent event = (ChildDoorEvent)entry.getEvent();
            GuiChildEventPanel.GuiChildTimelineChannel channel2 = this.getOrCreateChild(event.childId);
            if (!channel2.isSpaceFor(null, entry.start)) continue;
            channel2.addKey(entry.start, event);
        }
        GuiParent addPanel = new GuiParent((GuiFlow)GuiFlow.FIT_X);
        this.add(addPanel.setExpandableX());
        addPanel.add((GuiControl)new GuiButton("add_sound", x -> {
            GuiSoundEventPanel.GuiSoundTimelineChannel channel = new GuiSoundEventPanel.GuiSoundTimelineChannel(this.time);
            this.time.addGuiTimelineChannel(GuiAnimationTimelinePanel.translatable((String)"gui.door.sound").m_130946_("" + this.soundChannels.size()), (GuiTimelineChannel)channel);
            this.soundChannels.add(channel);
            this.reflow();
        }).setTranslate("gui.door.sound.add"));
        addPanel.add((GuiControl)new GuiComboBoxMapped("childBox", new TextMapBuilder()));
        addPanel.add((GuiControl)new GuiButton("childAdd", x -> {
            GuiComboBoxMapped childBox = (GuiComboBoxMapped)this.get("childBox");
            Integer selected = (Integer)childBox.getSelected();
            if (selected != null) {
                this.getOrCreateChild(selected);
            }
            this.updateAddBox();
        }).setTranslate("gui.add"));
        addPanel.add((GuiControl)new GuiButton("removed_unused", x -> {
            GuiTimelinePanel.clearUnusedChannel(this.soundChannels);
            GuiTimelinePanel.clearUnusedChannel(this.childChannels);
            this.updateAddBox();
        }).setTranslate("gui.door.clean.channel"));
        GuiParent editKey = new GuiParent((GuiFlow)GuiFlow.FIT_X);
        this.add(editKey.setExpandableX());
        this.registerEvent(GuiTimeline.KeySelectedEvent.class, x -> {
            editKey.clear();
            GuiTimelineChannel patt6912$temp = ((GuiTimelineKey)x.control).channel;
            if (patt6912$temp instanceof LittleDoorAdvancedGui.GuiAdvancedTimelineChannel) {
                LittleDoorAdvancedGui.GuiAdvancedTimelineChannel c = (LittleDoorAdvancedGui.GuiAdvancedTimelineChannel)patt6912$temp;
                if (c.distance) {
                    GuiDistanceControl distance = new GuiDistanceControl("distance", LittleGrid.min(), 0);
                    distance.setVanillaDistance((Double)((GuiTimelineKey)x.control).value);
                    editKey.add((GuiControl)distance);
                } else {
                    editKey.add((GuiControl)new GuiTextfield("value", "" + ((GuiTimelineKey)x.control).value).setFloatOnly());
                }
            } else {
                GuiTimelineChannel patt7378$temp = ((GuiTimelineKey)x.control).channel;
                if (patt7378$temp instanceof GuiChildEventPanel.GuiChildTimelineChannel) {
                    GuiChildEventPanel.GuiChildTimelineChannel c = (GuiChildEventPanel.GuiChildTimelineChannel)patt7378$temp;
                    this.edited = null;
                    this.reflow();
                } else {
                    GuiTimelineChannel patt7519$temp = ((GuiTimelineKey)x.control).channel;
                    if (patt7519$temp instanceof GuiSoundEventPanel.GuiSoundTimelineChannel) {
                        GuiSoundEventPanel.GuiSoundTimelineChannel c = (GuiSoundEventPanel.GuiSoundTimelineChannel)patt7519$temp;
                        PlaySoundEvent value = (PlaySoundEvent)((GuiTimelineKey)x.control).value;
                        GuiComboBoxMapped box = new GuiComboBoxMapped("sound", new TextMapBuilder().addComponent((Iterable)BuiltInRegistries.f_256894_.m_6566_(), y -> {
                            if (y.m_135827_().equals("minecraft")) {
                                return Component.m_237113_((String)y.m_135815_());
                            }
                            return Component.m_237113_((String)y.toString());
                        })).setSearchbar(true);
                        box.select((Object)value.sound.m_11660_());
                        editKey.add((GuiControl)box);
                        GuiParent other = new GuiParent().setVAlign(VAlign.CENTER);
                        other.add((GuiControl)new GuiLabeledControl((Component)GuiControl.translatable((String)"gui.volume").m_130946_(":"), new GuiSlider("volume", (double)value.volume, 0.0, 1.0).setDim(40, 10)));
                        other.add((GuiControl)new GuiLabeledControl((Component)GuiControl.translatable((String)"gui.pitch").m_130946_(":"), new GuiSlider("pitch", (double)value.pitch, 0.5, 2.0).setDim(40, 10)));
                        other.add((GuiControl)new GuiIconButton("play", GuiIcon.PLAY, y -> {
                            GuiSlider volume = (GuiSlider)other.get("volume");
                            GuiSlider pitch = (GuiSlider)other.get("pitch");
                            GuiControl.playSound((SoundEvent)PlaySoundEvent.get((ResourceLocation)box.getSelected()), (float)((float)volume.value), (float)((float)pitch.value));
                        }));
                        editKey.add((GuiControl)other);
                    }
                }
            }
            this.edited = (GuiTimelineKey)x.control;
            this.reflow();
        });
        this.registerEvent(GuiTimeline.NoKeySelectedEvent.class, x -> {
            editKey.clear();
            this.edited = null;
        });
        editKey.registerEventChanged(x -> {
            Object patt9670$temp;
            GuiControl patt9234$temp = x.control;
            if (patt9234$temp instanceof GuiDistanceControl) {
                GuiDistanceControl distance = (GuiDistanceControl)patt9234$temp;
                this.edited.value = distance.getVanillaDistance();
                this.time.raiseEvent((GuiEvent)new GuiControlChangedEvent((GuiControl)this.time));
            } else {
                GuiControl patt9441$temp = x.control;
                if (patt9441$temp instanceof GuiTextfield) {
                    GuiTextfield text = (GuiTextfield)patt9441$temp;
                    this.edited.value = text.parseDouble();
                    this.time.raiseEvent((GuiEvent)new GuiControlChangedEvent((GuiControl)this.time));
                }
            }
            if (this.edited != null && (patt9670$temp = this.edited.value) instanceof PlaySoundEvent) {
                GuiControl patt10098$temp;
                GuiControl patt9950$temp;
                GuiControl patt9761$temp;
                PlaySoundEvent value = (PlaySoundEvent)patt9670$temp;
                if (x.control.is("sound") && (patt9761$temp = x.control) instanceof GuiComboBoxMapped) {
                    GuiComboBoxMapped box = (GuiComboBoxMapped)patt9761$temp;
                    value.sound = PlaySoundEvent.get((ResourceLocation)box.getSelected());
                } else if (x.control.is("volume") && (patt9950$temp = x.control) instanceof GuiSlider) {
                    GuiSlider slider = (GuiSlider)patt9950$temp;
                    value.volume = (float)slider.value;
                } else if (x.control.is("pitch") && (patt10098$temp = x.control) instanceof GuiSlider) {
                    GuiSlider slider = (GuiSlider)patt10098$temp;
                    value.pitch = (float)slider.value;
                }
                this.time.raiseEvent((GuiEvent)new GuiControlChangedEvent((GuiControl)this.time));
            }
        });
        this.updateAddBox();
    }

    protected GuiChildEventPanel.GuiChildTimelineChannel getOrCreateChild(int id) {
        while (this.childChannels.size() <= id) {
            this.childChannels.add(null);
        }
        GuiChildEventPanel.GuiChildTimelineChannel channel = this.childChannels.get(id);
        if (channel == null) {
            channel = new GuiChildEventPanel.GuiChildTimelineChannel(this.time, id);
            this.childChannels.set(id, channel);
            this.time.addGuiTimelineChannel(Component.m_237113_((String)("" + id)), (GuiTimelineChannel)channel);
        }
        return channel;
    }

    protected boolean hasChild(int id) {
        return this.childChannels.size() > id && this.childChannels.get(id) != null;
    }

    public void updateAddBox() {
        GuiComboBoxMapped childBox = (GuiComboBoxMapped)this.get("childBox");
        GuiButton button = (GuiButton)this.get("childAdd");
        TextMapBuilder map = new TextMapBuilder();
        for (int i = 0; i < this.item.itemsCount(); ++i) {
            if (this.hasChild(i) || !(this.item.getChildStructure(i) instanceof LittleDoor)) continue;
            map.addComponent((Object)i, (Component)Component.m_237113_((String)((GuiTreeItemStructure)this.item.getItem(i)).getTitle()));
        }
        childBox.setLines(map);
        childBox.setEnabled(map.size() > 0);
        button.setEnabled(map.size() > 0);
        if (this.getParent() != null) {
            this.reflow();
        }
    }

    public LittleDoorAdvancedGui.GuiAdvancedTimelineChannel get(PhysicalPart part) {
        return switch (part) {
            default -> throw new IncompatibleClassChangeError();
            case PhysicalPart.OFFX -> this.offX;
            case PhysicalPart.OFFY -> this.offY;
            case PhysicalPart.OFFZ -> this.offZ;
            case PhysicalPart.ROTX -> this.rotX;
            case PhysicalPart.ROTY -> this.rotY;
            case PhysicalPart.ROTZ -> this.rotZ;
        };
    }

    public void set(PhysicalPart part, LittleDoorAdvancedGui.GuiAdvancedTimelineChannel value) {
        switch (part) {
            case OFFX: {
                this.offX = value;
                break;
            }
            case OFFY: {
                this.offY = value;
                break;
            }
            case OFFZ: {
                this.offZ = value;
                break;
            }
            case ROTX: {
                this.rotX = value;
                break;
            }
            case ROTY: {
                this.rotY = value;
                break;
            }
            case ROTZ: {
                this.rotZ = value;
            }
        }
    }

    protected ValueCurve<Vec1d> parse(Iterable<GuiTimelineKey<Double>> keys, ValueInterpolation interpolation, int duration) {
        ValueCurveInterpolation<Vec1d> curve = interpolation.create1d();
        for (GuiTimelineKey<Double> key : keys) {
            if (key.tick == 0 || key.tick >= duration) continue;
            curve.add(key.tick, new Vec1d(((Double)key.value).doubleValue()));
        }
        return curve;
    }

    public AnimationTimeline generateTimeline(int duration, ValueInterpolation interpolation) {
        ArrayList<AnimationTimeline.AnimationEventEntry> events = new ArrayList<AnimationTimeline.AnimationEventEntry>();
        for (GuiChildEventPanel.GuiChildTimelineChannel physicalPartArray : this.childChannels) {
            for (GuiTimelineKey key : physicalPartArray.keys()) {
                if (key.tick > duration) continue;
                events.add(new AnimationTimeline.AnimationEventEntry(key.tick, (AnimationEvent)key.value));
            }
        }
        for (GuiSoundEventPanel.GuiSoundTimelineChannel guiSoundTimelineChannel : this.soundChannels) {
            for (GuiTimelineKey key : guiSoundTimelineChannel.keys()) {
                if (key.tick > duration) continue;
                events.add(new AnimationTimeline.AnimationEventEntry(key.tick, (AnimationEvent)key.value));
            }
        }
        AnimationTimeline timeline = new AnimationTimeline(duration, events);
        PhysicalPart[] physicalPartArray = PhysicalPart.values();
        int n = physicalPartArray.length;
        for (int i = 0; i < n; ++i) {
            PhysicalPart part;
            LittleDoorAdvancedGui.GuiAdvancedTimelineChannel channel = this.get(part = physicalPartArray[i]);
            timeline.set(part, channel.isChannelEmpty() ? ValueCurve.ONE_EMPTY : this.parse(channel.keys(), interpolation, duration));
        }
        return timeline;
    }
}

