/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.tool.recipe;

import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.controls.collection.GuiComboBoxMapped;
import team.creative.creativecore.common.gui.controls.parent.GuiLeftRightBox;
import team.creative.creativecore.common.gui.controls.simple.GuiButton;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.gui.controls.tree.GuiTreeItem;
import team.creative.creativecore.common.gui.dialog.DialogGuiLayer;
import team.creative.creativecore.common.gui.dialog.GuiDialogHandler;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.flow.GuiSizeRule;
import team.creative.creativecore.common.gui.integration.IGuiIntegratedParent;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.littletiles.common.gui.signal.dialog.GuiDialogSignalEvents;
import team.creative.littletiles.common.gui.tool.recipe.GuiRecipe;
import team.creative.littletiles.common.gui.tool.recipe.GuiTreeItemStructure;

public class GuiRecipeMerge
extends GuiLayer {
    public GuiRecipe recipe;
    public GuiTreeItemStructure structure;

    public GuiRecipeMerge() {
        super("gui.recipe.merge");
        this.setDim((GuiSizeRule)new GuiSizeRule.GuiFixedDimension(150));
        this.flow = GuiFlow.STACK_Y;
    }

    public void init(GuiRecipe recipe) {
        this.recipe = recipe;
        this.structure = (GuiTreeItemStructure)recipe.tree.selected();
        this.clear();
        this.init();
    }

    public boolean isParent(GuiTreeItemStructure item, GuiTreeItemStructure possibleParent) {
        if (possibleParent.getLevel() >= item.getLevel()) {
            return false;
        }
        if (item.getParentItem() == possibleParent) {
            return true;
        }
        GuiTreeItem guiTreeItem = item.getParentItem();
        if (guiTreeItem instanceof GuiTreeItemStructure) {
            GuiTreeItemStructure parent = (GuiTreeItemStructure)guiTreeItem;
            return this.isParent(parent, possibleParent);
        }
        return false;
    }

    public void create() {
        boolean isEmpty;
        if (this.structure == null) {
            return;
        }
        this.add((GuiControl)new GuiLabel("title").setTranslate("gui.recipe.merge.title", new Object[]{this.structure.getTitle()}));
        TextMapBuilder map = new TextMapBuilder();
        this.recipe.actionOnAllItems(x -> {
            if (this.structure == x || this.isParent(this.structure, (GuiTreeItemStructure)x)) {
                return;
            }
            Object prefix = "";
            for (int i = 1; i < x.getLevel(); ++i) {
                prefix = (String)prefix + "-";
            }
            map.addComponent(x, (Component)Component.m_237113_((String)((String)prefix + x.getTitle())));
        });
        boolean bl = isEmpty = map.size() == 0;
        if (isEmpty) {
            map.addComponent(null, (Component)Component.m_237115_((String)"gui.recipe.merge.not_found"));
        }
        GuiComboBoxMapped box = new GuiComboBoxMapped("box", map);
        this.add(box.setExpandableX().setEnabled(!isEmpty));
        GuiLeftRightBox bottom = new GuiLeftRightBox();
        this.add((GuiControl)bottom);
        bottom.addLeft((GuiControl)new GuiButton("cancel", x -> this.closeThisLayer()).setTranslate("gui.cancel"));
        bottom.addRight(new GuiButton("save", x -> {
            GuiTreeItemStructure selected = (GuiTreeItemStructure)box.getSelected();
            if (selected == null) {
                return;
            }
            if (this.isParent(this.structure, selected)) {
                GuiDialogHandler.openDialog((IGuiIntegratedParent)this.getIntegratedParent(), (String)"merge_failed", (MutableComponent)Component.m_237110_((String)"gui.recipe.dialog.merge.failed", (Object[])new Object[]{selected.getTitle(), this.structure.getTitle()}), (g, b) -> {}, (DialogGuiLayer.DialogButton[])new DialogGuiLayer.DialogButton[]{DialogGuiLayer.DialogButton.OK});
            }
            this.recipe.removeItem(selected);
            this.structure.group.add(selected.group);
            int size = this.structure.externalOutputCount();
            for (GuiDialogSignalEvents.GuiSignalEvent event : selected.externalOutputs()) {
                this.structure.setExternalOutput(event.component.index() + size, event);
            }
            for (GuiTreeItem child : selected.items()) {
                this.structure.addItem(child);
            }
            this.structure.refreshAnimation();
            this.recipe.tree.updateTree();
            this.closeThisLayer();
        }).setTranslate("gui.save").setEnabled(!isEmpty));
    }
}

