/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.ingredient;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import team.creative.creativecore.common.util.mc.ColorUtils;
import team.creative.creativecore.common.util.text.TextBuilder;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.api.common.tool.ILittlePlacer;
import team.creative.littletiles.common.action.LittleAction;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.little.registry.LittleBlockRegistry;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.ingredient.BlockIngredient;
import team.creative.littletiles.common.ingredient.BlockIngredientEntry;
import team.creative.littletiles.common.ingredient.ColorIngredient;
import team.creative.littletiles.common.ingredient.IngredientUtils;
import team.creative.littletiles.common.ingredient.ItemIngredient;
import team.creative.littletiles.common.ingredient.ItemIngredientEntry;
import team.creative.littletiles.common.ingredient.LittleIngredientBase;
import team.creative.littletiles.common.ingredient.LittleIngredients;
import team.creative.littletiles.common.ingredient.NotEnoughIngredientsException;
import team.creative.littletiles.common.ingredient.StackIngredient;
import team.creative.littletiles.common.ingredient.StackIngredientEntry;
import team.creative.littletiles.common.item.ItemBlockIngredient;
import team.creative.littletiles.common.item.ItemColorIngredient;
import team.creative.littletiles.common.placement.PlacementHelper;

public abstract class LittleIngredient<T extends LittleIngredient>
extends LittleIngredientBase<T> {
    private static HashMap<Class<? extends LittleIngredient>, Integer> typesInv = new HashMap();
    private static List<Class<? extends LittleIngredient>> types = new ArrayList<Class<? extends LittleIngredient>>();
    private static List<IngredientOverflowHandler> overflowHandlers = new ArrayList<IngredientOverflowHandler>();
    private static List<IngredientConvertionHandler> converationHandlers = new ArrayList<IngredientConvertionHandler>();

    public static int indexOf(LittleIngredient ingredient) {
        return LittleIngredient.indexOf(ingredient.getClass());
    }

    public static int indexOf(Class<? extends LittleIngredient> type) {
        return typesInv.get(type);
    }

    public static List<ItemStack> handleOverflow(LittleIngredient ingredient) throws NotEnoughIngredientsException.NotEnoughSpaceException {
        return overflowHandlers.get(LittleIngredient.indexOf(ingredient)).handleOverflow(ingredient);
    }

    public static int typeCount() {
        return types.size();
    }

    static void extract(LittleIngredients ingredients, LittleGroup group, boolean onlyStructure) {
        if (!onlyStructure) {
            for (IngredientConvertionHandler handler : converationHandlers) {
                ingredients.add((LittleIngredient)handler.extract(group));
            }
        }
        if (group.hasStructure()) {
            group.getStructureType().addIngredients(group, ingredients);
        }
        if (group.hasChildren()) {
            for (LittleGroup child : group.children.all()) {
                LittleIngredient.extract(ingredients, child, onlyStructure);
            }
        }
    }

    public static LittleIngredients extract(LittleElement tile, double volume) {
        LittleIngredients ingredients = new LittleIngredients();
        for (IngredientConvertionHandler handler : converationHandlers) {
            ingredients.add((LittleIngredient)handler.extract(tile, volume));
        }
        return ingredients;
    }

    public static LittleIngredients extract(LittleGroup group) {
        LittleIngredients ingredients = new LittleIngredients();
        LittleIngredient.extract(ingredients, group, false);
        return ingredients;
    }

    public static LittleIngredients extractStructureOnly(LittleGroup group) {
        LittleIngredients ingredients = new LittleIngredients();
        LittleIngredient.extract(ingredients, group, true);
        return ingredients;
    }

    public static LittleIngredients extractWithoutCount(ItemStack stack, boolean useLTStructures) {
        LittleIngredients ingredients = new LittleIngredients();
        ILittlePlacer tile = PlacementHelper.getLittleInterface(stack);
        if (tile != null) {
            if (useLTStructures && tile.hasTiles(stack) && tile.containsIngredients(stack)) {
                LittleIngredient.extract(ingredients, tile.getTiles(stack), false);
            }
        } else {
            for (IngredientConvertionHandler handler : converationHandlers) {
                ingredients.add((LittleIngredient)handler.extract(stack));
            }
        }
        if (ingredients.isEmpty()) {
            return null;
        }
        return ingredients;
    }

    public static boolean handleExtra(LittleIngredient ingredient, ItemStack stack, LittleIngredients overflow) {
        IngredientConvertionHandler handler = converationHandlers.get(LittleIngredient.indexOf(ingredient));
        return handler.requiresExtraHandler() && handler.handleExtra(ingredient, stack, overflow);
    }

    public static <T extends LittleIngredient> void registerType(Class<T> type, IngredientOverflowHandler<T> overflowHandler, IngredientConvertionHandler<T> converationHandler) {
        if (typesInv.containsKey(type)) {
            throw new RuntimeException("Duplicate found! " + types);
        }
        typesInv.put(type, types.size());
        types.add(type);
        overflowHandlers.add(overflowHandler);
        converationHandlers.add(converationHandler);
    }

    @Override
    public abstract T copy();

    public abstract TextBuilder toText();

    @Override
    public abstract T add(T var1);

    @Override
    public abstract T sub(T var1);

    public abstract void scale(int var1);

    public abstract void scaleAdvanced(double var1);

    public abstract int getMinimumCount(T var1, int var2);

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        return this.getClass() == obj.getClass();
    }

    public abstract void print(TextBuilder var1);

    static {
        LittleIngredient.registerType(BlockIngredient.class, new IngredientOverflowHandler<BlockIngredient>(){

            @Override
            public List<ItemStack> handleOverflow(BlockIngredient overflow) throws NotEnoughIngredientsException.NotEnoughSpaceException {
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (BlockIngredientEntry entry : overflow) {
                    ItemStack stack;
                    double volume = entry.value;
                    if (volume >= 1.0) {
                        stack = entry.getBlockStack();
                        stack.m_41764_((int)volume);
                        volume -= (double)stack.m_41613_();
                        stacks.add(stack);
                    }
                    if (!(volume > 0.0)) continue;
                    stack = new ItemStack((ItemLike)LittleTilesRegistry.BLOCK_INGREDIENT.get());
                    stack.m_41751_(new CompoundTag());
                    ItemBlockIngredient.saveIngredient(stack, entry);
                    stacks.add(stack);
                }
                return stacks;
            }
        }, new IngredientConvertionHandler<BlockIngredient>(){

            @Override
            public BlockIngredient extract(ItemStack stack) {
                Block block = Block.m_49814_((Item)stack.m_41720_());
                if (block != null && !(block instanceof AirBlock) && LittleAction.isBlockValid(block.m_49966_())) {
                    BlockIngredient ingredient = new BlockIngredient();
                    ingredient.add(IngredientUtils.getBlockIngredient(LittleBlockRegistry.get(block), 1.0));
                    return ingredient;
                }
                return null;
            }

            @Override
            public BlockIngredient extract(LittleGroup previews) {
                BlockIngredient ingredient = new BlockIngredient();
                if (previews.containsIngredients()) {
                    Iterator<LittleTile> iterator = previews.iterator();
                    while (iterator.hasNext()) {
                        LittleTile preview = iterator.next();
                        ingredient.add(preview.getBlockIngredient(previews.getGrid()));
                    }
                }
                if (ingredient.isEmpty()) {
                    return null;
                }
                return ingredient;
            }

            @Override
            public BlockIngredient extract(LittleElement tile, double volume) {
                BlockIngredient ingredient = new BlockIngredient();
                ingredient.add(IngredientUtils.getBlockIngredient(tile.getBlock(), volume));
                return ingredient;
            }
        });
        LittleIngredient.registerType(ColorIngredient.class, new IngredientOverflowHandler<ColorIngredient>(){

            @Override
            public List<ItemStack> handleOverflow(ColorIngredient overflow) throws NotEnoughIngredientsException.NotEnoughSpaceException {
                ItemStack stack;
                LittleIngredients ingredients = new LittleIngredients(overflow);
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                if (overflow.black > 0) {
                    stack = new ItemStack((ItemLike)LittleTilesRegistry.BLACK_COLOR.get());
                    stack.m_41751_(new CompoundTag());
                    ((ItemColorIngredient)stack.m_41720_()).setInventory(stack, ingredients, null);
                    stacks.add(stack);
                }
                if (overflow.cyan > 0) {
                    stack = new ItemStack((ItemLike)LittleTilesRegistry.CYAN_COLOR.get());
                    stack.m_41751_(new CompoundTag());
                    ((ItemColorIngredient)stack.m_41720_()).setInventory(stack, ingredients, null);
                    stacks.add(stack);
                }
                if (overflow.magenta > 0) {
                    stack = new ItemStack((ItemLike)LittleTilesRegistry.MAGENTA_COLOR.get());
                    stack.m_41751_(new CompoundTag());
                    ((ItemColorIngredient)stack.m_41720_()).setInventory(stack, ingredients, null);
                    stacks.add(stack);
                }
                if (overflow.yellow > 0) {
                    stack = new ItemStack((ItemLike)LittleTilesRegistry.YELLOW_COLOR.get());
                    stack.m_41751_(new CompoundTag());
                    ((ItemColorIngredient)stack.m_41720_()).setInventory(stack, ingredients, null);
                    stacks.add(stack);
                }
                return stacks;
            }
        }, new IngredientConvertionHandler<ColorIngredient>(){

            @Override
            public ColorIngredient extract(ItemStack stack) {
                if (stack.m_41720_() instanceof DyeItem) {
                    DyeColor dyeColor = ((DyeItem)stack.m_41720_()).m_41089_();
                    float[] rgb = dyeColor.m_41068_();
                    ColorIngredient color = ColorIngredient.getColors(ColorUtils.rgb((float)rgb[0], (float)rgb[1], (float)rgb[2]));
                    color.scale(LittleTiles.CONFIG.general.dyeVolume);
                    return color;
                }
                return null;
            }

            @Override
            public ColorIngredient extract(LittleGroup previews) {
                ColorIngredient ingredient = new ColorIngredient();
                if (previews.containsIngredients()) {
                    Iterator<LittleTile> iterator = previews.iterator();
                    while (iterator.hasNext()) {
                        LittleTile preview = iterator.next();
                        ingredient.add(ColorIngredient.getColors(previews.getGrid(), preview));
                    }
                }
                if (ingredient.isEmpty()) {
                    return null;
                }
                return ingredient;
            }

            @Override
            public ColorIngredient extract(LittleElement tile, double volume) {
                ColorIngredient ingredient = new ColorIngredient();
                ingredient.add(ColorIngredient.getColors(tile, volume));
                return ingredient;
            }
        });
        LittleIngredient.registerType(StackIngredient.class, new IngredientOverflowHandler<StackIngredient>(){

            @Override
            public List<ItemStack> handleOverflow(StackIngredient overflow) throws NotEnoughIngredientsException.NotEnoughSpaceException {
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (StackIngredientEntry entry : overflow) {
                    ItemStack stack = entry.stack.m_41777_();
                    stack.m_41764_(entry.count);
                    stacks.add(stack);
                }
                return stacks;
            }
        }, new IngredientConvertionHandler<StackIngredient>(){

            @Override
            public StackIngredient extract(LittleElement tile, double volume) {
                return null;
            }

            @Override
            public StackIngredient extract(LittleGroup previews) {
                return null;
            }

            @Override
            public StackIngredient extract(ItemStack stack) {
                return null;
            }

            @Override
            public boolean requiresExtraHandler() {
                return true;
            }

            @Override
            public boolean handleExtra(StackIngredient ingredient, ItemStack stack, LittleIngredients overflow) {
                StackIngredient stackIngredients = new StackIngredient();
                stackIngredients.add(new StackIngredientEntry(stack, 1));
                int amount = ingredient.getMinimumCount(stackIngredients, stack.m_41613_());
                if (amount > -1) {
                    stackIngredients.scale(amount);
                    overflow.add(ingredient.sub(stackIngredients));
                    stack.m_41774_(amount);
                    if (ingredient.isEmpty()) {
                        return true;
                    }
                }
                return false;
            }
        });
        LittleIngredient.registerType(ItemIngredient.class, new IngredientOverflowHandler<ItemIngredient>(){

            @Override
            public List<ItemStack> handleOverflow(ItemIngredient overflow) throws NotEnoughIngredientsException.NotEnoughSpaceException {
                throw new NotEnoughIngredientsException.NotEnoughSpaceException(overflow);
            }
        }, new IngredientConvertionHandler<ItemIngredient>(){

            @Override
            public ItemIngredient extract(ItemStack stack) {
                return null;
            }

            @Override
            public ItemIngredient extract(LittleGroup group) {
                return null;
            }

            @Override
            public ItemIngredient extract(LittleElement tile, double volume) {
                return null;
            }

            @Override
            public boolean requiresExtraHandler() {
                return true;
            }

            @Override
            public boolean handleExtra(ItemIngredient ingredient, ItemStack stack, LittleIngredients overflow) {
                Iterator<ItemIngredientEntry> itr = ingredient.iterator();
                while (itr.hasNext()) {
                    ItemIngredientEntry entry = itr.next();
                    if (!entry.is(stack)) continue;
                    int count = Math.min(entry.count, stack.m_41613_());
                    stack.m_41774_(count);
                    entry.count -= count;
                    if (entry.isEmpty()) {
                        itr.remove();
                    }
                    if (!ingredient.isEmpty()) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public static abstract class IngredientOverflowHandler<T extends LittleIngredient> {
        public abstract List<ItemStack> handleOverflow(T var1) throws NotEnoughIngredientsException.NotEnoughSpaceException;
    }

    public static abstract class IngredientConvertionHandler<T extends LittleIngredient> {
        public abstract T extract(ItemStack var1);

        public abstract T extract(LittleGroup var1);

        public abstract T extract(LittleElement var1, double var2);

        public boolean requiresExtraHandler() {
            return false;
        }

        public boolean handleExtra(T ingredient, ItemStack stack, LittleIngredients overflow) {
            return false;
        }
    }
}

