/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.item;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.controls.collection.GuiStackSelector;
import team.creative.creativecore.common.gui.controls.simple.GuiColorPicker;
import team.creative.creativecore.common.gui.controls.simple.GuiShowItem;
import team.creative.creativecore.common.gui.controls.simple.GuiSteppedSlider;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.util.inventory.ContainerSlotView;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.mc.TooltipUtils;
import team.creative.creativecore.common.util.registry.NamedHandlerRegistry;
import team.creative.creativecore.common.util.type.Color;
import team.creative.creativecore.common.util.type.list.Pair;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.api.common.tool.ILittlePlacer;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.client.action.LittleActionHandlerClient;
import team.creative.littletiles.common.action.LittleAction;
import team.creative.littletiles.common.action.LittleActionPlace;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.LittleTileContext;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.block.little.tile.group.LittleGroupAbsolute;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;
import team.creative.littletiles.common.block.mc.BlockTile;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.gui.LittleGuiUtils;
import team.creative.littletiles.common.gui.tool.GuiConfigure;
import team.creative.littletiles.common.gui.tool.GuiGlove;
import team.creative.littletiles.common.item.ItemMultiTiles;
import team.creative.littletiles.common.item.tooltip.IItemTooltip;
import team.creative.littletiles.common.level.LittleLevelScanner;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.packet.action.BlockPacket;
import team.creative.littletiles.common.packet.action.VanillaBlockPacket;
import team.creative.littletiles.common.placement.PlacementHelper;
import team.creative.littletiles.common.placement.PlacementPosition;
import team.creative.littletiles.common.placement.PlacementPreview;
import team.creative.littletiles.common.placement.mode.PlacementMode;

public class ItemLittleGlove
extends Item
implements ILittlePlacer,
IItemTooltip {
    public static final NamedHandlerRegistry<GloveMode> MODES = new NamedHandlerRegistry(null);

    public ItemLittleGlove() {
        super(new Item.Properties().m_41487_(1));
    }

    public boolean m_6777_(BlockState state, Level level, BlockPos pos, Player player) {
        return false;
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return 0.0f;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        ItemLittleGlove.getMode(stack).addExtraInformation(stack.m_41783_(), tooltip);
    }

    @Override
    public boolean hasTiles(ItemStack stack) {
        return ItemLittleGlove.getMode(stack).hasTiles(stack);
    }

    @Override
    public LittleGroup getTiles(ItemStack stack) {
        return ItemLittleGlove.getMode(stack).getTiles(stack);
    }

    @Override
    public LittleGroup getLow(ItemStack stack) {
        return this.getTiles(stack);
    }

    @Override
    public PlacementPreview getPlacement(Level level, ItemStack stack, PlacementPosition position, boolean allowLowResolution) {
        return PlacementPreview.relative(level, stack, position, allowLowResolution);
    }

    @Override
    public void saveTiles(ItemStack stack, LittleGroup previews) {
        ItemLittleGlove.getMode(stack).setTiles(previews, stack);
    }

    @Override
    public boolean containsIngredients(ItemStack stack) {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onClickAir(Player player, ItemStack stack) {
        ItemLittleGlove.getMode(stack).leftClickAir(player.f_19853_, player, stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean onClickBlock(Level level, Player player, ItemStack stack, PlacementPosition position, BlockHitResult result) {
        ItemLittleGlove.getMode(stack).leftClickBlock(level, player, stack, result);
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean onRightClick(Level level, Player player, ItemStack stack, PlacementPosition position, BlockHitResult result) {
        return ItemLittleGlove.getMode(stack).rightClickBlock(level, player, stack, result);
    }

    @Override
    public boolean onMouseWheelClickBlock(Level level, Player player, ItemStack stack, PlacementPosition position, BlockHitResult result) {
        return ItemLittleGlove.getMode(stack).wheelClickBlock(level, player, stack, result);
    }

    @Override
    public PlacementMode getPlacementMode(ItemStack stack) {
        return ItemMultiTiles.currentMode;
    }

    @Override
    public GuiConfigure getConfigure(Player player, ContainerSlotView view) {
        return ItemLittleGlove.getMode(view.get()).getGui(player, view, ((ILittlePlacer)view.get().m_41720_()).getPositionGrid(view.get()));
    }

    @Override
    public LittleGrid getPositionGrid(ItemStack stack) {
        return ItemMultiTiles.currentGrid;
    }

    public static GloveMode getMode(ItemStack stack) {
        return (GloveMode)MODES.get(stack.m_41784_().m_128461_("mode"));
    }

    public static void setMode(ItemStack stack, GloveMode mode) {
        stack.m_41784_().m_128359_("mode", MODES.getId((Object)mode));
    }

    @Override
    public Object[] tooltipData(ItemStack stack) {
        return new Object[]{Component.m_237115_((String)ItemLittleGlove.getMode((ItemStack)stack).title), LittleTilesClient.configure.m_90863_()};
    }

    static {
        MODES.registerDefault("pixel", (Object)new PixelMode());
        MODES.register("place_preview", (Object)new PlacePreviewMode());
        MODES.register("replace", (Object)new ReplaceMode());
    }

    public static abstract class GloveMode {
        public final String title;

        public GloveMode(String name) {
            this.title = "grabber.mode." + name;
        }

        public void addExtraInformation(CompoundTag nbt, List<Component> tooltip) {
        }

        @OnlyIn(value=Dist.CLIENT)
        public void leftClickAir(Level level, Player player, ItemStack stack) {
        }

        @OnlyIn(value=Dist.CLIENT)
        public void leftClickBlock(Level level, Player player, ItemStack stack, BlockHitResult result) {
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean rightClickBlock(Level level, Player player, ItemStack stack, BlockHitResult result) {
            return true;
        }

        @OnlyIn(value=Dist.CLIENT)
        public abstract boolean wheelClickBlock(Level var1, Player var2, ItemStack var3, BlockHitResult var4);

        @OnlyIn(value=Dist.CLIENT)
        public abstract boolean renderBlockSeparately(ItemStack var1);

        @OnlyIn(value=Dist.CLIENT)
        public abstract GuiConfigure getGui(Player var1, ContainerSlotView var2, LittleGrid var3);

        public boolean hasTiles(ItemStack stack) {
            return true;
        }

        public abstract LittleGroup getTiles(ItemStack var1);

        public abstract void setTiles(LittleGroup var1, ItemStack var2);

        public abstract LittleElement getSeparateRenderingPreview(ItemStack var1);

        public abstract void vanillaBlockAction(Level var1, ItemStack var2, BlockPos var3, BlockState var4);

        public abstract void littleBlockAction(Level var1, BETiles var2, LittleTileContext var3, ItemStack var4, BlockPos var5, CompoundTag var6);
    }

    public static class PixelMode
    extends SimpleMode {
        public PixelMode() {
            super("pixel");
        }

        @Override
        public GuiConfigure getGui(Player player, final ContainerSlotView view, LittleGrid grid) {
            return new GuiGlove(this, view, 140, 140, grid){
                public LittleVec size;
                {
                    super(mode, view2, width, height, grid);
                    this.registerEventClick(x -> {
                        if (x.control.is("sliced")) {
                            this.updateLabel();
                        }
                    });
                    this.registerEventChanged(x -> {
                        this.size.x = (int)((GuiSteppedSlider)this.get((String)"sizeX")).value;
                        this.size.y = (int)((GuiSteppedSlider)this.get((String)"sizeY")).value;
                        this.size.z = (int)((GuiSteppedSlider)this.get((String)"sizeZ")).value;
                        this.updateLabel();
                    });
                }

                @Override
                public void create() {
                    super.create();
                    LittleGrid oldContext = LittleGrid.get(view.get().m_41783_());
                    LittleElement element = SimpleMode.getElement(view.get());
                    LittleBox box = PixelMode.getBox(view.get());
                    if (oldContext != this.grid) {
                        box.convertTo(oldContext, this.grid);
                    }
                    if (box.minX == box.maxX) {
                        ++box.maxX;
                    }
                    if (box.minY == box.maxY) {
                        ++box.maxY;
                    }
                    if (box.minZ == box.maxZ) {
                        ++box.maxZ;
                    }
                    this.size = box.getSize();
                    this.add((GuiControl)new GuiSteppedSlider("sizeX", this.size.x, 1, this.grid.count));
                    this.add((GuiControl)new GuiSteppedSlider("sizeY", this.size.y, 1, this.grid.count));
                    this.add((GuiControl)new GuiSteppedSlider("sizeZ", this.size.z, 1, this.grid.count));
                    this.add((GuiControl)new GuiColorPicker("picker", new Color(element.color), LittleTiles.CONFIG.isTransparencyEnabled(this.getPlayer()), LittleTiles.CONFIG.getMinimumTransparency(this.getPlayer())));
                    this.add(new GuiShowItem("item", ItemStack.f_41583_).setDim(32, 32));
                    GuiStackSelector selector = new GuiStackSelector("preview", this.getPlayer(), LittleGuiUtils.getCollector(this.getPlayer()), true);
                    selector.setSelectedForce(element.getBlock().getStack());
                    this.add((GuiControl)selector);
                    this.updateLabel();
                }

                public LittleElement getElement() {
                    GuiStackSelector selector = (GuiStackSelector)this.get("preview");
                    GuiColorPicker picker = (GuiColorPicker)this.get("picker");
                    ItemStack selected = selector.getSelected();
                    if (!selected.m_41619_() && selected.m_41720_() instanceof BlockItem) {
                        return new LittleElement(Block.m_49814_((Item)selected.m_41720_()).m_49966_(), picker.color.toInt());
                    }
                    return SimpleMode.getElement(view.get());
                }

                public LittleBox getBox() {
                    return new LittleBox(0, 0, 0, this.size.x, this.size.y, this.size.z);
                }

                public void updateLabel() {
                    ((GuiShowItem)this.get((String)"avatar")).stack = ItemMultiTiles.of(this.getElement(), this.grid, this.getBox());
                }

                @Override
                public CompoundTag saveConfiguration(CompoundTag nbt) {
                    SimpleMode.setElement(nbt, this.getElement());
                    PixelMode.setBox(nbt, this.getBox());
                    this.grid.set(nbt);
                    return super.saveConfiguration(nbt);
                }
            };
        }

        @Override
        public void addExtraInformation(CompoundTag nbt, List<Component> tooltip) {
            super.addExtraInformation(nbt, tooltip);
            tooltip.add((Component)Component.m_237113_((String)TooltipUtils.printColor((int)SimpleMode.getElement((CompoundTag)nbt).color)));
        }

        @Override
        public LittleGroup getTiles(ItemStack stack) {
            LittleGroup group = new LittleGroup();
            group.addTile(LittleGrid.get(stack.m_41783_()), new LittleTile(SimpleMode.getElement(stack), PixelMode.getBox(stack)));
            return group;
        }

        public static LittleBox getBox(ItemStack stack) {
            if (stack.m_41784_().m_128441_("box")) {
                return LittleBox.create(stack.m_41783_().m_128465_("box"));
            }
            LittleBox box = new LittleBox(0, 0, 0, 1, 1, 1);
            PixelMode.setBox(stack.m_41784_(), box);
            return box;
        }

        public static void setBox(CompoundTag nbt, LittleBox box) {
            nbt.m_128385_("box", box.getArray());
        }

        @Override
        public void setTiles(LittleGroup previews, ItemStack stack) {
        }
    }

    public static class PlacePreviewMode
    extends GloveMode {
        public PlacePreviewMode() {
            super("place_preview");
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public boolean wheelClickBlock(Level level, Player player, ItemStack stack, BlockHitResult result) {
            BlockState state = level.m_8055_(result.m_82425_());
            if (state.m_60734_() instanceof BlockTile) {
                CompoundTag nbt = new CompoundTag();
                nbt.m_128379_("secondMode", LittleActionHandlerClient.isUsingSecondMode());
                LittleTiles.NETWORK.sendToServer((CreativePacket)new BlockPacket(level, result.m_82425_(), player, BlockPacket.BlockPacketAction.GRABBER, nbt));
                return true;
            }
            return false;
        }

        @Override
        public void littleBlockAction(Level level, BETiles be, LittleTileContext context, ItemStack stack, BlockPos pos, CompoundTag nbt) {
            LittleGroup previews = new LittleGroup();
            if (nbt.m_128471_("secondMode")) {
                for (Pair<IParentCollection, LittleTile> pair : be.allTiles()) {
                    previews.add(((IParentCollection)pair.key).getGrid(), (LittleElement)pair.value, (Iterable)pair.value);
                }
            } else {
                previews.add(context.parent.getGrid(), (LittleElement)context.tile, context.box);
            }
            stack.m_41784_().m_128365_("tiles", (Tag)LittleGroup.save(previews));
        }

        public static LittleGroup getPreviews(ItemStack stack) {
            if (stack.m_41784_().m_128441_("tiles")) {
                return LittleGroup.load(stack.m_41698_("tiles"));
            }
            LittleGroup group = new LittleGroup();
            group.add(LittleGrid.defaultGrid(), new LittleElement(Blocks.f_50069_.m_49966_(), -1), new LittleBox(0, 0, 0, 1, 1, 1));
            stack.m_41784_().m_128365_("tiles", (Tag)LittleGroup.save(group));
            return group;
        }

        public static BlockPos getOrigin(ItemStack stack) {
            CompoundTag nbt = stack.m_41784_();
            return new BlockPos(nbt.m_128451_("ox"), nbt.m_128451_("oy"), nbt.m_128451_("oz"));
        }

        public static void setOrigin(ItemStack stack, BlockPos pos) {
            CompoundTag nbt = stack.m_41784_();
            nbt.m_128405_("ox", pos.m_123341_());
            nbt.m_128405_("oy", pos.m_123342_());
            nbt.m_128405_("oz", pos.m_123343_());
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public boolean renderBlockSeparately(ItemStack stack) {
            return false;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public GuiConfigure getGui(Player player, ContainerSlotView view, LittleGrid grid) {
            return new GuiGlove(this, view, 140, 140, grid){};
        }

        @Override
        public LittleGroup getTiles(ItemStack stack) {
            return PlacePreviewMode.getPreviews(stack);
        }

        @Override
        public void setTiles(LittleGroup previews, ItemStack stack) {
            stack.m_41784_().m_128365_("tiles", (Tag)LittleGroup.save(previews));
        }

        @Override
        public LittleElement getSeparateRenderingPreview(ItemStack stack) {
            return null;
        }

        @Override
        public void vanillaBlockAction(Level level, ItemStack stack, BlockPos pos, BlockState state) {
        }
    }

    public static class ReplaceMode
    extends SimpleMode {
        public ReplaceMode() {
            super("replace");
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public GuiGlove getGui(Player player, final ContainerSlotView view, LittleGrid grid) {
            return new GuiGlove(this, view, 140, 140, grid){

                @Override
                public void create() {
                    super.create();
                    LittleElement element = SimpleMode.getElement(view.get());
                    this.add((GuiControl)new GuiColorPicker("picker", new Color(element.color), LittleTiles.CONFIG.isTransparencyEnabled(this.getPlayer()), LittleTiles.CONFIG.getMinimumTransparency(this.getPlayer())));
                    GuiStackSelector selector = new GuiStackSelector("preview", this.getPlayer(), LittleGuiUtils.getCollector(this.getPlayer()), true);
                    selector.setSelectedForce(element.getBlock().getStack());
                    this.add((GuiControl)selector);
                }

                public LittleElement getElement() {
                    GuiStackSelector selector = (GuiStackSelector)this.get("preview");
                    GuiColorPicker picker = (GuiColorPicker)this.get("picker");
                    ItemStack selected = selector.getSelected();
                    if (!selected.m_41619_() && selected.m_41720_() instanceof BlockItem) {
                        return new LittleElement(Block.m_49814_((Item)selected.m_41720_()).m_49966_(), picker.color.toInt());
                    }
                    return SimpleMode.getElement(view.get());
                }

                @Override
                public CompoundTag saveConfiguration(CompoundTag nbt) {
                    SimpleMode.setElement(nbt, this.getElement());
                    return super.saveConfiguration(nbt);
                }
            };
        }

        @Override
        public boolean hasTiles(ItemStack stack) {
            return false;
        }

        @Override
        public boolean rightClickBlock(Level level, Player player, ItemStack stack, BlockHitResult result) {
            if (PlacementHelper.canBlockBeUsed(level, result.m_82425_())) {
                return LittleTilesClient.ACTION_HANDLER.execute(new LittleActionPlace(LittleActionPlace.PlaceAction.ABSOLUTE, PlacementPreview.absolute(level, PlacementMode.replace, new LittleGroupAbsolute(LittleLevelScanner.scan(level, result.m_82425_(), null), ReplaceMode.getElement(stack)), Facing.get((Direction)result.m_82434_()))));
            }
            return false;
        }

        @Override
        public LittleElement getSeparateRenderingPreview(ItemStack stack) {
            return SimpleMode.getElement(stack);
        }

        @Override
        public LittleGroup getTiles(ItemStack stack) {
            return null;
        }

        @Override
        public void setTiles(LittleGroup previews, ItemStack stack) {
        }
    }

    public static abstract class SimpleMode
    extends GloveMode {
        public SimpleMode(String name) {
            super(name);
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public boolean wheelClickBlock(Level level, Player player, ItemStack stack, BlockHitResult result) {
            BlockState state = level.m_8055_(result.m_82425_());
            if (LittleAction.isBlockValid(state)) {
                LittleTiles.NETWORK.sendToServer((CreativePacket)new VanillaBlockPacket(result.m_82425_(), VanillaBlockPacket.VanillaBlockAction.GRABBER));
                return true;
            }
            if (state.m_60734_() instanceof BlockTile) {
                CompoundTag nbt = new CompoundTag();
                nbt.m_128379_("secondMode", LittleActionHandlerClient.isUsingSecondMode());
                LittleTiles.NETWORK.sendToServer((CreativePacket)new BlockPacket(level, result.m_82425_(), player, BlockPacket.BlockPacketAction.GRABBER, nbt));
                return true;
            }
            return false;
        }

        public LittleGrid getGrid(ItemStack stack) {
            return LittleGrid.get(stack.m_41783_());
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public boolean renderBlockSeparately(ItemStack stack) {
            return true;
        }

        @Override
        public void vanillaBlockAction(Level level, ItemStack stack, BlockPos pos, BlockState state) {
            if (LittleAction.isBlockValid(state)) {
                SimpleMode.setElement(stack, new LittleElement(state, -1));
            }
        }

        @Override
        public void littleBlockAction(Level level, BETiles be, LittleTileContext context, ItemStack stack, BlockPos pos, CompoundTag nbt) {
            if (LittleAction.isBlockValid(context.tile.getState())) {
                SimpleMode.setElement(stack, new LittleElement(context.tile.getState(), -1));
            }
        }

        @Override
        public LittleElement getSeparateRenderingPreview(ItemStack stack) {
            return SimpleMode.getElement(stack);
        }

        public static LittleElement getElement(ItemStack stack) {
            if (stack.m_41784_().m_128441_("element")) {
                return new LittleElement(stack.m_41698_("element"));
            }
            LittleElement element = new LittleElement(Blocks.f_50069_.m_49966_(), -1);
            SimpleMode.setElement(stack, element);
            return element;
        }

        public static LittleElement getElement(CompoundTag nbt) {
            if (nbt.m_128441_("element")) {
                return new LittleElement(nbt.m_128469_("element"));
            }
            LittleElement element = new LittleElement(Blocks.f_50069_.m_49966_(), -1);
            nbt.m_128365_("element", (Tag)element.save(new CompoundTag()));
            return element;
        }

        public static void setElement(ItemStack stack, LittleElement element) {
            element.save(stack.m_41698_("element"));
        }

        public static void setElement(CompoundTag nbt, LittleElement element) {
            nbt.m_128365_("element", (Tag)element.save(new CompoundTag()));
        }
    }
}

