/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.item;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import team.creative.creativecore.common.util.inventory.ContainerSlotView;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.littletiles.LittleTilesGuiRegistry;
import team.creative.littletiles.api.common.ingredient.ILittleIngredientInventory;
import team.creative.littletiles.api.common.tool.ILittlePlacer;
import team.creative.littletiles.api.common.tool.ILittleTool;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.common.action.LittleAction;
import team.creative.littletiles.common.action.LittleActionPlace;
import team.creative.littletiles.common.gui.tool.GuiConfigure;
import team.creative.littletiles.common.ingredient.LittleIngredients;
import team.creative.littletiles.common.ingredient.LittleInventory;
import team.creative.littletiles.common.ingredient.NotEnoughIngredientsException;
import team.creative.littletiles.common.math.vec.LittleHitResult;
import team.creative.littletiles.common.placement.PlacementPosition;
import team.creative.littletiles.common.placement.PlacementPreview;

public class LittleToolHandler {
    public static ItemStack lastSelectedItem = null;
    public static ILittleTool tool = null;
    private boolean leftClicked;

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onMouseWheelClick(InputEvent.InteractionKeyMappingTriggered event) {
        HitResult hitResult;
        if (!event.isPickBlock()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91077_.m_6662_() == HitResult.Type.BLOCK && (hitResult = mc.f_91077_) instanceof BlockHitResult) {
            BlockHitResult hit = (BlockHitResult)hitResult;
            stack = mc.f_91074_.m_21205_();
            if (stack.m_41720_() instanceof ILittleTool && ((ILittleTool)stack.m_41720_()).onMouseWheelClickBlock((Level)mc.f_91073_, (Player)mc.f_91074_, (ItemStack)stack, new PlacementPosition(hit, ((ILittleTool)stack.m_41720_()).getPositionGrid((ItemStack)stack)), hit)) {
                event.setCanceled(true);
            }
        } else {
            LittleHitResult result;
            stack = mc.f_91077_;
            if (stack instanceof LittleHitResult && (result = (LittleHitResult)stack).isBlock() && (stack = mc.f_91074_.m_21205_()).m_41720_() instanceof ILittleTool && ((ILittleTool)stack.m_41720_()).onMouseWheelClickBlock((Level)result.level, (Player)mc.f_91074_, (ItemStack)stack, new PlacementPosition(result.asBlockHit(), ((ILittleTool)stack.m_41720_()).getPositionGrid((ItemStack)stack)), result.asBlockHit())) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onLeftClickAir(PlayerInteractEvent.LeftClickEmpty event) {
        ItemStack stack;
        if (event.getLevel().f_46443_ && (stack = event.getItemStack()).m_41720_() instanceof ILittleTool) {
            ((ILittleTool)stack.m_41720_()).onClickAir(event.getEntity(), stack);
        }
    }

    @SubscribeEvent
    public void onLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getLevel().f_46443_) {
            if (!this.leftClicked) {
                ItemStack stack = event.getItemStack();
                if (!(Minecraft.m_91087_().f_91077_ instanceof BlockHitResult)) {
                    return;
                }
                BlockHitResult ray = (BlockHitResult)Minecraft.m_91087_().f_91077_;
                if (lastSelectedItem != null && lastSelectedItem.m_41720_() != stack.m_41720_()) {
                    tool.onClickAir(event.getEntity(), lastSelectedItem);
                    lastSelectedItem = null;
                }
                if (stack.m_41720_() instanceof ILittleTool) {
                    PlacementPosition position = LittleTilesClient.PREVIEW_RENDERER.getPosition(event.getLevel(), stack, ray);
                    if (((ILittleTool)stack.m_41720_()).onClickBlock(event.getLevel(), event.getEntity(), stack, position, ray)) {
                        event.setCanceled(true);
                    }
                    tool = (ILittleTool)stack.m_41720_();
                    lastSelectedItem = stack;
                }
                this.leftClicked = true;
            }
        } else if (event.getItemStack().m_41720_() instanceof ILittleTool) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void breakSpeed(PlayerEvent.BreakSpeed event) {
        ItemStack stack = event.getEntity().m_21205_();
        if (stack.m_41720_() instanceof ILittleTool) {
            event.setNewSpeed(0.0f);
        }
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getEntity().m_21205_();
        if (stack.m_41720_() instanceof ILittleTool && event.getHand() == InteractionHand.MAIN_HAND && event.getLevel().f_46443_ && this.onRightInteractClient((ILittleTool)stack.m_41720_(), event.getEntity(), event.getHand(), event.getLevel(), stack, event.getPos(), Facing.get((Direction)event.getFace()))) {
            event.setCanceled(true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean onRightInteractClient(ILittleTool iTile, Player player, InteractionHand hand, Level level, ItemStack stack, BlockPos pos, Facing facing) {
        ILittlePlacer placer;
        HitResult result = Minecraft.m_91087_().f_91077_;
        if (!(result instanceof BlockHitResult)) {
            return false;
        }
        PlacementPosition position = LittleTilesClient.PREVIEW_RENDERER.getPosition(level, stack, (BlockHitResult)result);
        if (iTile.onRightClick(level, player, stack, position.copy(), (BlockHitResult)result) && iTile instanceof ILittlePlacer && (placer = (ILittlePlacer)iTile).hasTiles(stack)) {
            PlacementPreview preview = placer.getPlacement(level, stack, position, false);
            if (preview == null) {
                return true;
            }
            LittleTilesClient.ACTION_HANDLER.execute(new LittleActionPlace(LittleActionPlace.PlaceAction.CURRENT_ITEM, preview));
            LittleTilesClient.PREVIEW_RENDERER.removeMarked();
            iTile.onDeselect(level, stack, player);
            return true;
        }
        return false;
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Minecraft mc = Minecraft.m_91087_();
            if (this.leftClicked && !mc.f_91066_.f_92096_.m_90857_()) {
                this.leftClicked = false;
            }
            if (mc.f_91074_ != null) {
                ItemStack stack = mc.f_91074_.m_21205_();
                if (lastSelectedItem != null && lastSelectedItem.m_41720_() != stack.m_41720_()) {
                    tool.onDeselect((Level)mc.f_91073_, lastSelectedItem, (Player)mc.f_91074_);
                    lastSelectedItem = null;
                }
                while (LittleTilesClient.configure.m_90859_()) {
                    GuiConfigure gui;
                    if (!(stack.m_41720_() instanceof ILittleTool) || (gui = ((ILittleTool)stack.m_41720_()).getConfigure((Player)mc.f_91074_, ContainerSlotView.mainHand((Player)mc.f_91074_))) == null) continue;
                    LittleTilesGuiRegistry.OPEN_CONFIG.open((Player)mc.f_91074_);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPickup(EntityItemPickupEvent event) {
        Player player = event.getEntity();
        ItemEntity entityItem = event.getItem();
        ItemStack stack = entityItem.m_32055_();
        if (stack.m_41720_() instanceof ILittleIngredientInventory && ((ILittleIngredientInventory)stack.m_41720_()).shouldBeMerged()) {
            LittleIngredients ingredients = ((ILittleIngredientInventory)stack.m_41720_()).getInventory(stack);
            LittleInventory inventory = new LittleInventory(player);
            inventory.allowDrop = false;
            if (ingredients == null) {
                entityItem.m_6074_();
                event.setCanceled(true);
                event.setResult(Event.Result.DENY);
                return;
            }
            try {
                if (LittleAction.canGive(player, inventory, ingredients)) {
                    LittleAction.give(player, inventory, ingredients);
                    player.m_21053_(entityItem);
                    entityItem.m_6074_();
                    event.setCanceled(true);
                    event.setResult(Event.Result.DENY);
                }
            }
            catch (NotEnoughIngredientsException notEnoughIngredientsException) {
                // empty catch block
            }
        }
    }
}

